/*
 * Decompiled with CFR 0.152.
 */
package manifold.preprocessor.definitions;

import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.util.HashMap;
import java.util.Map;
import manifold.internal.javac.JavacPlugin;
import manifold.preprocessor.definitions.SystemInfo;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class EnvironmentDefinitions {
    public static final String JAVA_ = "JAVA_";
    public static final String _OR_LATER = "_OR_LATER";
    public static final String JPMS_NONE = "JPMS_NONE";
    public static final String JPMS_UNNAMED = "JPMS_UNNAMED";
    public static final String JPMS_NAMED = "JPMS_NAMED";
    public static final String OS_FREE_BSD = "OS_FREEBSD";
    public static final String OS_LINUX = "OS_LINUX";
    public static final String OS_MAC = "OS_MAC";
    public static final String OS_SOLARIS = "OS_SOLARIS";
    public static final String OS_UNIX = "OS_UNIX";
    public static final String OS_WINDOWS = "OS_WINDOWS";
    public static final String ARCH_32 = "ARCH_32";
    public static final String ARCH_64 = "ARCH_64";
    private static LocklessLazyVar<EnvironmentDefinitions> INSTANCE = LocklessLazyVar.make(() -> new EnvironmentDefinitions());
    private final Map<String, String> _env;

    static EnvironmentDefinitions instance() {
        return INSTANCE.get();
    }

    public EnvironmentDefinitions() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.addArchitecture(map);
        this.addOperatingSystem(map);
        this.addJavacEnvironment(map);
        this.addJpms(map);
        this.addMisc(map);
        this._env = map;
    }

    public Map<String, String> getEnv() {
        return this._env;
    }

    protected void addJpms(Map<String, String> map) {
        if (JavacPlugin.instance() == null) {
            return;
        }
        Context ctx = JavacPlugin.instance().getContext();
        if (JreUtil.isJava8()) {
            map.put(JPMS_NONE, "");
        } else {
            Object modulesUtil = ReflectUtil.method(ReflectUtil.type("com.sun.tools.javac.comp.Modules"), "instance", ReflectUtil.type("com.sun.tools.javac.util.Context")).invokeStatic(ctx);
            Object defModule = ReflectUtil.method(modulesUtil, "getDefaultModule", new Class[0]).invoke(new Object[0]);
            if (defModule == null || ((Boolean)ReflectUtil.method(defModule, "isNoModule", new Class[0]).invoke(new Object[0])).booleanValue()) {
                map.put(JPMS_NONE, "");
            } else if (((Boolean)ReflectUtil.method(defModule, "isUnnamed", new Class[0]).invoke(new Object[0])).booleanValue()) {
                map.put(JPMS_UNNAMED, "");
            } else {
                map.put(JPMS_NAMED, "");
            }
        }
    }

    protected void addJavacEnvironment(Map<String, String> map) {
        if (JavacPlugin.instance() == null) {
            return;
        }
        JavacProcessingEnvironment jpe = JavacProcessingEnvironment.instance(JavacPlugin.instance().getContext());
        this.addJavaVersion(map, jpe);
        this.addAnnotationOptions(map, jpe);
    }

    protected void addAnnotationOptions(Map<String, String> map, JavacProcessingEnvironment jpe) {
        Map<String, String> options = jpe.getOptions();
        if (options != null) {
            map.putAll(options);
        }
    }

    protected void addJavaVersion(Map<String, String> map, JavacProcessingEnvironment jpe) {
        int version = jpe.getSourceVersion().ordinal();
        this.makeJavaVersionDefinitions(map, version);
    }

    protected void makeJavaVersionDefinitions(Map<String, String> map, int version) {
        map.put(JAVA_ + version, "");
        for (int i = 2; i <= version; ++i) {
            map.put(JAVA_ + i + _OR_LATER, "");
        }
    }

    protected void addOperatingSystem(Map<String, String> map) {
        if (SystemInfo.isFreeBSD) {
            map.put(OS_FREE_BSD, "");
        } else if (SystemInfo.isLinux) {
            map.put(OS_LINUX, "");
        } else if (SystemInfo.isMac) {
            map.put(OS_MAC, "");
        } else if (SystemInfo.isSolaris) {
            map.put(OS_SOLARIS, "");
        } else if (SystemInfo.isUnix) {
            map.put(OS_UNIX, "");
        } else if (SystemInfo.isWindows) {
            map.put(OS_WINDOWS, "");
        }
    }

    protected void addArchitecture(Map<String, String> map) {
        if (SystemInfo.is32Bit) {
            map.put(ARCH_32, "");
        } else if (SystemInfo.is64Bit) {
            map.put(ARCH_64, "");
        }
    }

    protected void addMisc(Map<String, String> map) {
    }
}

