/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.tools.JavaFileObject;
import manifold.api.type.IPreprocessor;
import manifold.rt.api.util.ServiceUtil;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class Preprocessor {
    private static final Context.Key<Preprocessor> preprocessorKey = new Context.Key();
    private static final LocklessLazyVar<List<IPreprocessor>> _registeredPreprocessors = LocklessLazyVar.make(() -> {
        HashSet registered = new HashSet();
        ServiceUtil.loadRegisteredServices(registered, IPreprocessor.class, Preprocessor.class.getClassLoader());
        ArrayList<IPreprocessor> processors = new ArrayList<IPreprocessor>(registered);
        processors.sort(Comparator.comparingInt(p -> p.getPreferredOrder().ordinal()));
        return processors;
    });
    private final ParserFactory _parserFactory;

    public static Preprocessor instance(Context context) {
        Preprocessor instance = context.get(preprocessorKey);
        if (instance == null) {
            instance = new Preprocessor(context);
        }
        return instance;
    }

    private Preprocessor(Context context) {
        this._parserFactory = (ParserFactory)ReflectUtil.method("manifold.internal.javac.ManParserFactory_" + (JreUtil.isJava17orLater() ? 17 : 8), "instance", Context.class).invokeStatic(context);
    }

    public CharSequence process(JavaFileObject sourceFile, CharSequence input) {
        for (IPreprocessor preprocessor : Objects.requireNonNull(_registeredPreprocessors.get())) {
            input = preprocessor.process(sourceFile.toUri(), input);
        }
        return input;
    }
}

