/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Lower;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TransTypes;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import manifold.api.host.IModule;
import manifold.api.type.ISelfCompiledFile;
import manifold.api.type.ITypeManifold;
import manifold.api.util.IssueMsg;
import manifold.internal.javac.FragmentProcessor;
import manifold.internal.javac.HostKind;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.ITupleTypeProvider;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManAttr;
import manifold.internal.javac.ManLog_8;
import manifold.internal.javac.ManResolve;
import manifold.internal.javac.ManifoldJavaFileManager;
import manifold.internal.javac.ParserFactoryFiles;
import manifold.internal.javac.RecursiveTypeVarEraser;
import manifold.rt.api.FragmentValue;
import manifold.rt.api.util.ManClassUtil;
import manifold.rt.api.util.Stack;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class ManAttr_8
extends Attr
implements ManAttr {
    private final ManLog_8 _manLog;
    private final Symtab _syms;
    private final Stack<JCTree.JCFieldAccess> _selects;
    private final Stack<JCTree.JCMethodInvocation> _applys;
    private final Stack<JCTree.JCAnnotatedType> _annotatedTypes;
    private final Stack<JCTree.JCMethodDecl> _methodDefs;
    private final Set<JCTree.JCMethodInvocation> _visitedAutoMethodCalls = new HashSet<JCTree.JCMethodInvocation>();

    public static ManAttr_8 instance(Context ctx) {
        Attr attr = (Attr)ctx.get(attrKey);
        if (!(attr instanceof ManAttr_8)) {
            ctx.put(attrKey, (Attr)null);
            attr = new ManAttr_8(ctx);
        }
        return (ManAttr_8)attr;
    }

    private ManAttr_8(Context ctx) {
        super(ctx);
        this._selects = new Stack();
        this._applys = new Stack();
        this._annotatedTypes = new Stack();
        this._methodDefs = new Stack();
        this._syms = Symtab.instance(ctx);
        this._manLog = (ManLog_8)ManLog_8.instance(ctx);
        ReflectUtil.field(this, "log").set(this._manLog);
        ReflectUtil.field(this, "rs").set(ManResolve.instance(ctx));
        this.reassignAllEarlyHolders(ctx);
    }

    private void reassignAllEarlyHolders(Context ctx) {
        Object[] earlyAttrHolders;
        for (Object instance : earlyAttrHolders = new Object[]{Resolve.instance(ctx), DeferredAttr.instance(ctx), MemberEnter.instance(ctx), Lower.instance(ctx), TransTypes.instance(ctx), Annotate.instance(ctx), TypeAnnotations.instance(ctx), JavacTrees.instance(ctx), JavaCompiler.instance(ctx)}) {
            ReflectUtil.LiveFieldRef attr = ReflectUtil.WithNull.field(instance, "attr");
            if (attr == null) continue;
            attr.set(this);
        }
    }

    @Override
    public Type attribType(JCTree tree, Env<AttrContext> env) {
        ManAttr.super.handleNonStaticInterfaceProperty(env);
        return super.attribType(tree, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        this._selects.push(tree);
        try {
            JCTree.JCMethodInvocation parent = this.peekApply();
            ManAttr.DeferredAttrDiagHandler deferredAttrDiagHandler = null;
            if (parent == null || parent.meth != tree) {
                deferredAttrDiagHandler = this.suppressDiagnositics(tree);
            }
            try {
                super.visitSelect(tree);
            }
            finally {
                if (deferredAttrDiagHandler != null) {
                    this.restoreDiagnostics(tree, deferredAttrDiagHandler);
                }
            }
            this.patchAutoFieldType(tree);
        }
        finally {
            this._selects.pop();
        }
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        Env env = this.getEnv();
        Env<Object> localEnv = env.dup(tree, ReflectUtil.method(env.info, "dup", new Class[0]).invoke(new Object[0]));
        for (JCTree.JCVariableDecl jCVariableDecl : tree.defs) {
            this.attribStat(jCVariableDecl, localEnv);
            jCVariableDecl.vartype.type = jCVariableDecl.type = jCVariableDecl.init.type;
            jCVariableDecl.sym.type = jCVariableDecl.type;
        }
        ReflectUtil.field(this, "result").set(this.attribExpr(tree.expr, localEnv));
        tree.type = tree.expr.type;
    }

    private boolean shouldCheckSuperType(Type type) {
        return this._shouldCheckSuperType(type, true);
    }

    private boolean _shouldCheckSuperType(Type type, boolean checkSuper) {
        return type instanceof Type.ClassType && type != Type.noType && !(type instanceof Type.ErrorType) && !type.toString().equals(Object.class.getTypeName()) && (!checkSuper || this._shouldCheckSuperType(((Symbol.ClassSymbol)type.tsym).getSuperclass(), false));
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        JCTree returnType = tree.getReturnType();
        if (this.isAutoTypeAssigned(returnType)) {
            return;
        }
        this._methodDefs.push(tree);
        try {
            super.visitMethodDef(tree);
            this.handleIntersectionAutoReturnType(tree);
        }
        finally {
            this._methodDefs.pop();
        }
    }

    private void handleIntersectionAutoReturnType(JCTree.JCMethodDecl tree) {
        if (tree.restype != null && tree.restype.type.isCompound()) {
            Type retType = tree.restype.type;
            retType = (Type)ReflectUtil.field(retType, "supertype_field").get();
            List interfaces = (List)ReflectUtil.field(tree.restype.type, "interfaces_field").get();
            if (!interfaces.isEmpty() && this.types().isSameType(this.syms().objectType, retType)) {
                int maxMemberCount = -1;
                for (Type t : interfaces) {
                    int[] memberCount = new int[]{0};
                    IDynamicJdk.instance().getMembers((Symbol.ClassSymbol)t.tsym).forEach(m -> {
                        memberCount[0] = memberCount[0] + 1;
                    });
                    if (maxMemberCount >= memberCount[0]) continue;
                    maxMemberCount = memberCount[0];
                    retType = t;
                }
            }
            this.assignMethodReturnType(retType, tree);
        }
    }

    private boolean isAutoTypeAssigned(JCTree returnType) {
        return returnType != null && (returnType.toString().equals(ManClassUtil.getShortClassName("manifold.ext.rt.api.auto")) || returnType.toString().equals("manifold.ext.rt.api.auto")) && !"manifold.ext.rt.api.auto".equals(returnType.type.tsym.flatName().toString());
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        super.visitVarDef(tree);
        this.inferAutoLocalVar(tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        Env env = this.getEnv();
        Env<AttrContext> loopEnv = env.dup(env.tree, (AttrContext)ReflectUtil.method(env.info, "dup", Scope.class).invoke(ReflectUtil.method(ReflectUtil.field(env.info, "scope").get(), "dup", new Class[0]).invoke(new Object[0])));
        try {
            Type exprType = this.types().cvarUpperBound(this.attribExpr(tree.expr, loopEnv));
            this.attribStat(tree.var, loopEnv);
            ReflectUtil.method(this.chk(), "checkNonVoid", JCDiagnostic.DiagnosticPosition.class, Type.class).invoke(tree.pos(), exprType);
            Type elemtype = this.types().elemtype(exprType);
            if (elemtype == null) {
                Type base = this.types().asSuper(exprType, this.syms().iterableType.tsym);
                if (base == null) {
                    this.getLogger().error(tree.expr.pos(), "foreach.not.applicable.to.type", new Object[]{exprType, ReflectUtil.method(ReflectUtil.field(this, "diags").get(), "fragment", String.class).invoke("type.req.array.or.iterable")});
                    elemtype = this.types().createErrorType(exprType);
                } else {
                    List<Type> iterableParams = base.allparams();
                    Type type = elemtype = iterableParams.isEmpty() ? this.syms().objectType : this.types().wildUpperBound((Type)iterableParams.head);
                }
            }
            if ("manifold.ext.rt.api.auto".equals(tree.var.type.tsym.getQualifiedName().toString())) {
                tree.var.type = elemtype;
                tree.var.sym.type = elemtype;
            }
            ReflectUtil.method(this.chk(), "checkType", JCDiagnostic.DiagnosticPosition.class, Type.class, Type.class).invoke(tree.expr.pos(), elemtype, tree.var.sym.type);
            loopEnv.tree = tree;
            this.attribStat(tree.body, loopEnv);
            ReflectUtil.field(this, "result").set(null);
        }
        finally {
            ReflectUtil.method(ReflectUtil.field(loopEnv.info, "scope").get(), "leave", new Class[0]).invoke(new Object[0]);
        }
    }

    private void inferAutoLocalVar(JCTree.JCVariableDecl tree) {
        if (!this.isAutoType(tree.type)) {
            return;
        }
        JCTree.JCExpression initializer = tree.getInitializer();
        if (initializer == null) {
            Tree parent = JavacPlugin.instance().getTypeProcessor().getParent(tree, this.getEnv().toplevel);
            if (!(parent instanceof JCTree.JCEnhancedForLoop)) {
                IDynamicJdk.instance().logError(Log.instance(JavacPlugin.instance().getContext()), tree.getType().pos(), "proc.messager", IssueMsg.MSG_AUTO_CANNOT_INFER_WO_INIT.get(new Object[0]));
            }
            return;
        }
        if (initializer.type == this.syms().botType) {
            IDynamicJdk.instance().logError(Log.instance(JavacPlugin.instance().getContext()), tree.getType().pos(), "proc.messager", IssueMsg.MSG_AUTO_CANNOT_INFER_FROM_NULL.get(new Object[0]));
            return;
        }
        tree.type = initializer.type;
        tree.sym.type = initializer.type;
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        Object resultInfo;
        boolean isAutoMethod = this.isAutoMethod();
        if (isAutoMethod && (resultInfo = ReflectUtil.field(this.getEnv().info, "returnResult").get()) != null) {
            ReflectUtil.field(resultInfo, "pt").set(Type.noType);
        }
        super.visitReturn(tree);
        if (isAutoMethod) {
            this.reassignAutoMethodReturnTypeToInferredType(tree);
        }
    }

    private boolean isAutoMethod() {
        JCTree.JCMethodDecl enclMethod = this.getEnv().enclMethod;
        return enclMethod != null && enclMethod.getReturnType() != null && "auto".equals(enclMethod.getReturnType().toString());
    }

    private void reassignAutoMethodReturnTypeToInferredType(JCTree.JCReturn tree) {
        if (tree.expr == null) {
            return;
        }
        if (this._methodDefs.isEmpty()) {
            return;
        }
        Type returnExprType = tree.expr.type;
        if (returnExprType.isErroneous()) {
            return;
        }
        if (!this.isAutoType(returnExprType)) {
            JCTree.JCMethodDecl meth = this._methodDefs.peek();
            returnExprType = returnExprType.baseType();
            returnExprType = this.isAutoType(meth.restype.type) ? returnExprType : this.lub(tree, meth.restype.type, returnExprType).baseType();
            this.assignMethodReturnType(returnExprType, meth);
        } else {
            JCTree.JCExpression returnExpr = tree.expr;
            while (returnExpr instanceof JCTree.JCParens) {
                returnExpr = ((JCTree.JCParens)returnExpr).expr;
            }
            if (!(returnExpr instanceof JCTree.JCMethodInvocation)) {
                IDynamicJdk.instance().logError(Log.instance(JavacPlugin.instance().getContext()), tree.expr.pos(), "proc.messager", IssueMsg.MSG_AUTO_RETURN_MORE_SPECIFIC_TYPE.get(new Object[0]));
            }
        }
    }

    private void assignMethodReturnType(Type returnExprType, JCTree.JCMethodDecl meth) {
        ((Type.MethodType)meth.sym.type).restype = returnExprType;
        if (meth.restype instanceof JCTree.JCIdent) {
            ((JCTree.JCIdent)meth.restype).sym = returnExprType.tsym;
        } else if (meth.restype instanceof JCTree.JCFieldAccess) {
            ((JCTree.JCFieldAccess)meth.restype).sym = returnExprType.tsym;
        }
        meth.restype.type = returnExprType;
        meth.sym.erasure_field = null;
        this.types().memberType(this.getEnv().enclClass.sym.type, meth.sym);
    }

    private Type lub(JCTree.JCReturn tree, Type type, Type returnExprType) {
        return (Type)ReflectUtil.method(this, "condType", JCDiagnostic.DiagnosticPosition.class, Type.class, Type.class).invoke(tree, type, returnExprType);
    }

    @Override
    public JCTree.JCMethodDecl peekMethodDef() {
        return this._methodDefs.isEmpty() ? null : this._methodDefs.peek();
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
        this._annotatedTypes.push(tree);
        try {
            super.visitAnnotatedType(tree);
        }
        finally {
            this._annotatedTypes.pop();
        }
    }

    @Override
    public JCTree.JCFieldAccess peekSelect() {
        return this._selects.isEmpty() ? null : this._selects.peek();
    }

    public JCTree.JCMethodInvocation peekApply() {
        return this._applys.isEmpty() ? null : this._applys.peek();
    }

    @Override
    public JCTree.JCAnnotatedType peekAnnotatedType() {
        return this._annotatedTypes.isEmpty() ? null : this._annotatedTypes.peek();
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        super.visitIdent(tree);
        this.patchAutoFieldType(tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        if (!(tree.meth instanceof JCTree.JCFieldAccess)) {
            if (!this.handleTupleType(tree)) {
                super.visitApply(tree);
                this.patchMethodType(tree, this._visitedAutoMethodCalls);
            }
            return;
        }
        this._manLog.pushSuspendIssues(tree);
        this._applys.push(tree);
        JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)tree.meth;
        try {
            super.visitApply(tree);
            this.patchMethodType(tree, this._visitedAutoMethodCalls);
            if (fieldAccess.type instanceof Type.ErrorType) {
                if (this.shouldCheckSuperType(fieldAccess.selected.type) && this._manLog.isJailbreakSelect(fieldAccess)) {
                    Type.ClassType oldType = (Type.ClassType)fieldAccess.selected.type;
                    ((JCTree.JCIdent)fieldAccess.selected).sym.type = fieldAccess.selected.type = ((Symbol.ClassSymbol)oldType.tsym).getSuperclass();
                    fieldAccess.type = null;
                    fieldAccess.sym = null;
                    tree.type = null;
                    this.visitApply(tree);
                    ((JCTree.JCIdent)fieldAccess.selected).sym.type = fieldAccess.selected.type = oldType;
                }
            } else {
                this._manLog.recordRecentSuspendedIssuesAndRemoveOthers(tree);
            }
        }
        finally {
            this._applys.pop();
            this._manLog.popSuspendIssues(tree);
        }
    }

    private boolean handleTupleType(JCTree.JCMethodInvocation tree) {
        if (!(tree.meth instanceof JCTree.JCIdent) || !((JCTree.JCIdent)tree.meth).name.toString().equals("$manifold_tuple")) {
            return false;
        }
        Env<Object> localEnv = this.getEnv().dup(tree, ReflectUtil.method(this.getEnv().info, "dup", new Class[0]).invoke(new Object[0]));
        List<JCTree.JCExpression> argsNoLabels = this.removeLabels(tree.args);
        ReflectUtil.method(this, "attribExprs", List.class, Env.class, Type.class).invoke(argsNoLabels, localEnv, Type.noType);
        HashMap<JCTree.JCExpression, String> namesByArg = new HashMap<JCTree.JCExpression, String>();
        Map<String, String> fieldMap = this.makeTupleFieldMap(tree.args, namesByArg);
        argsNoLabels = List.from(argsNoLabels.stream().sorted(Comparator.comparing(namesByArg::get)).collect(Collectors.toList()));
        String pkg = this.findPackageForTuple();
        String tupleTypeName = ITupleTypeProvider.INSTANCE.get().makeType(pkg, fieldMap);
        Tree parent = JavacPlugin.instance().getTypeProcessor().getParent(tree, this.getEnv().toplevel);
        Symbol.ClassSymbol tupleTypeSym = this.findTupleClassSymbol(tupleTypeName);
        if (tupleTypeSym == null) {
            return false;
        }
        JCTree.JCNewClass newTuple = this.makeNewTupleClass(tupleTypeSym.type, tree, argsNoLabels);
        if (parent instanceof JCTree.JCReturn) {
            ((JCTree.JCReturn)parent).expr = newTuple;
        } else if (parent instanceof JCTree.JCParens) {
            ((JCTree.JCParens)parent).expr = newTuple;
        }
        ReflectUtil.field(this, "result").set(tupleTypeSym.type);
        return true;
    }

    private void addEnclosingClassOnTupleType(String fqn) {
        Set<ITypeManifold> typeManifolds = JavacPlugin.instance().getHost().getSingleModule().findTypeManifoldsFor(fqn);
        ITypeManifold tm = typeManifolds.stream().findFirst().orElse(null);
        ReflectUtil.method(tm, "addEnclosingSourceFile", String.class, URI.class).invoke(fqn, this.getEnv().enclClass.sym.sourcefile.toUri());
    }

    private String findPackageForTuple() {
        JCTree.JCMethodDecl enclMethod = this.getEnv().enclMethod;
        if (enclMethod == null) {
            return this.getEnv().toplevel.packge.fullname.toString();
        }
        Set<Symbol.MethodSymbol> overriddenMethods = JavacTypes.instance(JavacPlugin.instance().getContext()).getOverriddenMethods(enclMethod.sym);
        if (overriddenMethods.isEmpty()) {
            return this.getEnv().toplevel.packge.fullname.toString();
        }
        Symbol.MethodSymbol overridden = overriddenMethods.iterator().next();
        return overridden.owner.packge().fullname.toString();
    }

    private Symbol.ClassSymbol findTupleClassSymbol(String tupleTypeName) {
        Symbol.PackageSymbol pkgSym;
        this.addEnclosingClassOnTupleType(tupleTypeName);
        Context ctx = JavacPlugin.instance().getContext();
        Symbol.ClassSymbol sym = IDynamicJdk.instance().getTypeElement(ctx, this.getEnv().toplevel, tupleTypeName);
        if (sym != null) {
            return sym;
        }
        IModule compilingModule = JavacPlugin.instance().getHost().getSingleModule();
        if (compilingModule == null) {
            return null;
        }
        String pkg = ManClassUtil.getPackage(tupleTypeName);
        if (JreUtil.isJava8()) {
            pkgSym = JavacElements.instance(ctx).getPackageElement(pkg);
        } else {
            Object moduleSym = ReflectUtil.field(this.getEnv().toplevel, "modle").get();
            pkgSym = (Symbol.PackageSymbol)ReflectUtil.method(JavacElements.instance(ctx), "getPackageElement", ReflectUtil.type("javax.lang.model.element.ModuleElement"), String.class).invoke(moduleSym, pkg);
        }
        IssueReporter<JavaFileObject> issueReporter = new IssueReporter<JavaFileObject>(() -> ctx);
        String fqn = tupleTypeName.replace('$', '.');
        ManifoldJavaFileManager fm = JavacPlugin.instance().getManifoldFileManager();
        JavaFileObject file = fm.findGeneratedFile(fqn, StandardLocation.CLASS_PATH, compilingModule, issueReporter);
        ClassReader classReader = JreUtil.isJava8() ? ClassReader.instance(ctx) : ReflectUtil.method("com.sun.tools.javac.code.ClassFinder", "instance", Context.class).invokeStatic(ctx);
        ReflectUtil.method(classReader, "includeClassFile", Symbol.PackageSymbol.class, JavaFileObject.class).invoke(pkgSym, file);
        return IDynamicJdk.instance().getTypeElement(ctx, this.getEnv().toplevel, tupleTypeName);
    }

    private List<JCTree.JCExpression> removeLabels(List<JCTree.JCExpression> args) {
        List<JCTree.JCExpression> filtered = List.nil();
        for (JCTree.JCExpression arg : args) {
            if (arg instanceof JCTree.JCMethodInvocation && ((JCTree.JCMethodInvocation)arg).meth instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)((JCTree.JCMethodInvocation)arg).meth;
                if ("$manifold_label".equals(ident.name.toString())) continue;
            }
            filtered = filtered.append(arg);
        }
        return filtered;
    }

    JCTree.JCNewClass makeNewTupleClass(Type tupleType, JCTree.JCExpression treePos, List<JCTree.JCExpression> args) {
        TreeMaker make = TreeMaker.instance(JavacPlugin.instance().getContext());
        JCTree.JCNewClass tree = make.NewClass(null, null, make.QualIdent(tupleType.tsym), args, null);
        Resolve rs = (Resolve)ReflectUtil.field(this, "rs").get();
        tree.constructor = (Symbol)ReflectUtil.method(rs, "resolveConstructor", JCDiagnostic.DiagnosticPosition.class, Env.class, Type.class, List.class, List.class).invoke(treePos.pos(), this.getEnv(), tupleType, TreeInfo.types(args), List.nil());
        tree.constructorType = tree.constructor.type;
        tree.type = tupleType;
        tree.pos = treePos.pos;
        return tree;
    }

    private Map<String, String> makeTupleFieldMap(List<JCTree.JCExpression> args, Map<JCTree.JCExpression, String> argsByName) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int nullNameCount = 0;
        int argsSize = args.size();
        for (int j = 0; j < argsSize; ++j) {
            String item;
            JCTree.JCExpression arg = args.get(j);
            String name = null;
            if (arg instanceof JCTree.JCMethodInvocation && ((JCTree.JCMethodInvocation)arg).meth instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)((JCTree.JCMethodInvocation)arg).meth;
                if ("$manifold_label".equals(ident.name.toString())) {
                    JCTree.JCIdent labelArg = (JCTree.JCIdent)((JCTree.JCMethodInvocation)arg).args.get(0);
                    name = labelArg.name.toString();
                    if (++j >= args.size()) break;
                    arg = args.get(j);
                }
            }
            if (name == null) {
                if (arg instanceof JCTree.JCIdent) {
                    name = ((JCTree.JCIdent)arg).name.toString();
                } else if (arg instanceof JCTree.JCFieldAccess) {
                    name = ((JCTree.JCFieldAccess)arg).name.toString();
                } else if (arg instanceof JCTree.JCMethodInvocation) {
                    JCTree.JCExpression meth = ((JCTree.JCMethodInvocation)arg).meth;
                    if (meth instanceof JCTree.JCIdent) {
                        name = this.getFieldNameFromMethodName(((JCTree.JCIdent)meth).name.toString());
                    } else if (meth instanceof JCTree.JCFieldAccess) {
                        name = this.getFieldNameFromMethodName(((JCTree.JCFieldAccess)meth).name.toString());
                    }
                }
            }
            String string = item = name == null ? "item" : name;
            if (name == null) {
                item = item + ++nullNameCount;
            }
            name = item;
            int i = 2;
            while (map.containsKey(item)) {
                item = name + '_' + i;
                ++i;
            }
            Type type = arg.type == this.syms().botType ? this.syms().objectType : RecursiveTypeVarEraser.eraseTypeVars(this.types(), arg.type);
            String typeName = type.toString();
            map.put(item, typeName);
            argsByName.put(arg, item);
        }
        return map;
    }

    private String getFieldNameFromMethodName(String methodName) {
        for (int i = 0; i < methodName.length(); ++i) {
            char c;
            if (!Character.isUpperCase(methodName.charAt(i))) continue;
            StringBuilder name = new StringBuilder(methodName.substring(i));
            for (int j = 0; j < name.length() && Character.isUpperCase(c = name.charAt(j)) && (j == 0 || j == name.length() - 1 || Character.isUpperCase(name.charAt(j + 1))); ++j) {
                name.setCharAt(j, Character.toLowerCase(c));
            }
            return name.toString();
        }
        return methodName;
    }

    @Override
    public Type attribExpr(JCTree tree, Env<AttrContext> env, Type pt) {
        if (this.isAutoType(pt)) {
            pt = Type.noType;
        }
        return super.attribExpr(tree, env, pt);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        if (!JavacPlugin.instance().isExtensionsEnabled()) {
            super.visitIndexed(tree);
            return;
        }
        ManAttr.super.handleIndexedOverloading(tree);
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        Class<?> ResultInfo_Class = ReflectUtil.type(Attr.class.getTypeName() + "$ResultInfo");
        Type owntype = (Type)ReflectUtil.method(this, "attribTree", JCTree.class, Env.class, ResultInfo_Class).invoke(tree.lhs, this.getEnv().dup(tree), ReflectUtil.field(this, "varInfo").get());
        if (tree.lhs.type != null && tree.lhs.type.isPrimitive()) {
            tree.rhs = this.makeCast(tree.rhs, tree.lhs.type);
        }
        Type capturedType = this.types().capture(owntype);
        this.attribExpr(tree.rhs, this.getEnv(), owntype);
        this.setResult(tree, capturedType);
        ReflectUtil.field(this, "result").set(ReflectUtil.method(this, "check", JCTree.class, Type.class, Integer.TYPE, ResultInfo_Class).invoke(tree, capturedType, 12, ReflectUtil.field(this, "resultInfo").get()));
        this.ensureIndexedAssignmentIsWritable(tree.lhs);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        super.visitAssignop(tree);
        this.ensureIndexedAssignmentIsWritable(tree.lhs);
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        if (!JavacPlugin.instance().isExtensionsEnabled()) {
            super.visitBinary(tree);
            return;
        }
        if (tree.getTag() == JCTree.Tag.APPLY) {
            this.visitBindingExpression(tree);
            ReflectUtil.field(tree, "opcode").set((Object)JCTree.Tag.MUL);
            return;
        }
        ReflectUtil.LiveMethodRef checkNonVoid = ReflectUtil.method(this.chk(), "checkNonVoid", JCDiagnostic.DiagnosticPosition.class, Type.class);
        ReflectUtil.LiveMethodRef attribExpr = ReflectUtil.method(this, "attribExpr", JCTree.class, Env.class);
        Type left = (Type)checkNonVoid.invoke(tree.lhs.pos(), attribExpr.invoke(tree.lhs, this.getEnv()));
        Type right = (Type)checkNonVoid.invoke(tree.rhs.pos(), attribExpr.invoke(tree.rhs, this.getEnv()));
        if (this.handleOperatorOverloading(tree, left, right)) {
            return;
        }
        this._visitBinary_Rest(tree, left, right);
    }

    private void _visitBinary_Rest(JCTree.JCBinary tree, Type left, Type right) {
        Symbol operator = tree.operator = (Symbol)ReflectUtil.method(this.rs(), "resolveBinaryOperator", JCDiagnostic.DiagnosticPosition.class, JCTree.Tag.class, Env.class, Type.class, Type.class).invoke(new Object[]{tree.pos(), tree.getTag(), this.getEnv(), left, right});
        Type owntype = this.types().createErrorType(tree.type);
        if (operator.kind == 16 && !left.isErroneous() && !right.isErroneous()) {
            Type ctype;
            owntype = operator.type.getReturnType();
            int opc = (Integer)ReflectUtil.method(this.chk(), "checkOperator", JCDiagnostic.DiagnosticPosition.class, Symbol.OperatorSymbol.class, JCTree.Tag.class, Type.class, Type.class).invoke(new Object[]{tree.lhs.pos(), operator, tree.getTag(), left, right});
            if (left.constValue() != null && right.constValue() != null && (ctype = (Type)ReflectUtil.method(this.cfolder(), "fold2", Integer.TYPE, Type.class, Type.class).invoke(opc, left, right)) != null) {
                owntype = (Type)ReflectUtil.method(this.cfolder(), "coerce", Type.class, Type.class).invoke(ctype, owntype);
            }
            if (!(opc != 165 && opc != 166 || this.types().isEqualityComparable(left, right, new Warner(tree.pos())))) {
                this.getLogger().error(tree.pos(), "incomparable.types", new Object[]{left, right});
            }
            ReflectUtil.method(this.chk(), "checkDivZero", JCDiagnostic.DiagnosticPosition.class, Symbol.class, Type.class).invoke(tree.rhs.pos(), operator, right);
        }
        this.setResult(tree, owntype);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        if (!JavacPlugin.instance().isExtensionsEnabled()) {
            super.visitUnary(tree);
            return;
        }
        if (this.handleUnaryOverloading(tree)) {
            return;
        }
        super.visitUnary(tree);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        if (tree.typetag == TypeTag.CLASS && tree.value.toString().startsWith("[>")) {
            Type type;
            tree.type = type = this.getFragmentValueType(tree);
            ReflectUtil.field(this, "result").set(type);
        } else {
            super.visitLiteral(tree);
        }
    }

    private Type getFragmentValueType(JCTree.JCLiteral tree) {
        try {
            CharSequence source = ParserFactoryFiles.getSource(this.getEnv().toplevel.sourcefile);
            CharSequence chars = source.subSequence(tree.pos().getStartPosition(), tree.pos().getEndPosition(this.getEnv().toplevel.endPositions));
            FragmentProcessor.Fragment fragment = FragmentProcessor.instance().parseFragment(tree.pos().getStartPosition(), chars.toString(), chars.length() > 3 && chars.charAt(1) == '\"' ? HostKind.TEXT_BLOCK_LITERAL : HostKind.DOUBLE_QUOTE_LITERAL);
            if (fragment != null) {
                String fragClass = this.getEnv().toplevel.packge.toString() + '.' + fragment.getName();
                Symbol.ClassSymbol fragSym = IDynamicJdk.instance().getTypeElement(JavacPlugin.instance().getContext(), this.getEnv().toplevel, fragClass);
                for (Attribute.Compound annotation : fragSym.getAnnotationMirrors()) {
                    Type type;
                    if (!annotation.type.toString().equals(FragmentValue.class.getName()) || (type = this.getFragmentValueType(annotation)) == null) continue;
                    return type;
                }
                this.getLogger().rawWarning(tree.pos().getStartPosition(), "No @" + FragmentValue.class.getSimpleName() + " is provided for metatype '" + fragment.getExt() + "'. The resulting value remains a String literal.");
            }
        }
        catch (Exception e) {
            this.getLogger().rawWarning(tree.pos().getStartPosition(), "Error parsing Manifold fragment.\n" + e.getClass().getSimpleName() + ": " + e.getMessage() + "\n" + (e.getStackTrace().length > 0 ? e.getStackTrace()[0].toString() : ""));
        }
        return this._syms.stringType.constType(tree.value);
    }

    private Type getFragmentValueType(Attribute.Compound attribute) {
        Symbol.ClassSymbol fragValueSym;
        String type = null;
        for (Pair<Symbol.MethodSymbol, Attribute> pair : attribute.values) {
            javax.lang.model.element.Name argName = ((Symbol.MethodSymbol)pair.fst).getSimpleName();
            if (!((Name)argName).toString().equals("type")) continue;
            type = (String)((Attribute)pair.snd).getValue();
        }
        if (type != null && (fragValueSym = IDynamicJdk.instance().getTypeElement(JavacPlugin.instance().getContext(), this.getEnv().toplevel, type)) != null) {
            return fragValueSym.type;
        }
        return null;
    }

    @Override
    public void attribClass(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        String fqn;
        ISelfCompiledFile sourcefile;
        if (c.sourcefile instanceof ISelfCompiledFile && (sourcefile = (ISelfCompiledFile)((Object)c.sourcefile)).isSelfCompile(fqn = c.getQualifiedName().toString())) {
            sourcefile.parse(fqn);
        }
        super.attribClass(pos, c);
    }
}

