/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.com.google.common.collect.ImmutableMap;
import graphql.language.SDLDefinition;
import graphql.language.SDLNamedDefinition;
import graphql.language.SourceLocation;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLSchemaElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class SchemaParseOrder
implements Serializable {
    private final Map<String, List<SDLDefinition<?>>> definitionOrder = new LinkedHashMap();

    public Map<String, List<SDLDefinition<?>>> getInOrder() {
        return ImmutableMap.copyOf(this.definitionOrder);
    }

    public Map<String, List<SDLNamedDefinition<?>>> getInNameOrder() {
        LinkedHashMap named = new LinkedHashMap();
        this.definitionOrder.forEach((location, def) -> {
            List namedDefs = def.stream().filter(d -> d instanceof SDLNamedDefinition).map(d -> (SDLNamedDefinition)d).collect(Collectors.toList());
            named.put((String)location, (List<SDLNamedDefinition<?>>)namedDefs);
        });
        return named;
    }

    public <T extends GraphQLSchemaElement> Comparator<? super T> getElementComparator() {
        Map<String, Integer> namedSortValues = this.buildNameIndex(this.getInNameOrder());
        return (e1, e2) -> {
            if (this.isAssignable((GraphQLSchemaElement)e1, GraphQLFieldDefinition.class, GraphQLInputObjectField.class, GraphQLEnumValueDefinition.class) || this.isAssignable((GraphQLSchemaElement)e2, GraphQLFieldDefinition.class, GraphQLInputObjectField.class, GraphQLEnumValueDefinition.class)) {
                return 0;
            }
            if (this.isAssignable((GraphQLSchemaElement)e1, GraphQLDirective.class, GraphQLNamedType.class) && this.isAssignable((GraphQLSchemaElement)e2, GraphQLDirective.class, GraphQLNamedType.class)) {
                int sortVal1 = this.sortValue((GraphQLNamedSchemaElement)e1, namedSortValues);
                int sortVal2 = this.sortValue((GraphQLNamedSchemaElement)e2, namedSortValues);
                return Integer.compare(sortVal1, sortVal2);
            }
            return -1;
        };
    }

    private <T extends GraphQLSchemaElement> boolean isAssignable(T e1, Class<?> ... classes) {
        return Arrays.stream(classes).anyMatch(aClass -> aClass.isAssignableFrom(e1.getClass()));
    }

    private Integer sortValue(GraphQLNamedSchemaElement e1, Map<String, Integer> namedSortValues) {
        return namedSortValues.getOrDefault(e1.getName(), -1);
    }

    private Map<String, Integer> buildNameIndex(Map<String, List<SDLNamedDefinition<?>>> inNameOrder) {
        HashMap<String, Integer> nameIndex = new HashMap<String, Integer>();
        int sourceIndex = 0;
        for (Map.Entry<String, List<SDLNamedDefinition<?>>> entry : inNameOrder.entrySet()) {
            List<SDLNamedDefinition<?>> namedDefs = entry.getValue();
            for (int i = 0; i < namedDefs.size(); ++i) {
                SDLNamedDefinition<?> namedDefinition = namedDefs.get(i);
                int index = i + sourceIndex * 100000000;
                nameIndex.put(namedDefinition.getName(), index);
            }
            ++sourceIndex;
        }
        return nameIndex;
    }

    public <T extends SDLDefinition<?>> SchemaParseOrder addDefinition(T sdlDefinition) {
        if (sdlDefinition != null) {
            this.definitionList(sdlDefinition).add(sdlDefinition);
        }
        return this;
    }

    public <T extends SDLDefinition<?>> SchemaParseOrder removeDefinition(T sdlDefinition) {
        this.definitionList(sdlDefinition).remove(sdlDefinition);
        return this;
    }

    private <T extends SDLDefinition<?>> List<SDLDefinition<?>> definitionList(T sdlDefinition) {
        String location = Optional.ofNullable(sdlDefinition.getSourceLocation()).map(SourceLocation::getSourceName).orElse("");
        return this.computeIfAbsent(location);
    }

    private List<SDLDefinition<?>> computeIfAbsent(String location) {
        return this.definitionOrder.computeIfAbsent(location, k -> new ArrayList());
    }

    public String toString() {
        return new StringJoiner(", ", SchemaParseOrder.class.getSimpleName() + "[", "]").add("definitionOrder=" + this.definitionOrder).toString();
    }
}

