/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Assert;
import graphql.Internal;
import graphql.com.google.common.collect.BiMap;
import graphql.com.google.common.collect.HashBasedTable;
import graphql.com.google.common.collect.HashBiMap;
import graphql.com.google.common.collect.HashMultimap;
import graphql.com.google.common.collect.ImmutableList;
import graphql.com.google.common.collect.Multimap;
import graphql.com.google.common.collect.Table;
import graphql.schema.diffing.Mapping;
import graphql.schema.diffing.SchemaDiffingRunningCheck;
import graphql.schema.diffing.SchemaGraph;
import graphql.schema.diffing.Util;
import graphql.schema.diffing.Vertex;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Internal
public class FillupIsolatedVertices {
    private final SchemaDiffingRunningCheck runningCheck;
    private final SchemaGraph sourceGraph;
    private final SchemaGraph targetGraph;
    private final IsolatedVertices isolatedVertices;
    private final BiMap<Vertex, Vertex> toRemove = HashBiMap.create();
    static final Map<String, List<VertexContextSegment>> typeContexts = new LinkedHashMap<String, List<VertexContextSegment>>();

    private static List<VertexContextSegment> inputFieldContexts() {
        VertexContextSegment inputFieldType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "InputField".equals(vertex.getType());
            }
        };
        VertexContextSegment inputObjectContext = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex inputField, SchemaGraph schemaGraph) {
                Vertex inputObject = schemaGraph.getInputObjectForInputField(inputField);
                return inputObject.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment inputFieldName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex inputField, SchemaGraph schemaGraph) {
                return inputField.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(inputFieldType, inputObjectContext, inputFieldName);
        return contexts;
    }

    private static List<VertexContextSegment> scalarContext() {
        VertexContextSegment scalar = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Scalar".equals(vertex.getType());
            }
        };
        VertexContextSegment scalarName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(scalar, scalarName);
        return contexts;
    }

    private static List<VertexContextSegment> inputObjectContext() {
        VertexContextSegment inputObject = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "InputObject".equals(vertex.getType());
            }
        };
        VertexContextSegment inputObjectName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex inputObject, SchemaGraph schemaGraph) {
                return inputObject.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(inputObject, inputObjectName);
        return contexts;
    }

    private static List<VertexContextSegment> objectContext() {
        VertexContextSegment objectType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Object".equals(vertex.getType());
            }
        };
        VertexContextSegment objectName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex object, SchemaGraph schemaGraph) {
                return object.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(objectType, objectName);
        return contexts;
    }

    private static List<VertexContextSegment> enumContext() {
        VertexContextSegment enumCtxType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Enum".equals(vertex.getType());
            }
        };
        VertexContextSegment enumName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex enumVertex, SchemaGraph schemaGraph) {
                return enumVertex.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(enumCtxType, enumName);
        return contexts;
    }

    private static List<VertexContextSegment> enumValueContext() {
        VertexContextSegment enumValueType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "EnumValue".equals(vertex.getType());
            }
        };
        VertexContextSegment enumName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex enumValue, SchemaGraph schemaGraph) {
                return schemaGraph.getEnumForEnumValue(enumValue).getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment enumValueName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex enumValue, SchemaGraph schemaGraph) {
                return enumValue.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(enumValueType, enumName, enumValueName);
        return contexts;
    }

    private static List<VertexContextSegment> interfaceContext() {
        VertexContextSegment interfaceType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Interface".equals(vertex.getType());
            }
        };
        VertexContextSegment interfaceName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex interfaceVertex, SchemaGraph schemaGraph) {
                return interfaceVertex.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(interfaceType, interfaceName);
        return contexts;
    }

    private static List<VertexContextSegment> unionContext() {
        VertexContextSegment unionType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Union".equals(vertex.getType());
            }
        };
        VertexContextSegment unionName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex union, SchemaGraph schemaGraph) {
                return union.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(unionType, unionName);
        return contexts;
    }

    private static List<VertexContextSegment> directiveContext() {
        VertexContextSegment directiveType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Directive".equals(vertex.getType());
            }
        };
        VertexContextSegment directiveName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex directive, SchemaGraph schemaGraph) {
                return directive.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(directiveType, directiveName);
        return contexts;
    }

    private static List<VertexContextSegment> appliedDirectiveContext() {
        VertexContextSegment appliedDirectiveType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "AppliedDirective".equals(vertex.getType());
            }
        };
        VertexContextSegment appliedDirectiveName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedDirective, SchemaGraph schemaGraph) {
                int appliedDirectiveIndex = schemaGraph.getAppliedDirectiveIndex(appliedDirective);
                return appliedDirectiveIndex + ":" + appliedDirective.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment appliedDirectiveContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedDirective, SchemaGraph schemaGraph) {
                Vertex appliedDirectiveContainer = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                return appliedDirectiveContainer.getType() + "." + appliedDirectiveContainer.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment parentOfContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedDirective, SchemaGraph schemaGraph) {
                Vertex container = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                switch (container.getType()) {
                    case "Schema": {
                        return "Schema";
                    }
                    case "Field": {
                        Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(container);
                        return fieldsContainer.getType() + "." + fieldsContainer.getName();
                    }
                    case "Object": {
                        return "Object";
                    }
                    case "Interface": {
                        return "Interface";
                    }
                    case "InputField": {
                        Vertex inputObject = schemaGraph.getInputObjectForInputField(container);
                        return inputObject.getType() + "." + inputObject.getName();
                    }
                    case "Argument": {
                        Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(container);
                        return fieldOrDirective.getType() + "." + fieldOrDirective.getName();
                    }
                    case "InputObject": {
                        return "InputObject";
                    }
                    case "Enum": {
                        return "Enum";
                    }
                    case "Union": {
                        return "Union";
                    }
                    case "Scalar": {
                        return "Scalar";
                    }
                    case "EnumValue": {
                        Vertex enumVertex = schemaGraph.getEnumForEnumValue(container);
                        return enumVertex.getType() + "." + enumVertex.getName();
                    }
                }
                throw new IllegalStateException("Unexpected directive container type " + container.getType());
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment parentOfParentOfContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedDirective, SchemaGraph schemaGraph) {
                Vertex container = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                switch (container.getType()) {
                    case "Schema": 
                    case "Field": 
                    case "Object": 
                    case "Interface": 
                    case "InputField": 
                    case "InputObject": 
                    case "Enum": 
                    case "EnumValue": 
                    case "Union": 
                    case "Scalar": {
                        return "";
                    }
                    case "Argument": {
                        Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(container);
                        switch (fieldOrDirective.getType()) {
                            case "Field": {
                                Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(fieldOrDirective);
                                return fieldsContainer.getType() + "." + fieldsContainer.getName();
                            }
                            case "Directive": {
                                return "";
                            }
                        }
                        return (String)Assert.assertShouldNeverHappen();
                    }
                }
                throw new IllegalStateException("Unexpected directive container type " + container.getType());
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(appliedDirectiveType, parentOfParentOfContainer, parentOfContainer, appliedDirectiveContainer, appliedDirectiveName);
        return contexts;
    }

    private static List<VertexContextSegment> appliedArgumentContext() {
        VertexContextSegment appliedArgumentType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "AppliedArgument".equals(vertex.getType());
            }
        };
        VertexContextSegment appliedDirective = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                Vertex appliedDirective = schemaGraph.getAppliedDirectiveForAppliedArgument(appliedArgument);
                int appliedDirectiveIndex = schemaGraph.getAppliedDirectiveIndex(appliedDirective);
                return appliedDirectiveIndex + ":" + appliedDirective.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment appliedDirectiveContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                Vertex appliedDirective = schemaGraph.getAppliedDirectiveForAppliedArgument(appliedArgument);
                Vertex appliedDirectiveContainer = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                return appliedDirectiveContainer.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment parentOfContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                Vertex appliedDirective = schemaGraph.getAppliedDirectiveForAppliedArgument(appliedArgument);
                Vertex container = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                switch (container.getType()) {
                    case "Schema": {
                        return "Schema";
                    }
                    case "Field": {
                        Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(container);
                        return fieldsContainer.getType() + "." + fieldsContainer.getName();
                    }
                    case "Object": {
                        return "Object";
                    }
                    case "Interface": {
                        return "Interface";
                    }
                    case "InputField": {
                        Vertex inputObject = schemaGraph.getInputObjectForInputField(container);
                        return inputObject.getType() + "." + inputObject.getName();
                    }
                    case "Argument": {
                        Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(container);
                        return fieldOrDirective.getType() + "." + fieldOrDirective.getName();
                    }
                    case "InputObject": {
                        return "InputObject";
                    }
                    case "Enum": {
                        return "Enum";
                    }
                    case "Union": {
                        return "Union";
                    }
                    case "Scalar": {
                        return "Scalar";
                    }
                    case "EnumValue": {
                        Vertex enumVertex = schemaGraph.getEnumForEnumValue(container);
                        return enumVertex.getType() + "." + enumVertex.getName();
                    }
                }
                throw new IllegalStateException("Unexpected directive container type " + container.getType());
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment parentOfParentOfContainer = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                Vertex appliedDirective = schemaGraph.getAppliedDirectiveForAppliedArgument(appliedArgument);
                Vertex container = schemaGraph.getAppliedDirectiveContainerForAppliedDirective(appliedDirective);
                switch (container.getType()) {
                    case "Schema": 
                    case "Field": 
                    case "Object": 
                    case "Interface": 
                    case "InputField": 
                    case "InputObject": 
                    case "Enum": 
                    case "EnumValue": 
                    case "Union": 
                    case "Scalar": {
                        return "";
                    }
                    case "Argument": {
                        Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(container);
                        switch (fieldOrDirective.getType()) {
                            case "Field": {
                                Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(fieldOrDirective);
                                return fieldsContainer.getType() + "." + fieldsContainer.getName();
                            }
                            case "Directive": {
                                return "";
                            }
                        }
                        return (String)Assert.assertShouldNeverHappen();
                    }
                }
                throw new IllegalStateException("Unexpected directive container type " + container.getType());
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment appliedArgumentName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex appliedArgument, SchemaGraph schemaGraph) {
                return appliedArgument.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(appliedArgumentType, parentOfParentOfContainer, parentOfContainer, appliedDirectiveContainer, appliedDirective, appliedArgumentName);
        return contexts;
    }

    private static List<VertexContextSegment> schemaContext() {
        VertexContextSegment schema = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Schema".equals(vertex.getType());
            }
        };
        return Collections.singletonList(schema);
    }

    private static List<VertexContextSegment> fieldContext() {
        VertexContextSegment field = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Field".equals(vertex.getType());
            }
        };
        VertexContextSegment container = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex field, SchemaGraph schemaGraph) {
                Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(field);
                return fieldsContainer.getType() + "." + fieldsContainer.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment fieldName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex field, SchemaGraph schemaGraph) {
                return field.getName();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(field, container, fieldName);
        return contexts;
    }

    private static List<VertexContextSegment> argumentsContexts() {
        VertexContextSegment argumentType = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex vertex, SchemaGraph schemaGraph) {
                return vertex.getType();
            }

            @Override
            public boolean filter(Vertex vertex, SchemaGraph schemaGraph) {
                return "Argument".equals(vertex.getType());
            }
        };
        VertexContextSegment fieldOrDirective = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex argument, SchemaGraph schemaGraph) {
                Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(argument);
                return fieldOrDirective.getType() + "." + fieldOrDirective.getName();
            }

            @Override
            public boolean filter(Vertex argument, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment containerOrDirectiveHolder = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex argument, SchemaGraph schemaGraph) {
                Vertex fieldOrDirective = schemaGraph.getFieldOrDirectiveForArgument(argument);
                if (fieldOrDirective.getType().equals("Field")) {
                    Vertex fieldsContainer = schemaGraph.getFieldsContainerForField(fieldOrDirective);
                    return fieldsContainer.getType() + "." + fieldsContainer.getName();
                }
                return "";
            }

            @Override
            public boolean filter(Vertex argument, SchemaGraph schemaGraph) {
                return true;
            }
        };
        VertexContextSegment argumentName = new VertexContextSegment(){

            @Override
            public String idForVertex(Vertex argument, SchemaGraph schemaGraph) {
                return argument.getName();
            }

            @Override
            public boolean filter(Vertex argument, SchemaGraph schemaGraph) {
                return true;
            }
        };
        List<VertexContextSegment> contexts = Arrays.asList(argumentType, containerOrDirectiveHolder, fieldOrDirective, argumentName);
        return contexts;
    }

    public FillupIsolatedVertices(SchemaGraph sourceGraph, SchemaGraph targetGraph, SchemaDiffingRunningCheck runningCheck) {
        this.runningCheck = runningCheck;
        this.sourceGraph = sourceGraph;
        this.targetGraph = targetGraph;
        this.isolatedVertices = new IsolatedVertices();
    }

    public void ensureGraphAreSameSize() {
        this.calcPossibleMappings(typeContexts.get("Schema"), "Schema");
        this.calcPossibleMappings(typeContexts.get("Field"), "Field");
        this.calcPossibleMappings(typeContexts.get("Argument"), "Argument");
        this.calcPossibleMappings(typeContexts.get("InputField"), "InputField");
        this.calcPossibleMappings(typeContexts.get("Object"), "Object");
        this.calcPossibleMappings(typeContexts.get("Interface"), "Interface");
        this.calcPossibleMappings(typeContexts.get("Union"), "Union");
        this.calcPossibleMappings(typeContexts.get("InputObject"), "InputObject");
        this.calcPossibleMappings(typeContexts.get("Scalar"), "Scalar");
        this.calcPossibleMappings(typeContexts.get("Enum"), "Enum");
        this.calcPossibleMappings(typeContexts.get("EnumValue"), "EnumValue");
        this.calcPossibleMappings(typeContexts.get("AppliedDirective"), "AppliedDirective");
        this.calcPossibleMappings(typeContexts.get("AppliedArgument"), "AppliedArgument");
        this.calcPossibleMappings(typeContexts.get("Directive"), "Directive");
        this.sourceGraph.addVertices(this.isolatedVertices.allIsolatedSource);
        this.targetGraph.addVertices(this.isolatedVertices.allIsolatedTarget);
        Assert.assertTrue(this.sourceGraph.size() == this.targetGraph.size());
    }

    public void calcPossibleMappings(List<VertexContextSegment> contexts, String typeNameForDebug) {
        List<Vertex> currentSourceVertices = this.sourceGraph.getVertices();
        List<Vertex> currentTargetVertices = this.targetGraph.getVertices();
        this.calcPossibleMappingImpl(currentSourceVertices, currentTargetVertices, Collections.emptyList(), 0, contexts, new LinkedHashSet<Vertex>(), new LinkedHashSet<Vertex>(), typeNameForDebug);
    }

    private void calcPossibleMappingImpl(Collection<Vertex> currentSourceVertices, Collection<Vertex> currentTargetVertices, List<String> contextId, int contextIx, List<VertexContextSegment> contexts, Set<Vertex> usedSourceVertices, Set<Vertex> usedTargetVertices, String typeNameForDebug) {
        this.runningCheck.check();
        VertexContextSegment finalCurrentContext = contexts.get(contextIx);
        Map<String, ImmutableList<Vertex>> sourceGroups = FpKit.filterAndGroupingBy(currentSourceVertices, v -> finalCurrentContext.filter((Vertex)v, this.sourceGraph), v -> finalCurrentContext.idForVertex((Vertex)v, this.sourceGraph));
        Map<String, ImmutableList<Vertex>> targetGroups = FpKit.filterAndGroupingBy(currentTargetVertices, v -> finalCurrentContext.filter((Vertex)v, this.targetGraph), v -> finalCurrentContext.idForVertex((Vertex)v, this.targetGraph));
        ArrayList<String> deletedContexts = new ArrayList<String>();
        ArrayList<String> insertedContexts = new ArrayList<String>();
        ArrayList<String> sameContexts = new ArrayList<String>();
        Util.diffNamedList(sourceGroups.keySet(), targetGroups.keySet(), deletedContexts, insertedContexts, sameContexts);
        for (String string : sameContexts) {
            ImmutableList<Vertex> immutableList = sourceGroups.get(string);
            ImmutableList<Vertex> targetVerticesInContext = targetGroups.get(string);
            List<String> currentContextId = FpKit.concat(contextId, string);
            if (contexts.size() > contextIx + 1) {
                this.calcPossibleMappingImpl(immutableList, targetVerticesInContext, currentContextId, contextIx + 1, contexts, usedSourceVertices, usedTargetVertices, typeNameForDebug);
            }
            LinkedHashSet<Vertex> notUsedSource = new LinkedHashSet<Vertex>(immutableList);
            notUsedSource.removeAll(usedSourceVertices);
            LinkedHashSet<Vertex> notUsedTarget = new LinkedHashSet<Vertex>(targetVerticesInContext);
            notUsedTarget.removeAll(usedTargetVertices);
            if (notUsedSource.size() > notUsedTarget.size()) {
                Set<Vertex> newTargetVertices = Vertex.newIsolatedNodes(notUsedSource.size() - notUsedTarget.size(), "target-isolated-" + typeNameForDebug + "-");
                this.isolatedVertices.addIsolatedTarget(newTargetVertices);
                notUsedTarget.addAll(newTargetVertices);
            } else if (notUsedTarget.size() > notUsedSource.size()) {
                Set<Vertex> newSourceVertices = Vertex.newIsolatedNodes(notUsedTarget.size() - notUsedSource.size(), "source-isolated-" + typeNameForDebug + "-");
                this.isolatedVertices.addIsolatedSource(newSourceVertices);
                notUsedSource.addAll(newSourceVertices);
            }
            this.isolatedVertices.putPossibleMappings(notUsedSource, notUsedTarget);
            usedSourceVertices.addAll(notUsedSource);
            usedTargetVertices.addAll(notUsedTarget);
            if (notUsedSource.size() <= 0) continue;
            this.isolatedVertices.putContext(currentContextId, notUsedSource, notUsedTarget);
        }
        LinkedHashSet<Vertex> possibleTargetVertices = new LinkedHashSet<Vertex>();
        for (String string : insertedContexts) {
            ImmutableList<Vertex> vertices = targetGroups.get(string);
            for (Vertex targetVertex : vertices) {
                if (usedTargetVertices.contains(targetVertex)) continue;
                possibleTargetVertices.add(targetVertex);
            }
            usedTargetVertices.addAll(vertices);
        }
        LinkedHashSet<Vertex> linkedHashSet = new LinkedHashSet<Vertex>();
        for (String deletedContext : deletedContexts) {
            ImmutableList<Vertex> vertices = sourceGroups.get(deletedContext);
            for (Vertex sourceVertex : vertices) {
                if (usedSourceVertices.contains(sourceVertex)) continue;
                linkedHashSet.add(sourceVertex);
            }
            usedSourceVertices.addAll(vertices);
        }
        if (linkedHashSet.size() > possibleTargetVertices.size()) {
            Set<Vertex> set2 = Vertex.newIsolatedNodes(linkedHashSet.size() - possibleTargetVertices.size(), "target-isolated-" + typeNameForDebug + "-");
            this.isolatedVertices.addIsolatedTarget(set2);
            possibleTargetVertices.addAll(set2);
        } else if (possibleTargetVertices.size() > linkedHashSet.size()) {
            Set<Vertex> set3 = Vertex.newIsolatedNodes(possibleTargetVertices.size() - linkedHashSet.size(), "source-isolated-" + typeNameForDebug + "-");
            this.isolatedVertices.addIsolatedSource(set3);
            linkedHashSet.addAll(set3);
        }
        if (linkedHashSet.size() > 0) {
            if (contextId.size() == 0) {
                contextId = Collections.singletonList(typeNameForDebug);
            }
            this.isolatedVertices.putContext(contextId, linkedHashSet, possibleTargetVertices);
        }
        this.isolatedVertices.putPossibleMappings(linkedHashSet, possibleTargetVertices);
    }

    public IsolatedVertices getIsolatedVertices() {
        return this.isolatedVertices;
    }

    static {
        typeContexts.put("Schema", FillupIsolatedVertices.schemaContext());
        typeContexts.put("Field", FillupIsolatedVertices.fieldContext());
        typeContexts.put("Argument", FillupIsolatedVertices.argumentsContexts());
        typeContexts.put("InputField", FillupIsolatedVertices.inputFieldContexts());
        typeContexts.put("Object", FillupIsolatedVertices.objectContext());
        typeContexts.put("Interface", FillupIsolatedVertices.interfaceContext());
        typeContexts.put("Union", FillupIsolatedVertices.unionContext());
        typeContexts.put("InputObject", FillupIsolatedVertices.inputObjectContext());
        typeContexts.put("Scalar", FillupIsolatedVertices.scalarContext());
        typeContexts.put("Enum", FillupIsolatedVertices.enumContext());
        typeContexts.put("EnumValue", FillupIsolatedVertices.enumValueContext());
        typeContexts.put("AppliedDirective", FillupIsolatedVertices.appliedDirectiveContext());
        typeContexts.put("AppliedArgument", FillupIsolatedVertices.appliedArgumentContext());
        typeContexts.put("Directive", FillupIsolatedVertices.directiveContext());
    }

    public class IsolatedVertices {
        public Set<Vertex> allIsolatedSource = new LinkedHashSet<Vertex>();
        public Set<Vertex> allIsolatedTarget = new LinkedHashSet<Vertex>();
        public Table<List<String>, Set<Vertex>, Set<Vertex>> contexts = HashBasedTable.create();
        public Multimap<Vertex, Vertex> possibleMappings = HashMultimap.create();
        public Mapping mapping = new Mapping();

        public void putPossibleMappings(Collection<Vertex> sourceVertices, Collection<Vertex> targetVertex) {
            for (Vertex sourceVertex : sourceVertices) {
                this.possibleMappings.putAll(sourceVertex, targetVertex);
            }
        }

        public void addIsolatedSource(Collection<Vertex> isolatedSource) {
            this.allIsolatedSource.addAll(isolatedSource);
        }

        public void addIsolatedTarget(Collection<Vertex> isolatedTarget) {
            this.allIsolatedTarget.addAll(isolatedTarget);
        }

        public boolean mappingPossible(Vertex sourceVertex, Vertex targetVertex) {
            return this.possibleMappings.containsEntry(sourceVertex, targetVertex);
        }

        public void putContext(List<String> contextId, Set<Vertex> source, Set<Vertex> target) {
            if (this.contexts.containsRow(contextId)) {
                throw new IllegalArgumentException("Already context " + contextId);
            }
            Assert.assertTrue(source.size() == target.size());
            if (source.size() == 1) {
                this.mapping.add(source.iterator().next(), target.iterator().next());
            }
            this.contexts.put(contextId, source, target);
        }
    }

    public static abstract class VertexContextSegment {
        private List<VertexContextSegment> children;

        public VertexContextSegment(List<VertexContextSegment> children) {
            this.children = children;
        }

        public VertexContextSegment() {
            this.children = Collections.emptyList();
        }

        public VertexContextSegment(VertexContextSegment child) {
            this.children = Collections.singletonList(child);
        }

        public abstract String idForVertex(Vertex var1, SchemaGraph var2);

        public abstract boolean filter(Vertex var1, SchemaGraph var2);
    }
}

