/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Internal;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.Document;
import graphql.language.Node;
import graphql.language.SourceLocation;
import graphql.language.Type;
import graphql.language.Value;
import graphql.org.antlr.v4.runtime.BaseErrorListener;
import graphql.org.antlr.v4.runtime.CharStreams;
import graphql.org.antlr.v4.runtime.CodePointCharStream;
import graphql.org.antlr.v4.runtime.CommonTokenStream;
import graphql.org.antlr.v4.runtime.ParserRuleContext;
import graphql.org.antlr.v4.runtime.RecognitionException;
import graphql.org.antlr.v4.runtime.Recognizer;
import graphql.org.antlr.v4.runtime.Token;
import graphql.org.antlr.v4.runtime.atn.ParserATNSimulator;
import graphql.org.antlr.v4.runtime.atn.PredictionMode;
import graphql.org.antlr.v4.runtime.tree.TerminalNode;
import graphql.parser.AntlrHelper;
import graphql.parser.ExtendedBailStrategy;
import graphql.parser.GraphqlAntlrToLanguage;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.MultiSourceReader;
import graphql.parser.ParserEnvironment;
import graphql.parser.ParserOptions;
import graphql.parser.ParsingListener;
import graphql.parser.SafeTokenSource;
import graphql.parser.antlr.GraphqlBaseListener;
import graphql.parser.antlr.GraphqlLexer;
import graphql.parser.antlr.GraphqlParser;
import graphql.parser.exceptions.ParseCancelledException;
import graphql.parser.exceptions.ParseCancelledTooDeepException;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

@PublicApi
public class Parser {
    @Internal
    public static final int CHANNEL_COMMENTS = 2;
    @Internal
    public static final int CHANNEL_WHITESPACE = 3;

    public static Document parse(ParserEnvironment environment) throws InvalidSyntaxException {
        return new Parser().parseDocument(environment);
    }

    public static Document parse(String input) throws InvalidSyntaxException {
        return new Parser().parseDocument(input);
    }

    public static Value<?> parseValue(String input) throws InvalidSyntaxException {
        return new Parser().parseValueImpl(input);
    }

    public static Type<?> parseType(String input) throws InvalidSyntaxException {
        return new Parser().parseTypeImpl(input);
    }

    public Document parseDocument(ParserEnvironment environment) throws InvalidSyntaxException {
        return this.parseDocumentImpl(environment);
    }

    public Document parseDocument(String input) throws InvalidSyntaxException {
        return this.parseDocument(input, (ParserOptions)null);
    }

    public Document parseDocument(Reader reader) throws InvalidSyntaxException {
        ParserEnvironment parserEnvironment = ParserEnvironment.newParserEnvironment().document(reader).build();
        return this.parseDocumentImpl(parserEnvironment);
    }

    @Deprecated
    public Document parseDocument(String input, String sourceName) throws InvalidSyntaxException {
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, sourceName).trackData(true).build();
        return this.parseDocument(multiSourceReader);
    }

    @Deprecated
    public Document parseDocument(String input, ParserOptions parserOptions) throws InvalidSyntaxException {
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, null).trackData(true).build();
        return this.parseDocument(multiSourceReader, parserOptions);
    }

    @Deprecated
    public Document parseDocument(Reader reader, ParserOptions parserOptions) throws InvalidSyntaxException {
        ParserEnvironment parserEnvironment = ParserEnvironment.newParserEnvironment().document(reader).parserOptions(parserOptions).build();
        return this.parseDocumentImpl(parserEnvironment);
    }

    private Document parseDocumentImpl(ParserEnvironment environment) throws InvalidSyntaxException {
        BiFunction<GraphqlParser, GraphqlAntlrToLanguage, Object[]> nodeFunction = (parser, toLanguage) -> {
            GraphqlParser.DocumentContext documentContext = parser.document();
            Document doc = toLanguage.createDocument(documentContext);
            return new Object[]{documentContext, doc};
        };
        return (Document)this.parseImpl(environment, nodeFunction);
    }

    private Value<?> parseValueImpl(String input) throws InvalidSyntaxException {
        BiFunction<GraphqlParser, GraphqlAntlrToLanguage, Object[]> nodeFunction = (parser, toLanguage) -> {
            GraphqlParser.ValueContext documentContext = parser.value();
            Value value = toLanguage.createValue(documentContext);
            return new Object[]{documentContext, value};
        };
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, null).trackData(true).build();
        ParserEnvironment parserEnvironment = ParserEnvironment.newParserEnvironment().document(multiSourceReader).build();
        return (Value)this.parseImpl(parserEnvironment, nodeFunction);
    }

    private Type<?> parseTypeImpl(String input) throws InvalidSyntaxException {
        BiFunction<GraphqlParser, GraphqlAntlrToLanguage, Object[]> nodeFunction = (parser, toLanguage) -> {
            GraphqlParser.TypeContext documentContext = parser.type();
            Type value = toLanguage.createType(documentContext);
            return new Object[]{documentContext, value};
        };
        MultiSourceReader multiSourceReader = MultiSourceReader.newMultiSourceReader().string(input, null).trackData(true).build();
        ParserEnvironment parserEnvironment = ParserEnvironment.newParserEnvironment().document(multiSourceReader).build();
        return (Type)this.parseImpl(parserEnvironment, nodeFunction);
    }

    private Node<?> parseImpl(final ParserEnvironment environment, BiFunction<GraphqlParser, GraphqlAntlrToLanguage, Object[]> nodeFunction) throws InvalidSyntaxException {
        CodePointCharStream charStream;
        ParserOptions parserOptions = environment.getParserOptions();
        parserOptions = Optional.ofNullable(parserOptions).orElse(ParserOptions.getDefaultParserOptions());
        Reader reader = environment.getDocument();
        final MultiSourceReader multiSourceReader = reader instanceof MultiSourceReader ? (MultiSourceReader)reader : MultiSourceReader.newMultiSourceReader().reader(reader, null).trackData(parserOptions.isReaderTrackData()).build();
        try {
            charStream = CharStreams.fromReader(multiSourceReader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        GraphqlLexer lexer = new GraphqlLexer(charStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener(new BaseErrorListener(){

            @Override
            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String antlerMsg, RecognitionException e) {
                ImmutableList<Object> args;
                String msgKey;
                SourceLocation sourceLocation = AntlrHelper.createSourceLocation(multiSourceReader, line, charPositionInLine);
                String preview = AntlrHelper.createPreview(multiSourceReader, line);
                if (antlerMsg == null) {
                    msgKey = "InvalidSyntax.noMessage";
                    args = ImmutableList.of(Integer.valueOf(sourceLocation.getLine()), Integer.valueOf(sourceLocation.getColumn()));
                } else {
                    msgKey = "InvalidSyntax.full";
                    args = ImmutableList.of(antlerMsg, Integer.valueOf(sourceLocation.getLine()), Integer.valueOf(sourceLocation.getColumn()));
                }
                String msg = environment.getI18N().msg(msgKey, args);
                throw new InvalidSyntaxException(msg, sourceLocation, null, preview, null);
            }
        });
        int maxTokens = parserOptions.getMaxTokens();
        int maxWhitespaceTokens = parserOptions.getMaxWhitespaceTokens();
        BiConsumer<Integer, Token> onTooManyTokens = (maxTokenCount, token) -> this.throwIfTokenProblems(environment, (Token)token, (int)maxTokenCount, multiSourceReader, (Class<? extends InvalidSyntaxException>)ParseCancelledException.class);
        SafeTokenSource safeTokenSource = new SafeTokenSource(lexer, maxTokens, maxWhitespaceTokens, onTooManyTokens);
        CommonTokenStream tokens = new CommonTokenStream(safeTokenSource);
        GraphqlParser parser = new GraphqlParser(tokens);
        parser.removeErrorListeners();
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        ExtendedBailStrategy bailStrategy = new ExtendedBailStrategy(multiSourceReader, environment);
        parser.setErrorHandler(bailStrategy);
        GraphqlAntlrToLanguage toLanguage = this.getAntlrToLanguage(tokens, multiSourceReader, environment);
        this.setupParserListener(environment, multiSourceReader, parser, toLanguage);
        Object[] contextAndNode = nodeFunction.apply(parser, toLanguage);
        ParserRuleContext parserRuleContext = (ParserRuleContext)contextAndNode[0];
        Node node = (Node)contextAndNode[1];
        Token stop = parserRuleContext.getStop();
        List<Token> allTokens = tokens.getTokens();
        if (stop != null && allTokens != null && !allTokens.isEmpty()) {
            boolean sameChannel;
            Token last = allTokens.get(allTokens.size() - 1);
            boolean notEOF = last.getType() != -1;
            boolean lastGreaterThanDocument = last.getTokenIndex() > stop.getTokenIndex();
            boolean bl = sameChannel = last.getChannel() == stop.getChannel();
            if (notEOF && lastGreaterThanDocument && sameChannel) {
                throw bailStrategy.mkMoreTokensException(last);
            }
        }
        return node;
    }

    private void setupParserListener(final ParserEnvironment environment, final MultiSourceReader multiSourceReader, GraphqlParser parser, GraphqlAntlrToLanguage toLanguage) {
        ParserOptions parserOptions = toLanguage.getParserOptions();
        final ParsingListener parsingListener = parserOptions.getParsingListener();
        final int maxTokens = parserOptions.getMaxTokens();
        final int maxRuleDepth = parserOptions.getMaxRuleDepth();
        GraphqlBaseListener listener = new GraphqlBaseListener(){
            int count = 0;
            int depth = 0;

            @Override
            public void enterEveryRule(ParserRuleContext ctx) {
                ++this.depth;
                if (this.depth > maxRuleDepth) {
                    Parser.this.throwIfTokenProblems(environment, ctx.getStart(), maxRuleDepth, multiSourceReader, ParseCancelledTooDeepException.class);
                }
            }

            @Override
            public void exitEveryRule(ParserRuleContext ctx) {
                --this.depth;
            }

            @Override
            public void visitTerminal(TerminalNode node) {
                final Token token = node.getSymbol();
                parsingListener.onToken(new ParsingListener.Token(){

                    @Override
                    public String getText() {
                        return token == null ? null : token.getText();
                    }

                    @Override
                    public int getLine() {
                        return token == null ? -1 : token.getLine();
                    }

                    @Override
                    public int getCharPositionInLine() {
                        return token == null ? -1 : token.getCharPositionInLine();
                    }
                });
                ++this.count;
                if (this.count > maxTokens) {
                    Parser.this.throwIfTokenProblems(environment, token, maxTokens, multiSourceReader, ParseCancelledException.class);
                }
            }
        };
        parser.addParseListener(listener);
    }

    private void throwIfTokenProblems(ParserEnvironment environment, Token token, int maxLimit, MultiSourceReader multiSourceReader, Class<? extends InvalidSyntaxException> targetException) throws ParseCancelledException {
        String tokenType = "grammar";
        SourceLocation sourceLocation = null;
        String offendingToken = null;
        if (token != null) {
            int channel = token.getChannel();
            tokenType = channel == 3 ? "whitespace" : (channel == 2 ? "comments" : "grammar");
            offendingToken = token.getText();
            sourceLocation = AntlrHelper.createSourceLocation(multiSourceReader, token.getLine(), token.getCharPositionInLine());
        }
        if (targetException.equals(ParseCancelledTooDeepException.class)) {
            throw new ParseCancelledTooDeepException(environment.getI18N(), sourceLocation, offendingToken, maxLimit, tokenType);
        }
        throw new ParseCancelledException(environment.getI18N(), sourceLocation, offendingToken, maxLimit, tokenType);
    }

    protected GraphqlAntlrToLanguage getAntlrToLanguage(CommonTokenStream tokens, MultiSourceReader multiSourceReader, ParserEnvironment environment) {
        return new GraphqlAntlrToLanguage(tokens, multiSourceReader, environment.getParserOptions(), environment.getI18N(), null);
    }
}

