/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.AssertException;
import graphql.Internal;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.normalized.NormalizedInputValue;
import graphql.normalized.VariableValueWithDefinition;
import graphql.parser.Parser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import manifold.shade.org.jetbrains.annotations.NotNull;
import manifold.shade.org.jetbrains.annotations.Nullable;

@Internal
public class ValueToVariableValueCompiler {
    static VariableValueWithDefinition normalizedInputValueToVariable(NormalizedInputValue normalizedInputValue, int queryVariableCount) {
        Object variableValue = ValueToVariableValueCompiler.normalisedValueToVariableValue(normalizedInputValue);
        String varName = ValueToVariableValueCompiler.getVarName(queryVariableCount);
        return new VariableValueWithDefinition(variableValue, VariableDefinition.newVariableDefinition().name(varName).type(Parser.parseType(normalizedInputValue.getTypeName())).build(), VariableReference.newVariableReference().name(varName).build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    static Object normalisedValueToVariableValue(Object maybeValue) {
        if (maybeValue instanceof NormalizedInputValue) {
            NormalizedInputValue normalizedInputValue = (NormalizedInputValue)maybeValue;
            Object inputValue = normalizedInputValue.getValue();
            if (inputValue instanceof Value) {
                return ValueToVariableValueCompiler.toVariableValue((Value)inputValue);
            }
            if (inputValue instanceof List) {
                return ValueToVariableValueCompiler.normalisedValueToVariableValues((List)inputValue);
            }
            if (inputValue instanceof Map) {
                return ValueToVariableValueCompiler.normalisedValueToVariableValues((Map)inputValue);
            }
            if (inputValue != null) throw new AssertException("Should never happen. Did not expect NormalizedInputValue.getValue() of type: " + ValueToVariableValueCompiler.maybeClass(inputValue));
            return null;
        }
        if (maybeValue instanceof Value) {
            Value value = (Value)maybeValue;
            return ValueToVariableValueCompiler.toVariableValue(value);
        }
        if (maybeValue instanceof List) {
            return ValueToVariableValueCompiler.normalisedValueToVariableValues((List)maybeValue);
        }
        if (!(maybeValue instanceof Map)) throw new AssertException("Should never happen. Did not expect type: " + ValueToVariableValueCompiler.maybeClass(maybeValue));
        return ValueToVariableValueCompiler.normalisedValueToVariableValues((Map)maybeValue);
    }

    private static List<Object> normalisedValueToVariableValues(List<Object> arrayValues) {
        return arrayValues.stream().map(ValueToVariableValueCompiler::normalisedValueToVariableValue).collect(Collectors.toList());
    }

    @NotNull
    private static Map<String, Object> normalisedValueToVariableValues(Map<String, Object> objectMap) {
        LinkedHashMap<String, Object> output = new LinkedHashMap<String, Object>();
        objectMap.forEach((k, v) -> {
            Object value = ValueToVariableValueCompiler.normalisedValueToVariableValue(v);
            output.put((String)k, value);
        });
        return output;
    }

    private static Map<String, Object> toVariableValue(ObjectValue objectValue) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List<ObjectField> objectFields = objectValue.getObjectFields();
        for (ObjectField objectField : objectFields) {
            String objectFieldName = objectField.getName();
            Value objectFieldValue = objectField.getValue();
            map.put(objectFieldName, ValueToVariableValueCompiler.toVariableValue(objectFieldValue));
        }
        return map;
    }

    @NotNull
    private static List<Object> toVariableValues(List<Value> arrayValues) {
        return arrayValues.stream().map(ValueToVariableValueCompiler::toVariableValue).collect(Collectors.toList());
    }

    @Nullable
    private static Object toVariableValue(Value<?> value) {
        if (value instanceof ObjectValue) {
            return ValueToVariableValueCompiler.toVariableValue((ObjectValue)value);
        }
        if (value instanceof ArrayValue) {
            return ValueToVariableValueCompiler.toVariableValues(((ArrayValue)value).getValues());
        }
        if (value instanceof StringValue) {
            return ((StringValue)value).getValue();
        }
        if (value instanceof FloatValue) {
            return ((FloatValue)value).getValue();
        }
        if (value instanceof IntValue) {
            return ((IntValue)value).getValue();
        }
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isValue();
        }
        if (value instanceof EnumValue) {
            return ((EnumValue)value).getName();
        }
        if (value instanceof NullValue) {
            return null;
        }
        throw new AssertException("Should never happen. Cannot handle node of type: " + ValueToVariableValueCompiler.maybeClass(value));
    }

    private static Object maybeClass(Object maybe) {
        return maybe == null ? "null" : maybe.getClass();
    }

    private static String getVarName(int variableOrdinal) {
        return "v" + variableOrdinal;
    }
}

