/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class ExecutionResultImpl
implements ExecutionResult {
    private final List<GraphQLError> errors;
    private final Object data;
    private final transient Map<Object, Object> extensions;
    private final transient boolean dataPresent;

    public ExecutionResultImpl(GraphQLError error) {
        this(false, null, Collections.singletonList(error), null);
    }

    public ExecutionResultImpl(List<? extends GraphQLError> errors) {
        this(false, null, errors, null);
    }

    public ExecutionResultImpl(Object data, List<? extends GraphQLError> errors) {
        this(true, data, errors, null);
    }

    public ExecutionResultImpl(Object data, List<? extends GraphQLError> errors, Map<Object, Object> extensions) {
        this(true, data, errors, extensions);
    }

    public ExecutionResultImpl(ExecutionResultImpl other) {
        this(other.dataPresent, other.data, other.errors, other.extensions);
    }

    private ExecutionResultImpl(boolean dataPresent, Object data, List<? extends GraphQLError> errors, Map<Object, Object> extensions) {
        this.dataPresent = dataPresent;
        this.data = data;
        this.errors = errors != null ? ImmutableList.copyOf(errors) : ImmutableKit.emptyList();
        this.extensions = extensions;
    }

    @Override
    public boolean isDataPresent() {
        return this.dataPresent;
    }

    @Override
    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    @Override
    public <T> T getData() {
        return (T)this.data;
    }

    @Override
    public Map<Object, Object> getExtensions() {
        return this.extensions;
    }

    @Override
    public Map<String, Object> toSpecification() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.errors != null && !this.errors.isEmpty()) {
            result.put("errors", this.errorsToSpec(this.errors));
        }
        if (this.dataPresent) {
            result.put("data", this.data);
        }
        if (this.extensions != null) {
            result.put("extensions", this.extensions);
        }
        return result;
    }

    private Object errorsToSpec(List<GraphQLError> errors) {
        return ImmutableKit.map(errors, GraphQLError::toSpecification);
    }

    public String toString() {
        return "ExecutionResultImpl{errors=" + this.errors + ", data=" + this.data + ", dataPresent=" + this.dataPresent + ", extensions=" + this.extensions + '}';
    }

    public static Builder newExecutionResult() {
        return new Builder();
    }

    public static class Builder
    implements ExecutionResult.Builder<Builder> {
        private boolean dataPresent;
        private Object data;
        private List<GraphQLError> errors = new ArrayList<GraphQLError>();
        private Map<Object, Object> extensions;

        @Override
        public Builder from(ExecutionResult executionResult) {
            this.dataPresent = executionResult.isDataPresent();
            this.data = executionResult.getData();
            this.errors = new ArrayList<GraphQLError>(executionResult.getErrors());
            this.extensions = executionResult.getExtensions();
            return this;
        }

        @Override
        public Builder data(Object data) {
            this.dataPresent = true;
            this.data = data;
            return this;
        }

        @Override
        public Builder errors(List<GraphQLError> errors) {
            this.errors = errors;
            return this;
        }

        @Override
        public Builder addErrors(List<GraphQLError> errors) {
            this.errors.addAll(errors);
            return this;
        }

        @Override
        public Builder addError(GraphQLError error) {
            this.errors.add(error);
            return this;
        }

        @Override
        public Builder extensions(Map<Object, Object> extensions) {
            this.extensions = extensions;
            return this;
        }

        @Override
        public Builder addExtension(String key, Object value) {
            this.extensions = this.extensions == null ? new LinkedHashMap() : this.extensions;
            this.extensions.put(key, value);
            return this;
        }

        @Override
        public ExecutionResult build() {
            return new ExecutionResultImpl(this.dataPresent, this.data, this.errors, this.extensions);
        }
    }
}

