/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import javax.lang.model.type.NoType;

public class RecursiveTypeVarEraser
extends Types.UnaryVisitor<Type> {
    private final Types _types;

    public static Type eraseTypeVars(Types types, Type type) {
        return (Type)new RecursiveTypeVarEraser(types).visit(type);
    }

    private RecursiveTypeVarEraser(Types types) {
        this._types = types;
    }

    @Override
    public Type visitClassType(Type.ClassType t, Void s) {
        boolean erased = false;
        Type erasure = this._types.erasure(t);
        Type base = this.visitType(erasure, s);
        if (base != erasure) {
            erased = true;
        }
        ArrayList<Type> params = new ArrayList<Type>();
        for (Type arg : t.allparams()) {
            Type.TypeVar typeVar = null;
            if (arg instanceof Type.TypeVar) {
                typeVar = (Type.TypeVar)arg;
            }
            Type param = (Type)this.visit(arg);
            if (typeVar != null) {
                param = this.makeWildCard(param, typeVar);
            }
            params.add(param);
            if (param == arg) continue;
            erased = true;
        }
        if (erased) {
            return new Type.ClassType(t.getEnclosingType(), List.from(params), base.tsym);
        }
        return t;
    }

    private Type makeWildCard(Type t, Type.TypeVar typeVar) {
        return typeVar.getUpperBound() == null ? new Type.WildcardType(t, BoundKind.SUPER, t.tsym) : new Type.WildcardType(t, BoundKind.EXTENDS, t.tsym);
    }

    @Override
    public Type visitArrayType(Type.ArrayType t, Void aVoid) {
        Type compType = (Type)this.visit(t.getComponentType());
        if (compType == t.getComponentType()) {
            return t;
        }
        return new Type.ArrayType(compType, t.tsym);
    }

    @Override
    public Type visitCapturedType(Type.CapturedType t, Void s) {
        Type w_bound = t.wildcard.type;
        if ((w_bound = this.eraseBound(t, w_bound)) == t.wildcard.type) {
            return t;
        }
        return new Type.CapturedType(t.tsym.name, t.tsym.owner, w_bound, t.lower, t.wildcard);
    }

    @Override
    public Type visitTypeVar(Type.TypeVar t, Void s) {
        Type bound = this.eraseBound(t, t.getUpperBound());
        Type lower = this.eraseBound(t, t.lower);
        return bound == null ? lower : bound;
    }

    @Override
    public Type visitWildcardType(Type.WildcardType t, Void s) {
        Type bound = this.eraseBound(t, t.type);
        if (bound == t.type) {
            return t;
        }
        return new Type.WildcardType(bound, t.kind, t.tsym);
    }

    @Override
    public Type visitType(Type t, Void o) {
        return t;
    }

    private Type eraseBound(Type t, Type bound) {
        if (bound == null || bound instanceof NoType) {
            return bound;
        }
        Type erasedBound = bound.contains(t) ? (Type)this.visit(this._types.erasure(bound)) : (Type)this.visit(bound);
        return erasedBound;
    }
}

