/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import manifold.api.host.IManifoldHost;
import manifold.api.util.JavacDiagnostic;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.ParentMap;
import manifold.util.ReflectUtil;

public abstract class CompiledTypeProcessor
implements TaskListener {
    private final IManifoldHost _host;
    private final BasicJavacTask _javacTask;
    private CompilationUnitTree _compilationUnit;
    private final Map<String, Boolean> _typesToProcess;
    private ParentMap _parents;
    private final IssueReporter<JavaFileObject> _issueReporter;
    private Map<String, JCTree.JCClassDecl> _innerClassForGeneration;
    private JCTree.JCClassDecl _tree;
    private boolean _generate;

    CompiledTypeProcessor(IManifoldHost host, BasicJavacTask javacTask) {
        this._host = host;
        this._javacTask = javacTask;
        javacTask.addTaskListener(this);
        this._issueReporter = new IssueReporter(this._javacTask::getContext);
        this._typesToProcess = new HashMap<String, Boolean>();
        this._innerClassForGeneration = new HashMap<String, JCTree.JCClassDecl>();
        this._parents = new ParentMap(() -> this.getCompilationUnit());
    }

    protected abstract void process(TypeElement var1, IssueReporter<JavaFileObject> var2);

    public Context getContext() {
        return ((BasicJavacTask)this.getJavacTask()).getContext();
    }

    public IManifoldHost getHost() {
        return this._host;
    }

    public JavacTask getJavacTask() {
        return this._javacTask;
    }

    public JCTree.JCClassDecl getTree() {
        return this._tree;
    }

    public boolean isGenerate() {
        return this._generate;
    }

    public CompilationUnitTree getCompilationUnit() {
        return this._compilationUnit;
    }

    public Types getTypes() {
        return Types.instance(this._javacTask.getContext());
    }

    public JavacElements getElementUtil() {
        return JavacElements.instance(this.getContext());
    }

    public Trees getTreeUtil() {
        return Trees.instance(this.getJavacTask());
    }

    public TreeMaker getTreeMaker() {
        return TreeMaker.instance(this.getContext());
    }

    public Symtab getSymtab() {
        return Symtab.instance(this.getContext());
    }

    public Tree getParent(Tree node) {
        return this._parents.getParent(node);
    }

    public Tree getParent(Tree node, CompilationUnitTree compUnit) {
        return this._parents.getParent(node, compUnit);
    }

    public JCTree.JCClassDecl getClassDecl(Tree node) {
        if (node == null || node instanceof JCTree.JCCompilationUnit) {
            return null;
        }
        if (node instanceof JCTree.JCClassDecl) {
            return (JCTree.JCClassDecl)node;
        }
        return this.getClassDecl(this.getParent(node));
    }

    public JavaFileObject getFile(Tree node) {
        JCTree.JCClassDecl classDecl = this.getClassDecl(node);
        if (classDecl == null) {
            Symbol sym;
            ReflectUtil.LiveFieldRef symField = ReflectUtil.WithNull.field(node, "sym");
            Symbol symbol = sym = symField == null ? null : (Symbol)symField.get();
            while (sym != null) {
                Symbol owner = sym.owner;
                if (owner instanceof Symbol.ClassSymbol) {
                    return ((Symbol.ClassSymbol)owner).sourcefile;
                }
                sym = owner;
            }
        }
        return classDecl == null ? null : classDecl.sym.sourcefile;
    }

    public void report(JCTree tree, Diagnostic.Kind kind, String msg) {
        this.report(null, tree, kind, msg);
    }

    public void report(JavaFileObject sourcefile, JCTree tree, Diagnostic.Kind kind, String msg) {
        IssueReporter<JavaFileObject> reporter = new IssueReporter<JavaFileObject>(this._javacTask::getContext);
        JavaFileObject file = sourcefile != null ? sourcefile : this.getFile(tree);
        reporter.report(new JavacDiagnostic(file, kind, tree.getStartPosition(), 0L, 0L, msg));
    }

    public Map<String, Boolean> getTypesToProcess() {
        return this._typesToProcess;
    }

    void addTypesToProcess(Set<String> types) {
        types.forEach(e -> this._typesToProcess.put((String)e, false));
    }

    @Override
    public void started(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.GENERATE) {
            return;
        }
        TypeElement elem = e.getTypeElement();
        if (elem instanceof Symbol.ClassSymbol) {
            this._tree = this._typesToProcess.containsKey(elem.getQualifiedName().toString()) ? this.findTopLevel((Symbol.ClassSymbol)elem, e.getCompilationUnit().getTypeDecls()) : this._innerClassForGeneration.get(((Symbol.ClassSymbol)elem).flatName().toString());
            if (this._tree != null) {
                this._compilationUnit = e.getCompilationUnit();
                this._generate = true;
                this.process(elem, this._issueReporter);
            }
        }
    }

    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        this._generate = false;
        String fqn = e.getTypeElement().getQualifiedName().toString();
        Boolean visited = this._typesToProcess.get(fqn);
        if (visited == Boolean.TRUE) {
            return;
        }
        if (fqn.isEmpty()) {
            return;
        }
        this._typesToProcess.put(fqn, true);
        this._compilationUnit = e.getCompilationUnit();
        TypeElement elem = e.getTypeElement();
        this._tree = (JCTree.JCClassDecl)this.getTreeUtil().getTree(elem);
        if (this._tree != null) {
            this.preserveInnerClassesForGeneration(this._tree);
            this.process(elem, this._issueReporter);
        }
    }

    private JCTree.JCClassDecl findTopLevel(Symbol.ClassSymbol type, List<? extends Tree> typeDecls) {
        for (Tree tree : typeDecls) {
            if (!(tree instanceof JCTree.JCClassDecl) || ((JCTree.JCClassDecl)tree).sym != type) continue;
            return (JCTree.JCClassDecl)tree;
        }
        return null;
    }

    private void preserveInnerClassesForGeneration(JCTree.JCClassDecl tree) {
        for (JCTree def : tree.defs) {
            if (!(def instanceof JCTree.JCClassDecl)) continue;
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)def;
            this.preserveInnerClassForGenerationPhase(classDecl);
            this.preserveInnerClassesForGeneration(classDecl);
        }
    }

    public void preserveInnerClassForGenerationPhase(JCTree.JCClassDecl def) {
        this._innerClassForGeneration.put(def.sym.flatName().toString(), def);
    }
}

