/*
 * Decompiled with CFR 0.152.
 */
package manifold.ext.delegation;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.AttrContextEnv;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import manifold.api.type.ICompilerComponent;
import manifold.api.util.JavacDiagnostic;
import manifold.ext.delegation.DelegationIssueMsg;
import manifold.ext.delegation.Util;
import manifold.ext.delegation.rt.RuntimeMethods;
import manifold.ext.delegation.rt.api.link;
import manifold.ext.delegation.rt.api.part;
import manifold.ext.delegation.rt.api.tags.enter_finish;
import manifold.ext.rt.ExtensionMethod;
import manifold.ext.rt.api.Structural;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.IssueReporter;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ParentMap;
import manifold.internal.javac.TypeProcessor;
import manifold.rt.api.util.Stack;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class DelegationProcessor
implements ICompilerComponent,
TaskListener {
    private BasicJavacTask _javacTask;
    private Context _context;
    private Stack<ClassInfo> _classInfoStack;
    private Stack<JCTree.JCClassDecl> _classDeclStack;
    private TaskEvent _taskEvent;
    private ParentMap _parents;

    @Override
    public void init(BasicJavacTask javacTask, TypeProcessor typeProcessor) {
        this._javacTask = javacTask;
        this._context = this._javacTask.getContext();
        this._classInfoStack = new Stack();
        this._classDeclStack = new Stack();
        this._parents = new ParentMap(() -> this.getCompilationUnit());
        if (JavacPlugin.instance() == null) {
            return;
        }
        typeProcessor.addTaskListener(this);
    }

    BasicJavacTask getJavacTask() {
        return this._javacTask;
    }

    Context getContext() {
        return this._context;
    }

    Tree getParent(Tree child) {
        return this._parents.getParent(child);
    }

    public Types getTypes() {
        return Types.instance(this.getContext());
    }

    public Names getNames() {
        return Names.instance(this.getContext());
    }

    public TreeMaker getTreeMaker() {
        return TreeMaker.instance(this.getContext());
    }

    public Symtab getSymtab() {
        return Symtab.instance(this.getContext());
    }

    @Override
    public void tailorCompiler() {
        this._context = this._javacTask.getContext();
    }

    private CompilationUnitTree getCompilationUnit() {
        CompilationUnitTree compUnit;
        if (this._taskEvent != null && (compUnit = this._taskEvent.getCompilationUnit()) != null) {
            return compUnit;
        }
        return JavacPlugin.instance() != null ? JavacPlugin.instance().getTypeProcessor().getCompilationUnit() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void started(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        this._taskEvent = e;
        try {
            this.ensureInitialized(this._taskEvent);
            for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
                if (!(tree instanceof JCTree.JCClassDecl)) continue;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
                if (e.getKind() != TaskEvent.Kind.ANALYZE) continue;
                classDecl.accept(new Analyze_Start());
            }
        }
        finally {
            this._taskEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(TaskEvent e) {
        if (e.getKind() != TaskEvent.Kind.ENTER && e.getKind() != TaskEvent.Kind.ANALYZE) {
            return;
        }
        this._taskEvent = e;
        try {
            this.ensureInitialized(this._taskEvent);
            for (Tree tree : e.getCompilationUnit().getTypeDecls()) {
                if (!(tree instanceof JCTree.JCClassDecl)) continue;
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
                if (e.getKind() == TaskEvent.Kind.ENTER) {
                    classDecl.accept(new Enter_Finish());
                    continue;
                }
                if (e.getKind() != TaskEvent.Kind.ANALYZE) continue;
                classDecl.accept(new Analyze_Finish());
            }
        }
        finally {
            this._taskEvent = null;
        }
    }

    private void findAllInterfaces(Type type, Set<Type> seen, ArrayList<Type.ClassType> result) {
        java.util.List superInterfaces;
        if (seen.stream().anyMatch(t -> this.getTypes().isSameType((Type)t, type))) {
            return;
        }
        seen.add(type);
        if (type.isInterface()) {
            if (result.stream().noneMatch(e -> this.getTypes().isSameType((Type)e, type))) {
                result.add((Type.ClassType)type);
            }
        } else {
            Type superClass = ((Symbol.ClassSymbol)type.tsym).getSuperclass();
            this.findAllInterfaces(type, superClass, seen, result);
        }
        if ((superInterfaces = ((Symbol.ClassSymbol)type.tsym).getInterfaces()) != null) {
            superInterfaces.forEach(superInterface -> this.findAllInterfaces(type, (Type)superInterface, seen, result));
        }
    }

    private void findAllInterfaces(Type type, Type superType, Set<Type> seen, ArrayList<Type.ClassType> result) {
        if ((superType = DelegationProcessor.getUnderlyingType(superType)) != Type.noType && !superType.isErroneous()) {
            superType = this.getTypes().asSuper(type, superType.tsym);
            this.findAllInterfaces(superType, seen, result);
        }
    }

    private static Type getUnderlyingType(Type type) {
        return JreUtil.isJava8() ? type.unannotatedType() : (Type)ReflectUtil.method(type, "stripMetadata", new Class[0]).invoke(new Object[0]);
    }

    private void reportWarning(JCTree location, String message) {
        this.report(Diagnostic.Kind.WARNING, location, message);
    }

    private void reportError(JCTree location, String message) {
        this.report(Diagnostic.Kind.ERROR, location, message);
    }

    private void report(Diagnostic.Kind kind, JCTree location, String message) {
        this.report(this._taskEvent.getSourceFile(), location, kind, message);
    }

    public void report(JavaFileObject sourcefile, JCTree tree, Diagnostic.Kind kind, String msg) {
        IssueReporter<JavaFileObject> reporter = new IssueReporter<JavaFileObject>(this._javacTask::getContext);
        JavaFileObject file = sourcefile != null ? sourcefile : Util.getFile(tree, child -> this.getParent((Tree)child));
        reporter.report(new JavacDiagnostic(file, kind, tree.getStartPosition(), 0L, 0L, msg));
    }

    private void addAnnotation(Symbol sym, Class<? extends Annotation> annoClass) {
        Symbol.ClassSymbol annoSym = IDynamicJdk.instance().getTypeElement(this._context, this.getCompilationUnit(), annoClass.getTypeName());
        Attribute.Compound anno = new Attribute.Compound(annoSym.type, List.nil());
        sym.appendAttributes(List.of(anno));
    }

    static Attribute.Compound getAnnotationMirror(Symbol sym, Class<? extends Annotation> annoClass) {
        for (Attribute.Compound anno : sym.getAnnotationMirrors()) {
            if (!annoClass.getTypeName().equals(anno.type.tsym.getQualifiedName().toString())) continue;
            return anno;
        }
        return null;
    }

    private void ensureInitialized(TaskEvent e) {
        JavacPlugin javacPlugin = JavacPlugin.instance();
        if (javacPlugin != null) {
            javacPlugin.initialize(e);
        }
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, String path) {
        return this.memberAccess(make, path.split("\\."));
    }

    private JCTree.JCExpression memberAccess(TreeMaker make, String ... components) {
        Names names = Names.instance(this.getContext());
        JCTree.JCExpression expr = make.Ident(names.fromString(components[0]));
        for (int i = 1; i < components.length; ++i) {
            expr = make.Select(expr, names.fromString(components[i]));
        }
        return expr;
    }

    private Symbol.ClassSymbol getRtClassSym(Class cls) {
        Symbol.ClassSymbol sym = IDynamicJdk.instance().getTypeElement(this.getContext(), this.getCompilationUnit(), cls.getTypeName());
        if (sym == null) {
            sym = JavacElements.instance(this.getContext()).getTypeElement(cls.getTypeName());
        }
        return sym;
    }

    public static Symbol.MethodSymbol resolveMethod(Context context, CompilationUnitTree compUnit, JCDiagnostic.DiagnosticPosition pos, Name name, Type qual, List<Type> args) {
        return DelegationProcessor.resolveMethod(pos, context, (JCTree.JCCompilationUnit)compUnit, name, qual, args);
    }

    private static Symbol.MethodSymbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Context ctx, JCTree.JCCompilationUnit compUnit, Name name, Type qual, List<Type> args) {
        Resolve rs = Resolve.instance(ctx);
        AttrContext attrContext = new AttrContext();
        AttrContextEnv env = new AttrContextEnv(pos.getTree(), attrContext);
        env.toplevel = compUnit;
        return rs.resolveInternalMethod(pos, env, qual, name, args, null);
    }

    private Symbol.VarSymbol resolveField(JCDiagnostic.DiagnosticPosition pos, Context ctx, Name name, Type qual, JCTree.JCClassDecl classPos) {
        Resolve rs = Resolve.instance(ctx);
        AttrContext attrContext = new AttrContext();
        AttrContextEnv env = new AttrContextEnv(pos.getTree(), attrContext);
        env.toplevel = (JCTree.JCCompilationUnit)this.getCompilationUnit();
        env.enclClass = classPos;
        return rs.resolveInternalField(pos, env, qual, name);
    }

    private static boolean isPartClass(Symbol sym) {
        Attribute.Compound partAnno = DelegationProcessor.getAnnotationMirror(sym, part.class);
        return partAnno != null;
    }

    private static boolean isInPartClass(Symbol sym) {
        Attribute.Compound partAnno = DelegationProcessor.getAnnotationMirror(sym, part.class);
        if (partAnno != null) {
            return true;
        }
        Symbol owner = sym.owner;
        return owner != null && owner != sym && DelegationProcessor.isInPartClass(owner);
    }

    private class NamedMethodType {
        private final Symbol.MethodSymbol _m;
        private final Type _type;

        public NamedMethodType(Symbol.MethodSymbol m, Type type) {
            this._m = m;
            this._type = type;
        }

        public Symbol.MethodSymbol getMethodSymbol() {
            return this._m;
        }

        public Name getName() {
            return this._m.name;
        }

        public Type getType() {
            return this._type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NamedMethodType that = (NamedMethodType)o;
            return Objects.equals(this._m.name, that._m.name) && DelegationProcessor.this.getTypes().hasSameArgs(this._type, that._type);
        }

        public int hashCode() {
            return Objects.hash(this._m.name);
        }
    }

    private class LinkInfo {
        private final JCTree.JCVariableDecl _linkField;
        private final ArrayList<JCTree.JCMethodDecl> _generatedMethods;
        private final Map<Name, Set<NamedMethodType>> _methodTypes;
        private final ArrayList<Type.ClassType> _interfaces;
        private final boolean _share;

        LinkInfo(JCTree.JCVariableDecl linkField, ArrayList<Type.ClassType> linkdInterfaces, boolean share) {
            this._linkField = linkField;
            this._generatedMethods = new ArrayList();
            this._methodTypes = new HashMap<Name, Set<NamedMethodType>>();
            this._interfaces = new ArrayList<Type.ClassType>(linkdInterfaces);
            this._share = share;
        }

        public JCTree.JCVariableDecl getLinkField() {
            return this._linkField;
        }

        public boolean isShare() {
            return this._share;
        }

        public Collection<JCTree.JCMethodDecl> getGeneratedMethods() {
            return this._generatedMethods;
        }

        void addGeneratedMethod(JCTree.JCMethodDecl methodDecl) {
            this._generatedMethods.add(methodDecl);
        }

        public ArrayList<Type.ClassType> getInterfaces() {
            return this._interfaces;
        }

        public Map<Name, Set<NamedMethodType>> getMethodTypes() {
            return this._methodTypes;
        }

        void addMethodType(Symbol.MethodSymbol m, Type mt) {
            if (this.hasMethodType(m.name, mt)) {
                throw new IllegalStateException();
            }
            Set methodTypes = this._methodTypes.computeIfAbsent(m.name, k -> new HashSet());
            methodTypes.add(new NamedMethodType(m, mt));
        }

        boolean hasMethodType(Name name, Type mt) {
            Set methodTypes = this._methodTypes.computeIfAbsent(name, k -> new HashSet());
            return methodTypes.stream().anyMatch(m -> DelegationProcessor.this.getTypes().hasSameArgs(m.getType(), mt));
        }
    }

    private class ClassInfo {
        private final JCTree.JCClassDecl _classDecl;
        private ArrayList<Type.ClassType> _interfaces;
        private final Map<JCTree.JCVariableDecl, LinkInfo> _linkInfos;
        private final Set<NamedMethodType> _defaultMethodForwarders;

        ClassInfo(JCTree.JCClassDecl classDecl) {
            this._classDecl = classDecl;
            this._linkInfos = new HashMap<JCTree.JCVariableDecl, LinkInfo>();
            this._defaultMethodForwarders = new HashSet<NamedMethodType>();
        }

        public ArrayList<Type.ClassType> getInterfaces() {
            if (this._interfaces == null) {
                ArrayList result = new ArrayList();
                DelegationProcessor.this.findAllInterfaces(this._classDecl.sym.type, new HashSet(), result);
                this._interfaces = result;
            }
            return this._interfaces;
        }

        boolean hasLinks() {
            return !this._linkInfos.isEmpty();
        }

        Map<JCTree.JCVariableDecl, LinkInfo> getLinks() {
            return this._linkInfos;
        }

        public void addDefaultMethodForwarder(NamedMethodType namedMt) {
            this._defaultMethodForwarders.add(namedMt);
        }

        public Set<NamedMethodType> getDefaultMethodForwarders() {
            return this._defaultMethodForwarders;
        }
    }

    private class Analyze_Finish
    extends TreeTranslator {
        private Analyze_Finish() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            DelegationProcessor.this._classDeclStack.push(tree);
            try {
                super.visitClassDef(tree);
            }
            finally {
                if (tree != DelegationProcessor.this._classDeclStack.pop()) {
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            super.visitIdent(tree);
            if (tree.name.toString().equals("this")) {
                this.replaceThis_Explicit(tree);
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            super.visitSelect(tree);
            if (tree.toString().endsWith(".this")) {
                this.replaceThis_Explicit(tree);
            }
        }

        private void replaceThis_Explicit(JCTree.JCExpression tree) {
            if (!DelegationProcessor.isPartClass(tree.type.tsym) || this.replaceThisArgument(tree) || this.replaceThisReceiver(tree) || this.replaceThisReturn(tree) || this.replaceThisCast(tree) || this.replaceThisTernary(tree) || !this.replaceThisAssignment(tree)) {
                // empty if block
            }
        }

        private boolean replaceThisAssignment(JCTree.JCExpression tree) {
            Tree parent = DelegationProcessor.this.getParent(tree);
            if (parent instanceof JCTree.JCAssign) {
                JCTree.JCAssign assignment = (JCTree.JCAssign)parent;
                if (assignment.type.isInterface()) {
                    JCTree.JCClassDecl classDecl = this.findClassDecl(tree.type);
                    this.result = this.replaceThis(tree, classDecl, assignment.type);
                } else {
                    DelegationProcessor.this.reportError(tree, DelegationIssueMsg.MSG_PART_THIS_NONINTERFACE_USE.get(new Object[0]));
                }
                return true;
            }
            if (parent instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl varDecl = (JCTree.JCVariableDecl)parent;
                if (varDecl.getType().type.isInterface()) {
                    JCTree.JCClassDecl classDecl = this.findClassDecl(tree.type);
                    this.result = this.replaceThis(tree, classDecl, varDecl.getType().type);
                } else {
                    DelegationProcessor.this.reportError(tree, DelegationIssueMsg.MSG_PART_THIS_NONINTERFACE_USE.get(new Object[0]));
                }
                return true;
            }
            return false;
        }

        private boolean replaceThisTernary(JCTree.JCExpression tree) {
            Tree parent = DelegationProcessor.this.getParent(tree);
            if (parent instanceof JCTree.JCConditional) {
                JCTree.JCConditional ternary = (JCTree.JCConditional)parent;
                if (ternary.type.isInterface()) {
                    JCTree.JCClassDecl classDecl = this.findClassDecl(tree.type);
                    this.result = this.replaceThis(tree, classDecl, ternary.type);
                } else {
                    DelegationProcessor.this.reportError(tree, DelegationIssueMsg.MSG_PART_THIS_NONINTERFACE_USE.get(new Object[0]));
                }
                return true;
            }
            return false;
        }

        private boolean replaceThisCast(JCTree.JCExpression tree) {
            Tree parent = DelegationProcessor.this.getParent(tree);
            if (parent instanceof JCTree.JCTypeCast) {
                JCTree.JCTypeCast cast = (JCTree.JCTypeCast)parent;
                if (cast.type.isInterface()) {
                    JCTree.JCClassDecl classDecl = this.findClassDecl(tree.type);
                    this.result = this.replaceThis(tree, classDecl, cast.type);
                } else {
                    DelegationProcessor.this.reportError(tree, DelegationIssueMsg.MSG_PART_THIS_NONINTERFACE_USE.get(new Object[0]));
                }
                return true;
            }
            return false;
        }

        private boolean replaceThisReceiver(JCTree.JCExpression tree) {
            Tree parent = DelegationProcessor.this.getParent(tree);
            if (parent instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)parent;
                if (!(fa.sym instanceof Symbol.MethodSymbol)) {
                    return false;
                }
                Symbol.MethodSymbol sym = (Symbol.MethodSymbol)fa.sym;
                Pair<JCTree.JCClassDecl, Type> enclClass_Iface = this.findInterfaceOfEnclosingTypeThatSymImplements(sym);
                if (enclClass_Iface == null) {
                    return false;
                }
                if (enclClass_Iface.snd != null) {
                    this.result = this.replaceThis(tree, (JCTree.JCClassDecl)enclClass_Iface.fst, (Type)enclClass_Iface.snd);
                    return true;
                }
            }
            return false;
        }

        private boolean replaceThisReturn(JCTree.JCExpression tree) {
            Tree parent = DelegationProcessor.this.getParent(tree);
            if (parent instanceof JCTree.JCReturn) {
                JCTree.JCReturn retStmt = (JCTree.JCReturn)parent;
                if (retStmt.expr == tree) {
                    Types types = DelegationProcessor.this.getTypes();
                    JCTree.JCMethodDecl method = this.findMethod(retStmt);
                    if (method != null) {
                        Type returnType = types.erasure(method.sym.getReturnType());
                        if (returnType.isInterface()) {
                            JCTree.JCClassDecl classDecl = this.findClassDecl(tree.type);
                            this.result = this.replaceThis(tree, classDecl, returnType);
                        } else if (!types.isSameType(DelegationProcessor.this.getSymtab().objectType, returnType)) {
                            DelegationProcessor.this.reportError(tree, DelegationIssueMsg.MSG_PART_THIS_NONINTERFACE_USE.get(new Object[0]));
                        }
                    }
                }
                return true;
            }
            return false;
        }

        private JCTree.JCMethodDecl findMethod(Tree tree) {
            if (tree == null) {
                return null;
            }
            if (tree instanceof JCTree.JCMethodDecl) {
                return (JCTree.JCMethodDecl)tree;
            }
            return this.findMethod(DelegationProcessor.this.getParent(tree));
        }

        private boolean replaceThisArgument(JCTree.JCExpression tree) {
            JCTree.JCMethodInvocation m;
            Tree parent = DelegationProcessor.this.getParent(tree);
            if (parent instanceof JCTree.JCMethodInvocation && (m = (JCTree.JCMethodInvocation)parent).getArguments() != null && ((List)m.getArguments()).contains(tree) && !this.isException_Arg(m)) {
                int index = ((List)m.getArguments()).indexOf(tree);
                Symbol.MethodSymbol sym = (Symbol.MethodSymbol)(m.meth instanceof JCTree.JCFieldAccess ? ((JCTree.JCFieldAccess)m.meth).sym : ((JCTree.JCIdent)m.meth).sym);
                Symbol.VarSymbol paramSym = (Symbol.VarSymbol)((List)sym.getParameters()).get(index);
                Types types = DelegationProcessor.this.getTypes();
                Type paramType = types.erasure(paramSym.type);
                if (paramType.isInterface()) {
                    JCTree.JCClassDecl classDecl = this.findClassDecl(m.args.get((int)index).type);
                    if (classDecl != null) {
                        this.result = this.replaceThis(tree, classDecl, paramType);
                    }
                } else if (!types.isSameType(DelegationProcessor.this.getSymtab().objectType, paramType)) {
                    DelegationProcessor.this.reportError(tree, DelegationIssueMsg.MSG_PART_THIS_NONINTERFACE_USE.get(new Object[0]));
                }
                return true;
            }
            return false;
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            super.visitApply(tree);
            this.processImpliedThisCall(tree);
            this.replaceSuperDefaultMethodCall(tree, false);
        }

        @Override
        public void visitExec(JCTree.JCExpressionStatement tree) {
            super.visitExec(tree);
            if (tree.expr instanceof JCTree.JCMethodInvocation) {
                this.replaceSuperDefaultMethodCall((JCTree.JCMethodInvocation)tree.expr, true);
            }
        }

        private void processImpliedThisCall(JCTree.JCMethodInvocation tree) {
            if (tree.meth instanceof JCTree.JCIdent) {
                Symbol.MethodSymbol sym = (Symbol.MethodSymbol)((JCTree.JCIdent)tree.meth).sym;
                if (sym.isStatic()) {
                    return;
                }
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)DelegationProcessor.this._classDeclStack.peek();
                if (!DelegationProcessor.isInPartClass(classDecl.sym)) {
                    return;
                }
                Pair<JCTree.JCClassDecl, Type> enclClass_Iface = this.findInterfaceOfEnclosingTypeThatSymImplements(sym);
                if (enclClass_Iface == null || !DelegationProcessor.isPartClass(((JCTree.JCClassDecl)enclClass_Iface.fst).sym)) {
                    return;
                }
                if (enclClass_Iface.snd != null) {
                    JCTree.JCExpression thisSub = this.replaceThis(tree, (JCTree.JCClassDecl)enclClass_Iface.fst, (Type)enclClass_Iface.snd);
                    TreeMaker make = DelegationProcessor.this.getTreeMaker();
                    make.pos = tree.pos;
                    JCTree.JCMethodInvocation apply = make.Apply(List.nil(), make.Select(thisSub, sym), tree.args);
                    apply.type = tree.type;
                    this.result = apply;
                }
            }
        }

        private JCTree.JCExpression replaceThis(JCTree.JCExpression tree, JCTree.JCClassDecl receiverType, Type contextType) {
            Symbol.ClassSymbol runtimeMethodsClassSym = DelegationProcessor.this.getRtClassSym(RuntimeMethods.class);
            Names names = DelegationProcessor.this.getNames();
            Symtab symtab = DelegationProcessor.this.getSymtab();
            Symbol.MethodSymbol replaceThisMethod = DelegationProcessor.resolveMethod(DelegationProcessor.this.getContext(), DelegationProcessor.this.getCompilationUnit(), tree.pos(), names.fromString("replaceThis"), runtimeMethodsClassSym.type, List.from(new Type[]{symtab.classType, symtab.objectType, symtab.objectType}));
            TreeMaker make = DelegationProcessor.this.getTreeMaker();
            JCTree.JCIdent selfIdent = make.Ident(DelegationProcessor.this.resolveField(tree.pos(), DelegationProcessor.this.getContext(), names.fromString("$theSelf"), receiverType.sym.type, receiverType));
            JCTree.JCExpression thisExpr = make.QualThis(receiverType.sym.type);
            JCTree.JCMethodInvocation replaceThisCall = make.Apply(List.nil(), DelegationProcessor.this.memberAccess(make, RuntimeMethods.class.getTypeName() + ".replaceThis"), List.of(make.ClassLiteral(DelegationProcessor.this.getTypes().erasure(contextType)), selfIdent, thisExpr));
            replaceThisCall.setPos(tree.pos);
            replaceThisCall.type = symtab.objectType;
            JCTree.JCFieldAccess methodSelect = (JCTree.JCFieldAccess)replaceThisCall.getMethodSelect();
            methodSelect.sym = replaceThisMethod;
            methodSelect.type = replaceThisMethod.type;
            methodSelect.pos = tree.pos;
            this.assignTypes(methodSelect.selected, runtimeMethodsClassSym);
            methodSelect.selected.pos = tree.pos;
            JCTree.JCTypeCast castExpr = make.TypeCast(contextType, (JCTree.JCExpression)replaceThisCall);
            return castExpr;
        }

        private JCTree.JCClassDecl findClassDecl(Type type) {
            for (int i = DelegationProcessor.this._classDeclStack.size() - 1; i >= 0; --i) {
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)DelegationProcessor.this._classDeclStack.get(i);
                Types types = DelegationProcessor.this.getTypes();
                if (!DelegationProcessor.isPartClass(classDecl.sym) || !types.isSameType(types.erasure(classDecl.sym.type), types.erasure(type))) continue;
                return classDecl;
            }
            return null;
        }

        private Pair<JCTree.JCClassDecl, Type> findInterfaceOfEnclosingTypeThatSymImplements(Symbol.MethodSymbol sym) {
            for (int i = DelegationProcessor.this._classDeclStack.size() - 1; i >= 0; --i) {
                JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)DelegationProcessor.this._classDeclStack.get(i);
                if (!DelegationProcessor.isPartClass(classDecl.sym)) continue;
                ArrayList interfaces = new ArrayList();
                DelegationProcessor.this.findAllInterfaces(classDecl.sym.type, new HashSet(), interfaces);
                for (Type.ClassType iface : interfaces) {
                    for (Symbol mm : IDynamicJdk.instance().getMembersByName((Symbol.ClassSymbol)iface.tsym, sym.name)) {
                        if (!sym.overrides(mm, iface.tsym, DelegationProcessor.this.getTypes(), false)) continue;
                        return new Pair<JCTree.JCClassDecl, Type>(classDecl, iface);
                    }
                }
            }
            return null;
        }

        private boolean isException_Arg(JCTree.JCMethodInvocation tree) {
            if (tree.meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree.meth).selected instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)((JCTree.JCFieldAccess)tree.meth).selected;
                if (fa.type instanceof Type.ClassType && fa.type.tsym.getQualifiedName().toString().equals(RuntimeMethods.class.getTypeName())) {
                    return true;
                }
            }
            return false;
        }

        private void replaceSuperDefaultMethodCall(JCTree.JCMethodInvocation superInterfaceCall, boolean exec) {
            if (!exec && DelegationProcessor.this.getParent(superInterfaceCall) instanceof JCTree.JCExpressionStatement) {
                return;
            }
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)DelegationProcessor.this._classDeclStack.peek();
            if (!DelegationProcessor.isInPartClass(classDecl.sym)) {
                return;
            }
            JCTree.JCFieldAccess tree = this.findSuperInterfaceSelect(superInterfaceCall);
            if (tree == null) {
                return;
            }
            JCTree.JCFieldAccess meth = (JCTree.JCFieldAccess)superInterfaceCall.meth;
            Type iface = meth.selected.type;
            if (iface.isErroneous()) {
                return;
            }
            NamedMethodType namedMt = new NamedMethodType((Symbol.MethodSymbol)meth.sym, meth.type);
            Type csr = namedMt.getType();
            while (csr instanceof Type.DelegatedType) {
                csr = ((Type.DelegatedType)csr).qtype;
            }
            Type.MethodType mt = (Type.MethodType)csr;
            TreeMaker make = DelegationProcessor.this.getTreeMaker();
            make.pos = superInterfaceCall.pos;
            Names names = DelegationProcessor.this.getNames();
            Symtab symtab = DelegationProcessor.this.getSymtab();
            Symbol.ClassSymbol runtimeMethodsClassSym = DelegationProcessor.this.getRtClassSym(RuntimeMethods.class);
            Symbol.MethodSymbol linksInterfaceToMethod = DelegationProcessor.resolveMethod(DelegationProcessor.this.getContext(), DelegationProcessor.this.getCompilationUnit(), superInterfaceCall, DelegationProcessor.this.getNames().fromString("linksInterfaceTo"), runtimeMethodsClassSym.type, List.of(symtab.classType, symtab.objectType, symtab.objectType));
            JCTree.JCIdent selfIdent = make.Ident(DelegationProcessor.this.resolveField(tree.pos(), DelegationProcessor.this.getContext(), names.fromString("$theSelf"), classDecl.sym.type, classDecl));
            Types types = DelegationProcessor.this.getTypes();
            JCTree.JCMethodInvocation linksInterfaceToCall = make.Apply(List.nil(), DelegationProcessor.this.memberAccess(make, RuntimeMethods.class.getTypeName() + ".linksInterfaceTo"), List.of(make.ClassLiteral(types.erasure(iface)), selfIdent, make.This(classDecl.sym.type)));
            linksInterfaceToCall.type = symtab.booleanType;
            JCTree.JCFieldAccess methodSelect = (JCTree.JCFieldAccess)linksInterfaceToCall.getMethodSelect();
            methodSelect.sym = linksInterfaceToMethod;
            methodSelect.type = linksInterfaceToMethod.type;
            this.assignTypes(methodSelect.selected, runtimeMethodsClassSym);
            java.util.List parameterTypes = mt.getParameterTypes();
            ArrayList paramTs = parameterTypes.stream().map(t -> make.ClassLiteral(types.erasure((Type)t))).collect(Collectors.toCollection(() -> new ArrayList()));
            JCTree.JCNewArray paramTypesArray = make.NewArray(make.Type(types.erasure(symtab.classType)), List.nil(), List.from(paramTs));
            paramTypesArray.type = new Type.ArrayType(symtab.classType, symtab.arrayClass);
            JCTree.JCNewArray argsArray = make.NewArray(make.Type(symtab.objectType), List.nil(), List.from(superInterfaceCall.args));
            argsArray.type = new Type.ArrayType(symtab.objectType, symtab.arrayClass);
            List<JCTree.JCExpression> theArgs = List.of(selfIdent, make.ClassLiteral(types.erasure(iface)), make.Literal(namedMt.getName().toString()), new JCTree.JCExpression[]{paramTypesArray, argsArray});
            Symbol.MethodSymbol invokeDefaultMethod = DelegationProcessor.resolveMethod(DelegationProcessor.this.getContext(), DelegationProcessor.this.getCompilationUnit(), superInterfaceCall, DelegationProcessor.this.getNames().fromString("invokeDefault"), runtimeMethodsClassSym.type, List.of(symtab.objectType, symtab.classType, symtab.stringType, new Type[]{symtab.objectType, symtab.objectType}));
            JCTree.JCMethodInvocation invokeDefaultCall = make.Apply(List.nil(), DelegationProcessor.this.memberAccess(make, RuntimeMethods.class.getTypeName() + ".invokeDefault"), theArgs);
            invokeDefaultCall.type = symtab.booleanType;
            JCTree.JCFieldAccess mselect = (JCTree.JCFieldAccess)invokeDefaultCall.getMethodSelect();
            mselect.sym = invokeDefaultMethod;
            mselect.type = invokeDefaultMethod.type;
            this.assignTypes(mselect.selected, runtimeMethodsClassSym);
            if (exec) {
                this.result = make.If(linksInterfaceToCall, make.Exec(invokeDefaultCall), make.Exec(superInterfaceCall));
            } else {
                JCTree.JCTypeCast castInvokeDefaultCall = make.TypeCast(mt.getReturnType(), (JCTree.JCExpression)invokeDefaultCall);
                JCTree.JCConditional conditional = make.Conditional(linksInterfaceToCall, castInvokeDefaultCall, superInterfaceCall);
                conditional.type = mt.getReturnType();
                this.result = conditional;
            }
        }

        private JCTree.JCFieldAccess findSuperInterfaceSelect(JCTree.JCMethodInvocation methodCall) {
            JCTree.JCExpression csr = methodCall.meth;
            while (csr instanceof JCTree.JCFieldAccess) {
                if (csr.toString().endsWith(".super")) {
                    return (JCTree.JCFieldAccess)csr;
                }
                csr = ((JCTree.JCFieldAccess)csr).selected;
            }
            return null;
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            super.visitAssign(tree);
            Symbol linkField = this.getLinkFieldRef(tree.lhs);
            if (linkField != null) {
                tree.rhs = this.assignSelf(linkField, tree.rhs, tree);
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            Symbol linkField;
            super.visitVarDef(tree);
            if (tree.init != null && (linkField = this.getLinkFieldRef(tree)) != null) {
                tree.init = this.assignSelf(linkField, tree.init, tree);
            }
        }

        private JCTree.JCExpression assignSelf(Symbol linkField, JCTree.JCExpression rhs, JCTree assignmentOrVarDecl) {
            Symbol.ClassSymbol runtimeMethodsClassSym = DelegationProcessor.this.getRtClassSym(RuntimeMethods.class);
            Names names = DelegationProcessor.this.getNames();
            Symtab symtab = DelegationProcessor.this.getSymtab();
            Symbol.MethodSymbol assignPartMethod = DelegationProcessor.resolveMethod(DelegationProcessor.this.getContext(), DelegationProcessor.this.getCompilationUnit(), assignmentOrVarDecl.pos(), names.fromString("linkPart"), runtimeMethodsClassSym.type, List.from(new Type[]{symtab.objectType, symtab.stringType, symtab.objectType}));
            TreeMaker make = DelegationProcessor.this.getTreeMaker();
            JCTree.JCMethodInvocation assignPartCall = make.Apply(List.nil(), DelegationProcessor.this.memberAccess(make, RuntimeMethods.class.getTypeName() + ".linkPart"), List.of(make.This(((JCTree.JCClassDecl)((DelegationProcessor)DelegationProcessor.this)._classDeclStack.peek()).type), make.Literal(linkField.name.toString()), rhs));
            assignPartCall.setPos(assignmentOrVarDecl.pos);
            assignPartCall.type = symtab.objectType;
            JCTree.JCFieldAccess methodSelect = (JCTree.JCFieldAccess)assignPartCall.getMethodSelect();
            methodSelect.sym = assignPartMethod;
            methodSelect.type = assignPartMethod.type;
            methodSelect.pos = assignmentOrVarDecl.pos;
            this.assignTypes(methodSelect.selected, runtimeMethodsClassSym);
            methodSelect.selected.pos = assignmentOrVarDecl.pos;
            JCTree.JCTypeCast castExpr = make.TypeCast(linkField.type, (JCTree.JCExpression)assignPartCall);
            return castExpr;
        }

        private void assignTypes(JCTree.JCExpression m, Symbol symbol) {
            if (m instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)m;
                fieldAccess.sym = symbol;
                fieldAccess.type = symbol.type;
                this.assignTypes(fieldAccess.selected, symbol.owner);
            } else if (m instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)m;
                ident.sym = symbol;
                ident.type = symbol.type;
            }
        }

        private Symbol getLinkFieldRef(JCTree.JCExpression lhs) {
            if (lhs instanceof JCTree.JCIdent && ((JCTree.JCIdent)lhs).sym.getAnnotation(link.class) != null) {
                return ((JCTree.JCIdent)lhs).sym;
            }
            if (lhs instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)lhs).sym.getAnnotation(link.class) != null) {
                return ((JCTree.JCFieldAccess)lhs).sym;
            }
            if (lhs instanceof JCTree.JCParens) {
                return this.getLinkFieldRef(((JCTree.JCParens)lhs).expr);
            }
            return null;
        }

        private Symbol getLinkFieldRef(JCTree.JCVariableDecl tree) {
            if (tree.sym.getAnnotation(link.class) != null) {
                return tree.sym;
            }
            return null;
        }
    }

    private class Analyze_Start
    extends TreeTranslator {
        private Analyze_Start() {
        }

        @Override
        public void visitParens(JCTree.JCParens tree) {
            super.visitParens(tree);
            if (tree.expr instanceof JCTree.JCIdent && tree.expr.toString().equals("this") || tree.expr instanceof JCTree.JCFieldAccess && tree.expr.toString().endsWith(".this")) {
                this.result = tree.expr;
            }
        }
    }

    private class Enter_Finish
    extends TreeTranslator {
        private Enter_Finish() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl classDecl) {
            DelegationProcessor.this._classInfoStack.push(new ClassInfo(classDecl));
            try {
                if (classDecl.sym == null) {
                    super.visitClassDef(classDecl);
                    return;
                }
                this.processPartClass(classDecl);
                super.visitClassDef(classDecl);
                ClassInfo classInfo = (ClassInfo)DelegationProcessor.this._classInfoStack.peek();
                if (classInfo.hasLinks()) {
                    this.processInterfaceOverlap(classInfo);
                    this.processMethodOverlap(classInfo);
                    for (LinkInfo li : classInfo.getLinks().values()) {
                        this.linkInterfaces(li);
                        ArrayList<JCTree> newDefs = new ArrayList<JCTree>(classDecl.defs);
                        newDefs.addAll(li.getGeneratedMethods());
                        classDecl.defs = List.from(newDefs);
                        for (JCTree.JCMethodDecl methDecl : li.getGeneratedMethods()) {
                            ReflectUtil.method(MemberEnter.instance(DelegationProcessor.this.getContext()), "memberEnter", JCTree.class, Env.class).invoke(methDecl, Enter.instance(DelegationProcessor.this.getContext()).getClassEnv(classDecl.sym));
                        }
                    }
                }
            }
            finally {
                DelegationProcessor.this._classInfoStack.pop();
            }
        }

        private void overrideDefaultInterfaceMethods(JCTree.JCClassDecl classDecl) {
            for (JCTree.JCExpression expr : classDecl.implementing) {
                Type exprType = expr.type;
                if (exprType.isErroneous() || !exprType.isInterface()) continue;
                Type iface = exprType;
                ArrayList<Symbol.MethodSymbol> defaultMethods = new ArrayList<Symbol.MethodSymbol>();
                this.findDefaultMethodsToForward(classDecl, iface, new HashSet<Type>(), defaultMethods);
                HashSet<NamedMethodType> seen = new HashSet<NamedMethodType>();
                for (Symbol.MethodSymbol m : defaultMethods) {
                    Type type;
                    if (this.isExtensionMethod(m) || !((type = DelegationProcessor.this.getTypes().memberType(iface, m)) instanceof Type.MethodType)) continue;
                    NamedMethodType namedMt = new NamedMethodType(m, type);
                    if (!seen.contains(namedMt)) {
                        ClassInfo ci = (ClassInfo)DelegationProcessor.this._classInfoStack.peek();
                        ci.addDefaultMethodForwarder(namedMt);
                        this.generateDefaultMethodForwarder(classDecl, (Type.ClassType)iface, namedMt);
                    }
                    seen.add(namedMt);
                }
            }
        }

        private void findDefaultMethodsToForward(JCTree.JCClassDecl classDecl, Type iface, Set<Type> seen, ArrayList<Symbol.MethodSymbol> result) {
            if (seen.stream().anyMatch(t -> DelegationProcessor.this.getTypes().isSameType((Type)t, iface))) {
                return;
            }
            seen.add(iface);
            Symbol.TypeSymbol classSym = iface.tsym;
            if (!(classSym instanceof Symbol.ClassSymbol)) {
                return;
            }
            Iterable<Symbol> defaultMethods = IDynamicJdk.instance().getMembers((Symbol.ClassSymbol)classSym, m -> m instanceof Symbol.MethodSymbol && ((Symbol.MethodSymbol)m).isDefault() && (m.flags() & 0x1000L) == 0L);
            defaultMethods.forEach(m -> {
                Symbol.MethodSymbol implSym = ((Symbol.MethodSymbol)m).implementation(classDecl.sym, DelegationProcessor.this.getTypes(), false);
                if (implSym == null) {
                    result.add((Symbol.MethodSymbol)m);
                }
            });
            ((Symbol.ClassSymbol)iface.tsym).getInterfaces().forEach(t -> this.findDefaultMethodsToForward(classDecl, (Type)t, seen, result));
        }

        private void generateDefaultMethodForwarder(JCTree.JCClassDecl classDecl, Type.ClassType iface, NamedMethodType namedMt) {
            List<JCTree.JCTypeParameter> typeParams;
            Type csr = namedMt.getType();
            while (csr instanceof Type.DelegatedType) {
                csr = ((Type.DelegatedType)csr).qtype;
            }
            Type.MethodType mt = (Type.MethodType)csr;
            TreeMaker make = DelegationProcessor.this.getTreeMaker();
            make.pos = classDecl.pos;
            JCTree.JCModifiers access = make.Modifiers(1L);
            Names names = DelegationProcessor.this.getNames();
            Name name = namedMt.getName();
            List<JCTree.JCExpression> thrown = make.Types((List<Type>)mt.getThrownTypes());
            if (namedMt.getType() instanceof Type.ForAll) {
                typeParams = make.TypeParams(namedMt.getType().getTypeArguments());
            } else {
                List<Type> typeParamTypes = List.from(namedMt.getMethodSymbol().getTypeParameters().stream().map(tp -> tp.type).collect(Collectors.toList()));
                typeParams = make.TypeParams(typeParamTypes);
            }
            java.util.List parameterTypes = mt.getParameterTypes();
            ArrayList<JCTree.JCVariableDecl> params = new ArrayList<JCTree.JCVariableDecl>();
            for (int i = 0; i < ((List)parameterTypes).size(); ++i) {
                Type pt = (Type)((List)parameterTypes).get(i);
                Name paramName = names.fromString("$param" + i);
                JCTree.JCExpression paramType = make.Type(pt);
                JCTree.JCVariableDecl param = make.VarDef(make.Modifiers(0x200000010L), paramName, paramType, null);
                params.add(param);
            }
            JCTree.JCExpression resType = make.Type(mt.getReturnType());
            Symtab symtab = DelegationProcessor.this.getSymtab();
            Types types = DelegationProcessor.this.getTypes();
            JCTree.JCMethodInvocation linksInterfaceToCall = make.Apply(List.nil(), DelegationProcessor.this.memberAccess(make, RuntimeMethods.class.getTypeName() + ".linksInterfaceTo"), List.of(make.ClassLiteral(types.erasure(iface)), make.Ident(names.fromString("$theSelf")), make.This(classDecl.sym.type)));
            ArrayList paramTs = parameterTypes.stream().map(t -> make.ClassLiteral(types.erasure((Type)t))).collect(Collectors.toCollection(() -> new ArrayList()));
            JCTree.JCNewArray paramTypesArray = make.NewArray(make.Type(types.erasure(symtab.classType)), List.nil(), List.from(paramTs));
            ArrayList argIdents = params.stream().map(p -> make.Ident(p.name)).collect(Collectors.toCollection(() -> new ArrayList()));
            JCTree.JCNewArray argsArray = make.NewArray(make.Type(symtab.objectType), List.nil(), List.from(argIdents));
            List<JCTree.JCExpression> theArgs = List.of(make.Ident(names.fromString("$theSelf")), make.ClassLiteral(types.erasure(iface)), make.Literal(namedMt.getName().toString()), new JCTree.JCExpression[]{paramTypesArray, argsArray});
            JCTree.JCMethodInvocation linkPartCall = make.Apply(List.nil(), DelegationProcessor.this.memberAccess(make, RuntimeMethods.class.getTypeName() + ".invokeDefault"), theArgs);
            JCTree.JCStatement invokeDefaultAsSelfStmt = types.isSameType(mt.getReturnType(), DelegationProcessor.this.getSymtab().voidType) ? make.Exec(linkPartCall) : make.Return(make.TypeCast(mt.getReturnType(), (JCTree.JCExpression)linkPartCall));
            JCTree.JCFieldAccess forwardRef = (JCTree.JCFieldAccess)make.Select(make.Select(make.Type(iface), names._super), namedMt.getMethodSymbol());
            forwardRef.type = mt.getReturnType();
            java.util.List args = params.stream().map(p -> make.Ident(p.name)).collect(Collectors.toList());
            JCTree.JCMethodInvocation forwardCall = make.Apply(List.nil(), forwardRef, List.from(args));
            forwardCall.type = forwardRef.type;
            ((JCTree.JCFieldAccess)forwardCall.meth).sym = namedMt.getMethodSymbol();
            JCTree.JCStatement invokeSuperStmt = types.isSameType(mt.getReturnType(), DelegationProcessor.this.getSymtab().voidType) ? make.Exec(forwardCall) : make.Return(forwardCall);
            JCTree.JCIf ifStmt = make.If(linksInterfaceToCall, invokeDefaultAsSelfStmt, invokeSuperStmt);
            JCTree.JCBlock block = make.Block(0L, List.of(ifStmt));
            JCTree.JCMethodDecl defaultMethodForwarder = make.MethodDef(access, name, resType, typeParams, List.from(params), thrown, block, null);
            ArrayList<JCTree> newDefs = new ArrayList<JCTree>(classDecl.defs);
            newDefs.add(defaultMethodForwarder);
            classDecl.defs = List.from(newDefs);
            ReflectUtil.method(MemberEnter.instance(DelegationProcessor.this.getContext()), "memberEnter", JCTree.class, Env.class).invoke(defaultMethodForwarder, Enter.instance(DelegationProcessor.this.getContext()).getClassEnv(classDecl.sym));
        }

        private void processPartClass(JCTree.JCClassDecl classDecl) {
            if (!DelegationProcessor.isPartClass(classDecl.sym)) {
                return;
            }
            this.checkSuperclass(classDecl);
            if (DelegationProcessor.getAnnotationMirror(classDecl.sym, enter_finish.class) != null) {
                return;
            }
            DelegationProcessor.this.addAnnotation(classDecl.sym, enter_finish.class);
            this.addSelfField(classDecl);
            this.addCoveredField(classDecl);
            this.overrideDefaultInterfaceMethods(classDecl);
        }

        private void checkSuperclass(JCTree.JCClassDecl classDecl) {
            Type superclass = classDecl.sym.getSuperclass();
            if (classDecl.getExtendsClause() != null && superclass != null && DelegationProcessor.getAnnotationMirror(superclass.tsym, part.class) == null) {
                DelegationProcessor.this.reportError(classDecl.getExtendsClause(), DelegationIssueMsg.MSG_SUPERCLASS_NOT_PART.get(new Object[0]));
            }
        }

        private void addSelfField(JCTree.JCClassDecl classDecl) {
            this.addWiringField(classDecl, "$theSelf", DelegationProcessor.this.getSymtab().objectType);
        }

        private void addCoveredField(JCTree.JCClassDecl classDecl) {
            this.addWiringField(classDecl, "$interfacesFullyCovered", DelegationProcessor.this.getSymtab().booleanType);
        }

        private void addWiringField(JCTree.JCClassDecl classDecl, String fieldName, Type fieldType) {
            TreeMaker make = DelegationProcessor.this.getTreeMaker();
            make.pos = classDecl.pos;
            JCTree.JCModifiers access = make.Modifiers(2L);
            Names names = DelegationProcessor.this.getNames();
            Name name = names.fromString(fieldName);
            JCTree.JCExpression type = make.Type(fieldType);
            JCTree.JCVariableDecl fieldDecl = make.VarDef(access, name, type, null);
            ArrayList<JCTree> newDefs = new ArrayList<JCTree>(classDecl.defs);
            newDefs.add(fieldDecl);
            classDecl.defs = List.from(newDefs);
            ReflectUtil.method(MemberEnter.instance(DelegationProcessor.this.getContext()), "memberEnter", JCTree.class, Env.class).invoke(fieldDecl, Enter.instance(DelegationProcessor.this.getContext()).getClassEnv(classDecl.sym));
        }

        private void processMethodOverlap(ClassInfo classInfo) {
            for (Map.Entry<JCTree.JCVariableDecl, LinkInfo> entry : classInfo.getLinks().entrySet()) {
                LinkInfo linkInfo = entry.getValue();
                for (Type.ClassType iface : linkInfo.getInterfaces()) {
                    Iterable<Symbol> methods = IDynamicJdk.instance().getMembers((Symbol.ClassSymbol)iface.tsym, m -> m instanceof Symbol.MethodSymbol && !m.isStatic() && !m.isPrivate() && (m.flags() & 0x1000L) == 0L);
                    for (Symbol m2 : methods) {
                        this.processMethods(classInfo._classDecl, linkInfo, (Symbol.MethodSymbol)m2);
                    }
                }
            }
            HashMap mtToDi = new HashMap();
            for (Map.Entry<JCTree.JCVariableDecl, LinkInfo> entry : classInfo.getLinks().entrySet()) {
                LinkInfo li3 = entry.getValue();
                li3.getMethodTypes().values().forEach(mtSet -> mtSet.forEach(mt -> mtToDi.computeIfAbsent(mt, k -> new HashSet()).add(li3)));
            }
            for (Map.Entry<JCTree.JCVariableDecl, LinkInfo> entry : mtToDi.entrySet()) {
                NamedMethodType mt = (NamedMethodType)((Object)entry.getKey());
                Set lis = (Set)((Object)entry.getValue());
                if (lis.size() <= 1) continue;
                StringBuilder fieldNames = new StringBuilder();
                lis.forEach(li -> fieldNames.append(fieldNames.length() > 0 ? ", " : "").append(((LinkInfo)li)._linkField.name));
                for (LinkInfo li4 : lis) {
                    DelegationProcessor.this.reportWarning(li4.getLinkField(), DelegationIssueMsg.MSG_METHOD_OVERLAP.get(mt.getName(), fieldNames));
                    li4.getMethodTypes().get(mt.getName()).remove(mt);
                }
            }
        }

        private void processMethods(JCTree.JCClassDecl classDecl, LinkInfo li, Symbol.MethodSymbol m) {
            Type emt;
            Symbol.MethodSymbol existingMethod = m.implementation(classDecl.sym, DelegationProcessor.this.getTypes(), false);
            if (existingMethod != null && !DelegationProcessor.this.getTypes().isSameType(DelegationProcessor.this.getSymtab().objectType, existingMethod.owner.type)) {
                return;
            }
            if (this.isExtensionMethod(m)) {
                return;
            }
            LinkInfo linkInfo = ((ClassInfo)DelegationProcessor.this._classInfoStack.peek()).getLinks().get(li._linkField);
            Type csr = emt = DelegationProcessor.this.getTypes().memberType(classDecl.sym.type, m);
            while (csr instanceof Type.DelegatedType) {
                csr = ((Type.DelegatedType)csr).qtype;
            }
            if (linkInfo.hasMethodType(m.name, emt)) {
                return;
            }
            linkInfo.addMethodType(m, emt);
        }

        private boolean isExtensionMethod(Symbol sym) {
            if (sym instanceof Symbol.MethodSymbol) {
                for (Attribute.Compound annotation : sym.getAnnotationMirrors()) {
                    if (!annotation.type.toString().equals(ExtensionMethod.class.getName())) continue;
                    return true;
                }
            }
            return false;
        }

        private void processInterfaceOverlap(ClassInfo ci) {
            HashMap<Type.ClassType, Set> interfaceToLinks = new HashMap<Type.ClassType, Set>();
            for (Map.Entry<JCTree.JCVariableDecl, LinkInfo> entry : ci.getLinks().entrySet()) {
                LinkInfo li2 = entry.getValue();
                for (Type.ClassType iface : ci.getInterfaces()) {
                    if (!li2.getInterfaces().stream().anyMatch(e -> DelegationProcessor.this.getTypes().isSameType((Type)e, iface))) continue;
                    Set lis = interfaceToLinks.computeIfAbsent(iface, k -> new HashSet());
                    lis.add(li2);
                }
            }
            for (Map.Entry<JCTree.JCVariableDecl, LinkInfo> entry : interfaceToLinks.entrySet()) {
                Type.ClassType iface = (Type.ClassType)((Object)entry.getKey());
                Set lis = (Set)((Object)entry.getValue());
                if (lis.size() <= 1) continue;
                boolean isInterfaceShared = this.checkSharedLinks(iface, lis);
                StringBuilder fieldNames = new StringBuilder();
                lis.forEach(li -> fieldNames.append(fieldNames.length() > 0 ? ", " : "").append(((LinkInfo)li)._linkField.name));
                for (LinkInfo li3 : lis) {
                    if (li3.isShare()) continue;
                    if (!isInterfaceShared) {
                        DelegationProcessor.this.reportWarning(li3.getLinkField(), DelegationIssueMsg.MSG_INTERFACE_OVERLAP.get(iface.tsym.getSimpleName(), fieldNames));
                    }
                    li3.getInterfaces().remove(iface);
                }
            }
        }

        private boolean checkSharedLinks(Type.ClassType iface, Set<LinkInfo> lis) {
            ArrayList sharedLinks = lis.stream().filter(li -> li.isShare()).collect(Collectors.toCollection(() -> new ArrayList()));
            if (sharedLinks.size() > 1) {
                StringBuilder fieldNames = new StringBuilder();
                sharedLinks.forEach(li -> fieldNames.append(fieldNames.length() > 0 ? ", " : "").append(((LinkInfo)li)._linkField.name));
                sharedLinks.forEach(li -> DelegationProcessor.this.reportError(li.getLinkField(), DelegationIssueMsg.MSG_MULTIPLE_SHARING.get(iface.tsym.getSimpleName(), fieldNames)));
            }
            return !sharedLinks.isEmpty();
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            super.visitVarDef(tree);
            if (((ClassInfo)((ClassInfo)((DelegationProcessor)DelegationProcessor.this)._classInfoStack.peek()))._classDecl.sym == null) {
                return;
            }
            this.processLinkField(tree);
        }

        private void processLinkField(JCTree.JCVariableDecl varDecl) {
            int modifiers = (int)varDecl.getModifiers().flags;
            ClassInfo classInfo = (ClassInfo)DelegationProcessor.this._classInfoStack.peek();
            JCTree.JCClassDecl classDecl = classInfo._classDecl;
            if (classDecl.defs.contains(varDecl)) {
                JCTree.JCAnnotation linkAnno = Util.getAnnotation(varDecl, link.class);
                if (linkAnno == null) {
                    return;
                }
                if (varDecl.sym.isStatic()) {
                    DelegationProcessor.this.reportError(varDecl, DelegationIssueMsg.MSG_LINK_STATIC_FIELD.get(new Object[0]));
                    return;
                }
                if (DelegationProcessor.getAnnotationMirror(varDecl.sym, enter_finish.class) != null) {
                    return;
                }
                DelegationProcessor.this.addAnnotation(varDecl.sym, enter_finish.class);
                this.checkModifiersAndApplyDefaults(varDecl, modifiers, classDecl);
                this.addLinkedInterfaces(linkAnno, classInfo, varDecl);
            }
        }

        private void checkModifiersAndApplyDefaults(JCTree.JCVariableDecl varDecl, int modifiers, JCTree.JCClassDecl classDecl) {
            if (DelegationProcessor.getAnnotationMirror(classDecl.sym, part.class) == null) {
                return;
            }
            if ((modifiers & 5) != 0) {
                DelegationProcessor.this.reportError(varDecl.getModifiers(), DelegationIssueMsg.MSG_MODIFIER_NOT_ALLOWED_HERE.get((modifiers & 1) != 0 ? "public" : "protected"));
            }
            if ((modifiers & 2) != 0) {
                DelegationProcessor.this.reportWarning(varDecl.getModifiers(), DelegationIssueMsg.MSG_MODIFIER_REDUNDANT_FOR_LINK.get("private"));
            } else {
                JCTree.JCModifiers assignTransformLhsTemp11 = varDecl.getModifiers();
                assignTransformLhsTemp11.flags = assignTransformLhsTemp11.flags | 2L;
            }
            if ((modifiers & 0x10) != 0) {
                DelegationProcessor.this.reportWarning(varDecl.getModifiers(), DelegationIssueMsg.MSG_MODIFIER_REDUNDANT_FOR_LINK.get("final"));
            } else {
                JCTree.JCModifiers assignTransformLhsTemp22 = varDecl.getModifiers();
                assignTransformLhsTemp22.flags = assignTransformLhsTemp22.flags | 0x10L;
            }
        }

        private void addLinkedInterfaces(JCTree.JCAnnotation linkAnno, ClassInfo ci, JCTree.JCVariableDecl field) {
            ArrayList<Type.ClassType> interfaces = new ArrayList<Type.ClassType>();
            ArrayList<Type.ClassType> fromAnno = new ArrayList<Type.ClassType>();
            boolean share = this.getInterfacesFromLinkAnno(linkAnno, fromAnno);
            if (fromAnno.isEmpty()) {
                interfaces.addAll(this.getCommonInterfaces(ci, field.sym.type));
                if (interfaces.isEmpty()) {
                    DelegationProcessor.this.reportError(field.getType(), DelegationIssueMsg.MSG_NO_INTERFACES.get(field.sym.type, ((ClassInfo)ci)._classDecl.sym.type));
                }
            } else {
                for (Type.ClassType iface : fromAnno) {
                    Set<Type.ClassType> commonInterfaces = this.getCommonInterfaces(ci, iface, true);
                    interfaces.addAll(commonInterfaces);
                    if (!commonInterfaces.isEmpty()) continue;
                    DelegationProcessor.this.reportError(linkAnno, DelegationIssueMsg.MSG_NO_INTERFACES.get(iface, ((ClassInfo)ci)._classDecl.sym.type));
                }
                this.verifyFieldTypeSatisfiesAnnoTypes(field, interfaces);
            }
            this.removeDups(interfaces);
            if (share) {
                JCTree.JCModifiers assignTransformLhsTemp33 = field.getModifiers();
                assignTransformLhsTemp33.flags = assignTransformLhsTemp33.flags | 0x10L;
            }
            ci.getLinks().put(field, new LinkInfo(field, interfaces, share));
        }

        private void verifyFieldTypeSatisfiesAnnoTypes(JCTree.JCVariableDecl field, ArrayList<Type.ClassType> interfaces) {
            Types types = DelegationProcessor.this.getTypes();
            for (Type.ClassType t : interfaces) {
                if (types.isAssignable(field.sym.type, t)) continue;
                JCTree typeTree = field.getType();
                DelegationProcessor.this.reportError(typeTree == null ? field : typeTree, DelegationIssueMsg.MSG_FIELD_TYPE_NOT_ASSIGNABLE_TO.get(field.sym.type.tsym.getQualifiedName(), t.tsym.getQualifiedName()));
            }
        }

        private void removeDups(ArrayList<Type.ClassType> interfaces) {
            Types types = DelegationProcessor.this.getTypes();
            for (int i = 0; i < interfaces.size(); ++i) {
                Type.ClassType ti = interfaces.get(i);
                for (int j = i + 1; j < interfaces.size(); ++j) {
                    Type.ClassType tj = interfaces.get(j);
                    if (!types.isSameType(ti, tj)) continue;
                    interfaces.remove(j--);
                }
            }
        }

        private boolean getInterfacesFromLinkAnno(JCTree.JCAnnotation linkAnno, ArrayList<Type.ClassType> interfaces) {
            java.util.List args = linkAnno.getArguments();
            if (((List)args).isEmpty()) {
                return false;
            }
            boolean share = false;
            Attribute.Compound annoValues = linkAnno.attribute.getValue();
            int i = 0;
            for (Map.Entry<Symbol.MethodSymbol, Attribute> entry : annoValues.getElementValues().entrySet()) {
                Symbol.MethodSymbol argSym = entry.getKey();
                Attribute value = entry.getValue();
                if (argSym.name.toString().equals("share")) {
                    share = (Boolean)value.getValue();
                } else if (argSym.name.toString().equals("value")) {
                    if (value instanceof Attribute.Class) {
                        this.processClassType((Attribute.Class)value, interfaces, (JCTree.JCExpression)((List)args).get(i));
                    }
                    if (value instanceof Attribute.Array) {
                        for (Attribute cls : ((Attribute.Array)value).values) {
                            this.processClassType((Attribute.Class)cls, interfaces, (JCTree.JCExpression)((List)args).get(i));
                        }
                    }
                } else {
                    throw new IllegalStateException();
                }
                ++i;
            }
            return share;
        }

        private void processClassType(Attribute.Class value, ArrayList<Type.ClassType> interfaces, JCTree.JCExpression location) {
            Type.ClassType classType = (Type.ClassType)value.classType;
            if (classType.isInterface()) {
                interfaces.add(classType);
            } else {
                DelegationProcessor.this.reportError(location, DelegationIssueMsg.MSG_ONLY_INTERFACES_HERE.get(new Object[0]));
            }
        }

        private Set<Type.ClassType> getCommonInterfaces(ClassInfo ci, Type fieldType) {
            return this.getCommonInterfaces(ci, fieldType, false);
        }

        private Set<Type.ClassType> getCommonInterfaces(ClassInfo ci, Type fieldType, boolean erasure) {
            ArrayList linkFieldInterfaces = new ArrayList();
            DelegationProcessor.this.findAllInterfaces(fieldType, new HashSet(), linkFieldInterfaces);
            if (fieldType.isInterface() && Util.getAnnotationMirror(fieldType.tsym, Structural.class) != null) {
                return new HashSet<Type.ClassType>(linkFieldInterfaces);
            }
            Types types = DelegationProcessor.this.getTypes();
            if (erasure) {
                return ci.getInterfaces().stream().filter(i1 -> linkFieldInterfaces.stream().anyMatch(i2 -> types.isSameType(types.erasure((Type)i1), types.erasure((Type)i2)))).collect(Collectors.toSet());
            }
            return ci.getInterfaces().stream().filter(i1 -> linkFieldInterfaces.stream().anyMatch(i2 -> types.isSameType((Type)i1, (Type)i2))).collect(Collectors.toSet());
        }

        private void linkInterfaces(LinkInfo li) {
            for (Set<NamedMethodType> mtSet : li.getMethodTypes().values()) {
                for (NamedMethodType mt : mtSet) {
                    ClassInfo ci = (ClassInfo)DelegationProcessor.this._classInfoStack.peek();
                    if (ci.getDefaultMethodForwarders().contains(mt)) continue;
                    this.generateInterfaceImplMethod(li, mt);
                }
            }
        }

        private void generateInterfaceImplMethod(LinkInfo li, NamedMethodType namedMt) {
            List<JCTree.JCTypeParameter> typeParams;
            Type csr = namedMt.getType();
            while (csr instanceof Type.DelegatedType) {
                csr = ((Type.DelegatedType)csr).qtype;
            }
            Type.MethodType mt = (Type.MethodType)csr;
            TreeMaker make = DelegationProcessor.this.getTreeMaker();
            make.pos = li.getLinkField().pos;
            JCTree.JCModifiers access = make.Modifiers(1L);
            Names names = DelegationProcessor.this.getNames();
            Name name = namedMt.getName();
            List<JCTree.JCExpression> thrown = make.Types((List<Type>)mt.getThrownTypes());
            if (namedMt.getType() instanceof Type.ForAll) {
                typeParams = make.TypeParams(namedMt.getType().getTypeArguments());
            } else {
                List<Type> typeParamTypes = List.from(namedMt.getMethodSymbol().getTypeParameters().stream().map(tp -> tp.type).collect(Collectors.toList()));
                typeParams = make.TypeParams(typeParamTypes);
            }
            java.util.List parameterTypes = mt.getParameterTypes();
            ArrayList<JCTree.JCVariableDecl> params = new ArrayList<JCTree.JCVariableDecl>();
            for (int i = 0; i < ((List)parameterTypes).size(); ++i) {
                Type pt = (Type)((List)parameterTypes).get(i);
                Name paramName = names.fromString("$param" + i);
                JCTree.JCExpression paramType = make.Type(pt);
                JCTree.JCVariableDecl param = make.VarDef(make.Modifiers(0x200000010L), paramName, paramType, null);
                params.add(param);
            }
            JCTree.JCExpression resType = make.Type(mt.getReturnType());
            JCTree.JCExpression link2 = make.Ident(li.getLinkField());
            JCTree.JCFieldAccess forwardRef = (JCTree.JCFieldAccess)make.Select(link2, namedMt.getMethodSymbol());
            forwardRef.type = mt.getReturnType();
            java.util.List args = params.stream().map(p -> make.Ident(p.name)).collect(Collectors.toList());
            JCTree.JCMethodInvocation forwardCall = make.Apply(List.nil(), forwardRef, List.from(args));
            forwardCall.type = forwardRef.type;
            ((JCTree.JCFieldAccess)forwardCall.meth).sym = namedMt.getMethodSymbol();
            JCTree.JCStatement forwardStmt = DelegationProcessor.this.getTypes().isSameType(mt.getReturnType(), DelegationProcessor.this.getSymtab().voidType) ? make.Exec(forwardCall) : make.Return(forwardCall);
            JCTree.JCBlock block = make.Block(0L, List.of(forwardStmt));
            JCTree.JCMethodDecl ifaceMethod = make.MethodDef(access, name, resType, typeParams, List.from(params), thrown, block, null);
            li.addGeneratedMethod(ifaceMethod);
        }
    }
}

