/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Assert;
import graphql.language.AstPrinter;
import graphql.language.Value;
import java.util.Objects;

public class NormalizedInputValue {
    private final String typeName;
    private final Object value;

    public NormalizedInputValue(String typeName, Object value) {
        this.typeName = this.assertValidTypeName(typeName);
        this.value = value;
    }

    private String assertValidTypeName(String typeName) {
        Assert.assertValidName(this.unwrapAll(typeName));
        return typeName;
    }

    private String unwrapAll(String typeName) {
        String result = this.unwrapOne(typeName);
        while (this.isWrapped(result)) {
            result = this.unwrapOne(result);
        }
        return result;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getUnwrappedTypeName() {
        return this.unwrapAll(this.typeName);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isListLike() {
        return this.typeName.startsWith("[");
    }

    public boolean isNonNullable() {
        return this.typeName.endsWith("!");
    }

    public boolean isNullable() {
        return !this.isNonNullable();
    }

    private boolean isWrapped(String typeName) {
        return typeName.endsWith("!") || this.isListOnly(typeName);
    }

    private boolean isListOnly(String typeName) {
        if (typeName.endsWith("!")) {
            return false;
        }
        return typeName.startsWith("[") || typeName.endsWith("]");
    }

    private String unwrapOne(String typeName) {
        Assert.assertNotNull(typeName);
        Assert.assertTrue(typeName.trim().length() > 0, () -> "We have an empty type name unwrapped");
        if (typeName.endsWith("!")) {
            return typeName.substring(0, typeName.length() - 1);
        }
        if (this.isListOnly(typeName)) {
            Assert.assertTrue(typeName.startsWith("["), () -> String.format("We have a unbalanced list type string '%s'", typeName));
            Assert.assertTrue(typeName.endsWith("]"), () -> String.format("We have a unbalanced list type string '%s'", typeName));
            return typeName.substring(1, typeName.length() - 1);
        }
        return typeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NormalizedInputValue that = (NormalizedInputValue)o;
        if (this.value instanceof Value && that.value instanceof Value) {
            return Objects.equals(this.typeName, that.typeName) && Objects.equals(AstPrinter.printAst((Value)this.value), AstPrinter.printAst((Value)that.value));
        }
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.value);
    }

    public String toString() {
        return "NormalizedInputValue{typeName='" + this.typeName + '\'' + ", value=" + this.value + '}';
    }
}

