/*
 * Decompiled with CFR 0.152.
 */
package manifold.xml.rt.parser;

import java.io.InputStream;
import java.util.Stack;
import manifold.rt.api.util.Pair;
import manifold.shade.org.antlr.v4.runtime.CharStreams;
import manifold.shade.org.antlr.v4.runtime.CommonTokenStream;
import manifold.shade.org.antlr.v4.runtime.ParserRuleContext;
import manifold.shade.org.antlr.v4.runtime.Token;
import manifold.shade.org.antlr.v4.runtime.tree.ParseTreeWalker;
import manifold.shade.org.antlr.v4.runtime.tree.TerminalNode;
import manifold.xml.rt.parser.XmlAttribute;
import manifold.xml.rt.parser.XmlElement;
import manifold.xml.rt.parser.XmlRootElement;
import manifold.xml.rt.parser.XmlTerminal;
import manifold.xml.rt.parser.antlr.XMLParser;
import manifold.xml.rt.parser.antlr.XMLParserBaseListener;
import manifold.xml.rt.parser.antlr.gen.XMLLexer;

public class XmlParser {
    private XmlElement _root = null;

    public static XmlElement parse(InputStream inputStream) {
        return new XmlParser((InputStream)inputStream)._root;
    }

    public static XMLParser.DocumentContext parseRaw(InputStream inputStream) {
        try {
            XMLLexer lexer = new XMLLexer(CharStreams.fromStream(inputStream));
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            XMLParser parser = new XMLParser(tokens);
            return parser.document();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XmlParser(InputStream inputStream) {
        try {
            XMLParser.DocumentContext ctx = XmlParser.parseRaw(inputStream);
            ParseTreeWalker walker = new ParseTreeWalker();
            XmlBuilder builder = new XmlBuilder();
            walker.walk(builder, ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class XmlBuilder
    extends XMLParserBaseListener {
        private XmlElement _prolog;
        private Stack<Pair<ParserRuleContext, XmlElement>> _elements = new Stack();
        private XmlAttribute _attribute;

        private XmlBuilder() {
        }

        @Override
        public void enterProlog(XMLParser.PrologContext ctx) {
            this._prolog = new XmlElement(ctx, null);
            this._elements.push(new Pair<XMLParser.PrologContext, XmlElement>(ctx, this._prolog));
        }

        @Override
        public void exitProlog(XMLParser.PrologContext ctx) {
            this._elements.pop();
        }

        @Override
        public void enterElement(XMLParser.ElementContext ctx) {
            XmlElement xmlElement;
            XmlElement parent;
            XmlElement xmlElement2 = parent = this._elements.isEmpty() ? null : this._elements.peek().getSecond();
            if (parent == null) {
                xmlElement = new XmlRootElement(ctx, this._prolog);
                this._prolog = null;
            } else {
                xmlElement = new XmlElement(ctx, parent);
                parent.addChild(xmlElement);
            }
            this._elements.push(new Pair<XMLParser.ElementContext, XmlElement>(ctx, xmlElement));
            if (XmlParser.this._root == null) {
                XmlParser.this._root = xmlElement;
            }
        }

        @Override
        public void exitElement(XMLParser.ElementContext ctx) {
            Pair<ParserRuleContext, XmlElement> popped = this._elements.pop();
            if (popped.getFirst() != ctx) {
                throw new IllegalStateException("Unbalanced elements, expecting '" + ctx.Name(0) + "' but found '" + popped.getFirst() + "'");
            }
        }

        @Override
        public void enterAttribute(XMLParser.AttributeContext ctx) {
            if (this._attribute != null) {
                throw new IllegalStateException("Error processing attribute '" + ctx.Name().getText() + "', there is already an attribute processing: '" + this._attribute.getName().getRawText());
            }
            XmlElement parent = this._elements.peek().getSecond();
            this._attribute = new XmlAttribute(ctx, parent);
            parent.addAttribute(this._attribute);
        }

        @Override
        public void exitAttribute(XMLParser.AttributeContext ctx) {
            if (this._attribute == null) {
                throw new IllegalStateException("Expecting non-null attribute during exitAttribute()");
            }
            this._attribute = null;
        }

        @Override
        public void visitTerminal(TerminalNode node) {
            Token symbol = node.getSymbol();
            if (this._attribute != null) {
                if (symbol.getType() == 15) {
                    this._attribute.setRawValue(new XmlTerminal(symbol, this._attribute));
                }
            } else if (!(this._elements.isEmpty() || symbol.getType() != 9 && symbol.getType() != 15 && symbol.getType() != 2)) {
                XmlElement second = this._elements.peek().getSecond();
                second.setRawContent(new XmlTerminal(symbol, second));
            }
        }
    }
}

