/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.ext.rt.api.ComparableUsing;
import manifold.science.api.AbstractProductUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.DensityUnit;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.MassUnit;
import manifold.science.measures.Volume;
import manifold.science.util.CoercionConstants;
import manifold.science.util.MetricFactorConstants;
import manifold.science.util.Rational;

public final class VolumeUnit
extends AbstractProductUnit<LengthUnit, AreaUnit, Volume, VolumeUnit> {
    private static final UnitCache<VolumeUnit> CACHE = new UnitCache();
    public static final VolumeUnit BASE = VolumeUnit.get(LengthUnit.Meter, AreaUnit.get(LengthUnit.Meter));
    public static final VolumeUnit LITER = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi), MetricFactorConstants.KILO, "Litre", "L");
    public static final VolumeUnit MILLI_LITER = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi), CoercionConstants.r.postfixBind(1), "Millilitre", "mL");
    public static final VolumeUnit FLUID_OZ = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi), CoercionConstants.r.postfixBind("29.5735295625"), "Fluid Ounce", "fl oz.");
    public static final VolumeUnit GALLON = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi), CoercionConstants.r.postfixBind("3785.411784"), "Gallon", "gal.");
    public static final VolumeUnit QUART = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi), CoercionConstants.r.postfixBind("946.352946"), "Quart", "qt.");
    public static final VolumeUnit PINT = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi), CoercionConstants.r.postfixBind("473.176473"), "Pint", "pt.");
    public static final VolumeUnit CUP = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi), CoercionConstants.r.postfixBind("236.5882365"), "Cup", "c.");
    public static final VolumeUnit TABLE_SPOON = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi), CoercionConstants.r.postfixBind("14.78676478125"), "Tablespoon", "tbsp");
    public static final VolumeUnit TEA_SPOON = VolumeUnit.get(LengthUnit.Centi, AreaUnit.get(LengthUnit.Centi), CoercionConstants.r.postfixBind("4.92892159375"), "Teaspoon", "tsp");
    private final String _symbolProvided;

    public static VolumeUnit get(LengthUnit lengthUnit, AreaUnit areaUnit) {
        return VolumeUnit.get(lengthUnit, areaUnit, null, null, null);
    }

    public static VolumeUnit get(LengthUnit lengthUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        VolumeUnit unit = new VolumeUnit(lengthUnit, areaUnit, factor, name, symbol);
        return (VolumeUnit)CACHE.get(unit);
    }

    private VolumeUnit(LengthUnit lengthUnit, AreaUnit areaUnit, Rational factor, String name, String symbol) {
        super(lengthUnit, areaUnit == null || areaUnit != null && null != null && areaUnit.compareToUsing(null, ComparableUsing.Operator.EQ) ? AreaUnit.get(lengthUnit) : areaUnit, factor, name, symbol);
        this._symbolProvided = symbol;
    }

    @Override
    public Volume makeDimension(Number amount) {
        return new Volume(Rational.get(amount), this);
    }

    public AreaUnit getAreaUnit() {
        return (AreaUnit)this.getRightUnit();
    }

    public LengthUnit getLengthUnit() {
        return (LengthUnit)this.getLeftUnit();
    }

    @Override
    public String getFullName() {
        LengthUnit lengthUnit;
        LengthUnit lengthUnit2;
        return this.getAreaUnit().isSquare() && ((lengthUnit2 = this.getAreaUnit().getWidthUnit()) == (lengthUnit = this.getLengthUnit()) ? true : (lengthUnit2 == null || lengthUnit == null ? false : lengthUnit2.compareToUsing(lengthUnit, ComparableUsing.Operator.EQ))) ? this.getLengthUnit().getFullName() + "\u00b3" : this.getAreaUnit().getFullName() + "\u00d7" + this.getLengthUnit().getFullName();
    }

    @Override
    public String getFullSymbol() {
        LengthUnit lengthUnit;
        LengthUnit lengthUnit2;
        return this.getAreaUnit().isSquare() && ((lengthUnit2 = this.getAreaUnit().getWidthUnit()) == (lengthUnit = this.getLengthUnit()) ? true : (lengthUnit2 == null || lengthUnit == null ? false : lengthUnit2.compareToUsing(lengthUnit, ComparableUsing.Operator.EQ))) ? this.getLengthUnit().getFullSymbol() + "\u00b3" : this.getAreaUnit().getFullSymbol() + "\u00d7" + this.getLengthUnit().getFullSymbol();
    }

    @Override
    public String getSymbol() {
        LengthUnit lengthUnit;
        LengthUnit lengthUnit2;
        if (this._symbolProvided != null) {
            return this._symbolProvided;
        }
        return this.getAreaUnit().isSquare() && ((lengthUnit2 = this.getAreaUnit().getWidthUnit()) == (lengthUnit = this.getLengthUnit()) ? true : (lengthUnit2 == null || lengthUnit == null ? false : lengthUnit2.compareToUsing(lengthUnit, ComparableUsing.Operator.EQ))) ? this.getLengthUnit().getSymbol() + "\u00b3" : super.getSymbol();
    }

    public boolean getIsCubic() {
        LengthUnit lengthUnit;
        LengthUnit lengthUnit2;
        return this.getAreaUnit().isSquare() && ((lengthUnit2 = this.getAreaUnit().getWidthUnit()) == (lengthUnit = this.getLengthUnit()) ? true : (lengthUnit2 == null || lengthUnit == null ? false : lengthUnit2.compareToUsing(lengthUnit, ComparableUsing.Operator.EQ)));
    }

    @Override
    public LengthUnit div(AreaUnit len) {
        return this.getLengthUnit();
    }

    public MassUnit times(DensityUnit density) {
        return density.getMassUnit();
    }
}

