/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.MetricScaleUnit;
import manifold.science.measures.PotentialUnit;
import manifold.science.measures.Power;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class PowerUnit
extends AbstractQuotientUnit<EnergyUnit, TimeUnit, Power, PowerUnit> {
    private static final UnitCache<PowerUnit> CACHE = new UnitCache();
    public static PowerUnit pW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.p.postfixBind(1), "Picowatt", "pW");
    public static PowerUnit nW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.n.postfixBind(1), "Nanowatt", "nW");
    public static PowerUnit uW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.u.postfixBind(1), "Microwatt", "\u03bcW");
    public static PowerUnit mW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.m.postfixBind(1), "Milliwatt", "mW");
    public static PowerUnit W = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, CoercionConstants.r.postfixBind(1), "Watt", "W");
    public static PowerUnit kW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.k.postfixBind(1), "Kilowatt", "kW");
    public static PowerUnit MW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.M.postfixBind(1), "Megawatt", "MW");
    public static PowerUnit GW = PowerUnit.get(EnergyUnit.BASE, TimeUnit.Second, MetricScaleUnit.G.postfixBind(1), "Gigawatt", "GW");
    public static final PowerUnit BASE = W;

    public static PowerUnit get(EnergyUnit energyUnit, TimeUnit timeUnit) {
        return PowerUnit.get(energyUnit, timeUnit, null, null, null);
    }

    public static PowerUnit get(EnergyUnit energyUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        PowerUnit unit = new PowerUnit(energyUnit, timeUnit, factor, name, symbol);
        return (PowerUnit)CACHE.get(unit);
    }

    private PowerUnit(EnergyUnit energyUnit, TimeUnit timeUnit, Rational factor, String name, String symbol) {
        super(energyUnit, timeUnit, factor, name, symbol);
    }

    @Override
    public Power makeDimension(Number amount) {
        return new Power(Rational.get(amount), this);
    }

    public EnergyUnit getEnergyUnit() {
        return (EnergyUnit)this.getLeftUnit();
    }

    public TimeUnit getTimeUnit() {
        return (TimeUnit)this.getRightUnit();
    }

    public ForceUnit div(VelocityUnit v) {
        return this.getEnergyUnit().getForceUnit();
    }

    public VelocityUnit div(ForceUnit force) {
        return this.getEnergyUnit().getForceUnit().getAccUnit().getVelocityUnit();
    }

    public CurrentUnit div(PotentialUnit potential) {
        return potential.getCurrentUnit();
    }

    public PotentialUnit div(CurrentUnit current) {
        return PotentialUnit.get(this, current);
    }
}

