/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBinder<MS, B extends E, E, O> {
    protected abstract MS findBinderMethod(Node<E, O> var1, Node<E, O> var2);

    protected abstract Node<E, O> makeBinaryExpression(Node<E, O> var1, Node<E, O> var2, MS var3);

    public B bind(ArrayList<Node<E, O>> operands) {
        if (operands.isEmpty()) {
            return null;
        }
        if (operands.size() == 1) {
            return (B)operands.get(0).getExpr();
        }
        Root root = this.nextRoot(operands, 0);
        while (root != null) {
            ArrayList reduced = (ArrayList)operands.clone();
            root.replaceWithPair(reduced);
            B solution = this.bind(reduced);
            if (solution != null) {
                return solution;
            }
            root = this.nextRoot(operands, root._index + 1);
        }
        return null;
    }

    private Root nextRoot(List<Node<E, O>> operands, int startIndex) {
        Node<E, O> left = null;
        for (int i = startIndex; i < operands.size(); ++i) {
            MS binderMethod;
            Node<E, O> right = operands.get(i);
            if (left != null && (binderMethod = this.findBinderMethod(left, right)) != null) {
                return new Root(i - 1, binderMethod);
            }
            left = right;
        }
        return null;
    }

    public static class Node<E, O> {
        E _expr;
        O _operatorLeft;

        public Node(E expr) {
            this(expr, null);
        }

        public Node(E expr, O operatorLeft) {
            this._expr = expr;
            this._operatorLeft = operatorLeft;
        }

        public E getExpr() {
            return this._expr;
        }

        public O getOperatorLeft() {
            return this._operatorLeft;
        }

        public void setOperatorLeft(O value) {
            this._operatorLeft = value;
        }
    }

    private class Root {
        int _index;
        MS _binderMethod;

        Root(int index, MS binderMethod) {
            this._index = index;
            this._binderMethod = binderMethod;
        }

        private void replaceWithPair(List<Node<E, O>> operands) {
            Node left = operands.get(this._index);
            operands.remove(this._index);
            Node right = operands.get(this._index);
            Node rootExpr = AbstractBinder.this.makeBinaryExpression(left, right, this._binderMethod);
            operands.set(this._index, rootExpr);
        }
    }
}

