/*
 * Decompiled with CFR 0.152.
 */
package manifold.collections.api.range;

import java.util.Iterator;
import java.util.NoSuchElementException;
import manifold.collections.api.range.AbstractIterableRange;
import manifold.collections.api.range.Sequential;

public class SequentialRange<E extends Sequential<E, S, U>, S, U>
extends AbstractIterableRange<E, S, U, SequentialRange<E, S, U>> {
    public SequentialRange(E left, E right, S step, U unit, boolean leftClosed, boolean rightClosed, boolean reverse) {
        super(left, right, step, unit, reverse ? rightClosed : leftClosed, reverse ? leftClosed : rightClosed, reverse);
    }

    @Override
    public Iterator<E> iterateFromLeft() {
        return new SequentialIterator();
    }

    @Override
    public Iterator<E> iterateFromRight() {
        return new ReverseSequentialIterator();
    }

    @Override
    public E getFromLeft(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isLeftClosed()) {
            ++iStepIndex;
        }
        Object value = ((Sequential)this.getLeftEndpoint()).nextNthInSequence(this.getStep(), this.getUnit(), iStepIndex);
        int iComp = value.compareTo(this.getRightEndpoint());
        if (this.isRightClosed() ? iComp <= 0 : iComp < 0) {
            return value;
        }
        return null;
    }

    @Override
    public E getFromRight(int iStepIndex) {
        if (iStepIndex < 0) {
            throw new IllegalArgumentException("Step index must be >= 0: " + iStepIndex);
        }
        if (!this.isRightClosed()) {
            ++iStepIndex;
        }
        Object value = ((Sequential)this.getRightEndpoint()).previousNthInSequence(this.getStep(), this.getUnit(), iStepIndex);
        int iComp = value.compareTo(this.getLeftEndpoint());
        if (this.isLeftClosed() ? iComp >= 0 : iComp > 0) {
            return value;
        }
        return null;
    }

    private class ReverseSequentialIterator
    implements Iterator<E> {
        private E _csr;

        public ReverseSequentialIterator() {
            this._csr = (Sequential)SequentialRange.this.getRightEndpoint();
            if (!SequentialRange.this.isRightClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            if (this._csr == null) {
                return false;
            }
            int iComp = this._csr.compareTo(SequentialRange.this.getLeftEndpoint());
            return iComp > 0 || SequentialRange.this.isLeftClosed() && iComp == 0;
        }

        @Override
        public E next() {
            int iComp = this._csr.compareTo(SequentialRange.this.getLeftEndpoint());
            if (iComp < 0 || !SequentialRange.this.isLeftClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            Object ret = this._csr;
            this._csr = this._csr.previousInSequence(SequentialRange.this.getStep(), SequentialRange.this.getUnit());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SequentialIterator
    implements Iterator<E> {
        private E _csr;

        public SequentialIterator() {
            this._csr = (Sequential)SequentialRange.this.getLeftEndpoint();
            if (!SequentialRange.this.isLeftClosed() && this.hasNext()) {
                this.next();
            }
        }

        @Override
        public boolean hasNext() {
            if (this._csr == null) {
                return false;
            }
            int iComp = this._csr.compareTo(SequentialRange.this.getRightEndpoint());
            return iComp < 0 || SequentialRange.this.isRightClosed() && iComp == 0;
        }

        @Override
        public E next() {
            int iComp = this._csr.compareTo(SequentialRange.this.getRightEndpoint());
            if (iComp > 0 || !SequentialRange.this.isRightClosed() && iComp == 0) {
                throw new NoSuchElementException();
            }
            Object ret = this._csr;
            this._csr = this._csr.nextInSequence(SequentialRange.this.getStep(), SequentialRange.this.getUnit());
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

