/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.Internal;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ResultPath;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeUtil;

@Internal
public class NonNullableFieldWasNullException
extends RuntimeException {
    private final ExecutionStepInfo executionStepInfo;
    private final ResultPath path;

    public NonNullableFieldWasNullException(ExecutionStepInfo executionStepInfo, ResultPath path) {
        super(NonNullableFieldWasNullException.mkMessage(Assert.assertNotNull(executionStepInfo), Assert.assertNotNull(path)));
        this.executionStepInfo = executionStepInfo;
        this.path = path;
    }

    public NonNullableFieldWasNullException(NonNullableFieldWasNullException previousException) {
        super(NonNullableFieldWasNullException.mkMessage(Assert.assertNotNull(previousException.executionStepInfo.getParent()), Assert.assertNotNull(previousException.executionStepInfo.getParent().getPath())), previousException);
        this.executionStepInfo = previousException.executionStepInfo.getParent();
        this.path = previousException.executionStepInfo.getParent().getPath();
    }

    private static String mkMessage(ExecutionStepInfo executionStepInfo, ResultPath path) {
        GraphQLOutputType unwrappedTyped = executionStepInfo.getUnwrappedNonNullType();
        if (executionStepInfo.hasParent()) {
            GraphQLOutputType unwrappedParentType = executionStepInfo.getParent().getUnwrappedNonNullType();
            return String.format("The field at path '%s' was declared as a non null type, but the code involved in retrieving data has wrongly returned a null value.  The graphql specification requires that the parent field be set to null, or if that is non nullable that it bubble up null to its parent and so on. The non-nullable type is '%s' within parent type '%s'", path, GraphQLTypeUtil.simplePrint(unwrappedTyped), GraphQLTypeUtil.simplePrint(unwrappedParentType));
        }
        return String.format("The field at path '%s' was declared as a non null type, but the code involved in retrieving data has wrongly returned a null value.  The graphql specification requires that the parent field be set to null, or if that is non nullable that it bubble up null to its parent and so on. The non-nullable type is '%s'", path, GraphQLTypeUtil.simplePrint(unwrappedTyped));
    }

    public ExecutionStepInfo getExecutionStepInfo() {
        return this.executionStepInfo;
    }

    public ResultPath getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

