/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Area;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.Current;
import manifold.science.measures.Energy;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.MagneticFluxDensity;
import manifold.science.measures.MagneticFluxDensityUnit;
import manifold.science.measures.MagneticFluxUnit;
import manifold.science.util.Rational;

public final class MagneticFlux
extends AbstractMeasure<MagneticFluxUnit, MagneticFlux> {
    public MagneticFlux(Rational value, MagneticFluxUnit unit, MagneticFluxUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public MagneticFlux(Rational value, MagneticFluxUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public MagneticFluxUnit getBaseUnit() {
        return MagneticFluxUnit.BASE;
    }

    @Override
    public MagneticFlux make(Rational value, MagneticFluxUnit unit, MagneticFluxUnit displayUnit) {
        return new MagneticFlux(value, unit, displayUnit);
    }

    @Override
    public MagneticFlux make(Rational value, MagneticFluxUnit unit) {
        return new MagneticFlux(value, unit);
    }

    public Energy times(Current current) {
        return new Energy(this.toBaseNumber().times(current.toBaseNumber()), EnergyUnit.BASE, ((MagneticFluxUnit)this.getDisplayUnit()).getEnergyUnit());
    }

    public MagneticFluxDensity div(Area area) {
        return new MagneticFluxDensity(this.toBaseNumber().div(area.toBaseNumber()), MagneticFluxDensityUnit.BASE, MagneticFluxDensityUnit.get((MagneticFluxUnit)this.getDisplayUnit(), (AreaUnit)area.getDisplayUnit()));
    }

    public Area div(MagneticFluxDensity mf) {
        return new Area(this.toBaseNumber().div(mf.toBaseNumber()), AreaUnit.BASE, ((MagneticFluxDensityUnit)mf.getDisplayUnit()).getAreaUnit());
    }
}

