/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractPrimaryUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.Angle;
import manifold.science.measures.FrequencyUnit;
import manifold.science.measures.MetricScaleUnit;
import manifold.science.measures.TimeUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.DimensionlessConstants;
import manifold.science.util.Rational;

public final class AngleUnit
extends AbstractPrimaryUnit<Angle, AngleUnit> {
    private static final UnitCache<AngleUnit> CACHE = new UnitCache();
    public static final AngleUnit Nano = AngleUnit.get(MetricScaleUnit.n.postfixBind(1), "Nanoradian", "nrad");
    public static final AngleUnit Milli = AngleUnit.get(MetricScaleUnit.m.postfixBind(1), "Milliradian", "mrad");
    public static final AngleUnit Radian = AngleUnit.get(CoercionConstants.r.postfixBind(1), "Radian", "rad");
    public static final AngleUnit Degree = AngleUnit.get(DimensionlessConstants.pi.div(180), "Degree", "deg");
    public static final AngleUnit MOA = AngleUnit.get(DimensionlessConstants.pi.div(10800), "MinuteOfArc", "moa");
    public static final AngleUnit ArcSecond = AngleUnit.get(MetricScaleUnit.k.postfixBind(DimensionlessConstants.pi.div(648)), "ArcSecond", "arcsec");
    public static final AngleUnit MilliArcSecond = AngleUnit.get(MetricScaleUnit.M.postfixBind(DimensionlessConstants.pi.div(648)), "MilliArcSecond", "mas");
    public static final AngleUnit Turn = AngleUnit.get(DimensionlessConstants.pi.times(2), "Turn", "cyc");
    public static final AngleUnit Gradian = AngleUnit.get(DimensionlessConstants.pi.div(200), "Gradian", "grad");
    public static final AngleUnit Quadrant = AngleUnit.get(DimensionlessConstants.pi.div(2), "Quadrant", "quad");
    public static final AngleUnit BASE = Radian;

    public static AngleUnit get(Rational radians, String name, String symbol) {
        return (AngleUnit)CACHE.get(new AngleUnit(radians, name, symbol));
    }

    private AngleUnit(Rational radians, String name, String symbol) {
        super(radians, name, symbol);
    }

    @Override
    public Angle makeDimension(Number amount) {
        return new Angle(Rational.get(amount), this);
    }

    public FrequencyUnit div(TimeUnit time) {
        return FrequencyUnit.get(this, time);
    }

    public TimeUnit div(FrequencyUnit freq) {
        return freq.getTimeUnit();
    }
}

