/*
 * Decompiled with CFR 0.152.
 */
package manifold.js.rt.parser;

import manifold.js.rt.parser.Parser;
import manifold.js.rt.parser.TemplateTokenizer;
import manifold.js.rt.parser.Token;
import manifold.js.rt.parser.TokenType;
import manifold.js.rt.parser.tree.Node;
import manifold.js.rt.parser.tree.template.ExpressionNode;
import manifold.js.rt.parser.tree.template.JSTNode;
import manifold.js.rt.parser.tree.template.RawStringNode;
import manifold.js.rt.parser.tree.template.StatementNode;
import manifold.js.rt.parser.tree.template.TemplateLiteralNode;

public class TemplateParser
extends Parser {
    private Node _templateNode;

    public TemplateParser(TemplateTokenizer tokenizer) {
        super(tokenizer);
        this._templateNode = tokenizer.isJST() ? new JSTNode() : new TemplateLiteralNode();
    }

    @Override
    public Node parse() {
        this.nextToken();
        while (!this.match(TokenType.EOF)) {
            if (this.match(TokenType.RAWSTRING)) {
                this._templateNode.addChild(new RawStringNode(this.currToken().getValue()));
                this.nextToken();
                continue;
            }
            if (this.matchTemplatePunc("<%@")) {
                this._templateNode.addChild(this.parseTemplateParams());
                this.nextToken();
                continue;
            }
            if (this.matchTemplatePunc("<%=") || this.matchTemplatePunc("${")) {
                this._templateNode.addChild(this.parseTemplateExpression());
                continue;
            }
            if (!this.matchTemplatePunc("<%")) continue;
            this._templateNode.addChild(this.parseTemplateStatement());
        }
        return this._templateNode;
    }

    private Node parseTemplateStatement() {
        StatementNode statementNode = new StatementNode();
        Token startToken = this.currToken();
        this.skip(this.matchTemplatePunc("<%"));
        statementNode.addChild(this.parseFillerUntil(() -> this.matchTemplatePunc("%>")));
        this.expect(this.matchTemplatePunc("%>"));
        statementNode.setTokens(startToken, this.currToken());
        this.nextToken();
        return statementNode;
    }

    private Node parseTemplateExpression() {
        ExpressionNode expressionNode = new ExpressionNode();
        Token startToken = this.currToken();
        String exitString = this.matchTemplatePunc("<%=") ? "%>" : "}";
        this.skip(this.matchTemplatePunc("<%=") || this.matchTemplatePunc("${"));
        expressionNode.addChild(this.parseFillerUntil(() -> this.matchTemplatePunc(exitString)));
        this.expect(this.matchTemplatePunc("%>"));
        expressionNode.setTokens(startToken, this.currToken());
        this.nextToken();
        return expressionNode;
    }

    private Node parseTemplateParams() {
        this.skip(this.match(TokenType.TEMPLATEPUNC));
        if (this.match(TokenType.IDENTIFIER, "params")) {
            this.nextToken();
            return this.parseParams();
        }
        if (this.match(TokenType.KEYWORD, "import")) {
            return this.parseImport();
        }
        return null;
    }

    private boolean matchTemplatePunc(String val2) {
        return this.matchIgnoreWhitespace(TokenType.TEMPLATEPUNC, val2);
    }
}

