/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Directive;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.ModuleFinder;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashSet;
import java.util.Set;
import javax.tools.JavaFileObject;
import manifold.internal.javac.GeneratedJavaStubFileObject;
import manifold.internal.javac.ManAttr;
import manifold.internal.javac.ManResolve;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public class ManClassFinder_11
extends ClassFinder {
    private final Context _ctx;
    private final ModuleFinder _moduleFinder;
    private final Symtab _symtab;

    public static ManClassFinder_11 instance(Context ctx) {
        ClassFinder finder = (ClassFinder)ctx.get(classFinderKey);
        if (!(finder instanceof ManClassFinder_11)) {
            ctx.put(classFinderKey, (ClassFinder)null);
            finder = new ManClassFinder_11(ctx);
        }
        return (ManClassFinder_11)finder;
    }

    private ManClassFinder_11(Context context) {
        super(context);
        this._ctx = context;
        this._symtab = Symtab.instance(this._ctx);
        this._moduleFinder = ModuleFinder.instance(this._ctx);
        JavaCompiler compiler = JavaCompiler.instance(context);
        ReflectUtil.field(compiler, "finder").set(this);
        this.sourceCompleter = (Symbol.Completer)ReflectUtil.field(compiler, "sourceCompleter").get();
        ReflectUtil.field(Symtab.instance(context), "initialCompleter").set(this.getCompleter());
        ReflectUtil.field(ManResolve.instance(context), "finder").set(this);
    }

    @Override
    public Symbol.ClassSymbol loadClass(Symbol.ModuleSymbol msym, Name flatname) throws Symbol.CompletionFailure {
        try {
            Symbol.ClassSymbol extClassSym;
            Symbol.ClassSymbol classSymbol = super.loadClass(msym, flatname);
            if (classSymbol.kind == Kinds.Kind.ERR && (extClassSym = this.loadWhileInExtensionClass(msym, flatname)) != null) {
                return extClassSym;
            }
            return classSymbol;
        }
        catch (Symbol.CompletionFailure ex) {
            Symbol.ClassSymbol extClassSym = this.loadWhileInExtensionClass(msym, flatname);
            if (extClassSym != null) {
                return extClassSym;
            }
            throw ex;
        }
    }

    private Symbol.ClassSymbol loadWhileInExtensionClass(Symbol.ModuleSymbol msym, Name flatname) {
        Attr attr = Attr.instance(this._ctx);
        Env env = (Env)ReflectUtil.field(attr, "env").get();
        if (env == null) {
            return null;
        }
        JavaFileObject sourceFile = env.toplevel.getSourceFile();
        if (!(sourceFile instanceof GeneratedJavaStubFileObject) && !this.isJailbreakOnType(attr)) {
            return null;
        }
        Modules modules = Modules.instance(this._ctx);
        HashSet<Symbol.ModuleSymbol> recoverableModules = new HashSet<Symbol.ModuleSymbol>(modules.allModules());
        recoverableModules.remove(msym);
        recoverableModules.add(this._symtab.unnamedModule);
        Symtab symtab = Symtab.instance(this._ctx);
        for (Symbol.ModuleSymbol ms : recoverableModules) {
            if (ms.classLocation == null) {
                ms = this._moduleFinder.findModule(ms);
            }
            if (ms.kind == Kinds.Kind.ERR) continue;
            Symbol.ClassSymbol maybe = null;
            try {
                maybe = super.loadClass(ms, flatname);
            }
            catch (Symbol.CompletionFailure completionFailure) {
                // empty catch block
            }
            if (maybe == null || !maybe.exists()) continue;
            return maybe;
        }
        return null;
    }

    private boolean isJailbreakOnType(Attr attr) {
        JCTree.JCAnnotatedType annotatedType = ((ManAttr)((Object)attr)).peekAnnotatedType();
        if (annotatedType != null) {
            return annotatedType.toString().contains("@Jailbreak");
        }
        return false;
    }

    private void addJavaSeModule(Set<Symbol.ModuleSymbol> recoverableModules) {
        if (JreUtil.isJava9Modular_compiler(this._ctx)) {
            Symbol.ModuleSymbol javaSeModule = ModuleFinder.instance(this._ctx).findModule(Names.instance(this._ctx).fromString("java.se"));
            javaSeModule.complete();
            if (javaSeModule != null && javaSeModule.requires != null) {
                for (Directive.RequiresDirective directive : javaSeModule.requires) {
                    recoverableModules.add(directive.getDependency());
                }
            }
        }
    }
}

