/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.host;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.fs.IDirectory;
import manifold.api.fs.IFile;
import manifold.api.fs.cache.PathCache;
import manifold.api.host.Dependency;
import manifold.api.host.IManifoldHost;
import manifold.api.host.IModule;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.api.type.TypeName;
import manifold.api.util.JavacDiagnostic;
import manifold.internal.javac.GeneratedJavaStubFileObject;
import manifold.internal.javac.SourceJavaFileObject;
import manifold.internal.javac.SourceSupplier;
import manifold.util.concurrent.LocklessLazyVar;

public abstract class SimpleModule
implements IModule {
    private IManifoldHost _host;
    private List<IDirectory> _classpath;
    private List<IDirectory> _sourcePath;
    private List<IDirectory> _outputPath;
    private SortedSet<ITypeManifold> _typeManifolds;
    private LocklessLazyVar<PathCache> _pathCache;

    public SimpleModule(IManifoldHost host, List<IDirectory> classpath, List<IDirectory> sourcePath, List<IDirectory> outputPath) {
        this._host = host;
        this._classpath = classpath;
        this._sourcePath = sourcePath;
        this._outputPath = outputPath;
        this._pathCache = LocklessLazyVar.make(this::makePathCache);
    }

    @Override
    public IManifoldHost getHost() {
        return this._host;
    }

    @Override
    public List<IDirectory> getSourcePath() {
        return this._sourcePath;
    }

    @Override
    public List<IDirectory> getJavaClassPath() {
        return this._classpath;
    }

    protected void setJavaClassPath(List<IDirectory> cp) {
        this._classpath = cp;
    }

    @Override
    public List<IDirectory> getOutputPath() {
        return this._outputPath;
    }

    @Override
    public IDirectory[] getExcludedPath() {
        return new IDirectory[0];
    }

    @Override
    public List<IDirectory> getCollectiveSourcePath() {
        return this.getSourcePath();
    }

    @Override
    public List<IDirectory> getCollectiveJavaClassPath() {
        return this.getJavaClassPath();
    }

    @Override
    public List<Dependency> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public PathCache getPathCache() {
        return this._pathCache.get();
    }

    @Override
    public Set<ITypeManifold> getTypeManifolds() {
        return this._typeManifolds;
    }

    @Override
    public JavaFileObject produceFile(String fqn, JavaFileManager.Location location, DiagnosticListener<JavaFileObject> errorHandler) {
        Set<ITypeManifold> sps = this.findTypeManifoldsFor(fqn);
        return sps.isEmpty() ? null : new GeneratedJavaStubFileObject(fqn, new SourceSupplier(fqn, sps, () -> this.compoundProduce(location, sps, fqn, errorHandler)));
    }

    private String compoundProduce(JavaFileManager.Location location, Set<ITypeManifold> sps, String fqn, DiagnosticListener<JavaFileObject> errorHandler) {
        ITypeManifold found = null;
        String result = "";
        for (ITypeManifold sp : sps) {
            if (sp.getContributorKind() != ContributorKind.Primary && sp.getContributorKind() != ContributorKind.Partial) continue;
            if (found != null && (found.getContributorKind() == ContributorKind.Primary || sp.getContributorKind() == ContributorKind.Primary)) {
                List<IFile> files = sp.findFilesForType(fqn);
                SourceJavaFileObject file = new SourceJavaFileObject(files.get(0).toURI());
                errorHandler.report(new JavacDiagnostic(file, Diagnostic.Kind.ERROR, 0L, 1L, 1L, "The type, " + fqn + ", has conflicting type manifolds:\n'" + found.getClass().getName() + "' and '" + sp.getClass().getName() + "'.\nEither two or more resource files have the same base name or the project depends on two or more type manifolds that target the same resource type.\nIf the former, consider renaming one or more of the resource files.\nIf the latter, you must remove one or more of the type manifold libraries."));
                continue;
            }
            found = sp;
            result = sp.contribute(location, fqn, false, result, errorHandler);
        }
        for (ITypeManifold sp : sps) {
            if (sp.getContributorKind() != ContributorKind.Supplemental) continue;
            result = sp.contribute(location, fqn, false, result, errorHandler);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeTypeManifolds() {
        if (this._typeManifolds != null) {
            return;
        }
        SimpleModule simpleModule = this;
        synchronized (simpleModule) {
            if (this._typeManifolds != null) {
                return;
            }
            this._typeManifolds = this.loadTypeManifolds();
            this._typeManifolds.forEach(tm -> tm.init(this));
        }
    }

    public Set<TypeName> getChildrenOfNamespace(String packageName) {
        HashSet<TypeName> children = new HashSet<TypeName>();
        for (ITypeManifold sp : this.getTypeManifolds()) {
            Collection<TypeName> typeNames = sp.getTypeNames(packageName);
            children.addAll(typeNames);
        }
        return children;
    }

    private PathCache makePathCache() {
        return new PathCache(this, this::makeModuleSourcePath, () -> {});
    }

    private List<IDirectory> makeModuleSourcePath() {
        return this.getSourcePath().stream().filter(dir -> Arrays.stream(this.getExcludedPath()).noneMatch(excludeDir -> excludeDir.equals(dir))).collect(Collectors.toList());
    }
}

