/*
 * Decompiled with CFR 0.152.
 */
package manifold.csv.rt;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import manifold.csv.rt.parser.CsvDataSet;
import manifold.csv.rt.parser.CsvField;
import manifold.csv.rt.parser.CsvHeader;
import manifold.csv.rt.parser.CsvParser;
import manifold.csv.rt.parser.CsvRecord;
import manifold.csv.rt.parser.CsvToken;
import manifold.json.rt.Json;
import manifold.json.rt.api.DataBindings;
import manifold.json.rt.parser.Token;
import manifold.json.rt.parser.TokenType;
import manifold.rt.api.util.Pair;

public class Csv {
    public static String toCsv(Object jsonValue) {
        StringBuilder sb = new StringBuilder();
        if ((jsonValue = Json.toBindings(jsonValue)) instanceof Map) {
            Csv.toCsv(jsonValue, null, sb, 0);
        } else if (jsonValue instanceof Iterable) {
            Csv.toCsv(jsonValue, "list", sb, 0);
        } else {
            Csv.toCsv(jsonValue, "item", sb, 0);
        }
        return sb.toString();
    }

    public static void toCsv(Object jsonValue, String name, StringBuilder target, int indent) {
        if ((jsonValue = Json.toBindings(jsonValue)) instanceof Map) {
            if (name == null) {
                Map map = (Map)jsonValue;
                if (map.size() == 1) {
                    Object rootKey = map.keySet().iterator().next();
                    Object rootValue = map.get(rootKey);
                    if (rootValue instanceof Pair) {
                        rootValue = ((Pair)rootValue).getSecond();
                    }
                    Csv.toCsv(rootValue, rootKey.toString(), target, indent);
                    return;
                }
                name = "root_object";
            }
            Csv.toCsv(Collections.singletonList(jsonValue), name, target, indent);
        } else if (jsonValue instanceof Iterable) {
            Csv.toCsv((Iterable)jsonValue, name, target, indent);
        } else {
            Csv.toCsv(Collections.singletonList(jsonValue), name, target, indent);
        }
    }

    private static void toCsv(Iterable value, String name, StringBuilder target, int indent) {
        Iterator iterator = value.iterator();
        if (iterator.hasNext()) {
            Object comp = iterator.next();
            if ((comp = Json.toBindings(comp)) instanceof Pair) {
                comp = ((Pair)comp).getSecond();
            }
            if (comp instanceof Map) {
                int i = 0;
                for (Object key : ((Map)comp).keySet()) {
                    if (i > 0) {
                        target.append(',');
                    }
                    Csv.appendCsvValue(target, key);
                    ++i;
                }
                target.append('\n');
            } else if (comp instanceof Iterable) {
                Csv.appendCsvValue(target, name).append('\n');
            }
        } else {
            return;
        }
        for (Object comp : value) {
            if (comp instanceof Pair) {
                comp = ((Pair)comp).getSecond();
            }
            if ((comp = Json.toBindings(comp)) instanceof Map) {
                int i = 0;
                for (Object v : ((Map)comp).values()) {
                    if (i > 0) {
                        target.append(',');
                    }
                    Csv.appendCsvValue(target, v);
                    ++i;
                }
                target.append('\n');
                continue;
            }
            if (comp instanceof Iterable) {
                target.append('\"');
                ((Iterable)comp).forEach(e -> target.append("\"\"").append(value).append("\"\","));
                target.append("\"\n");
                continue;
            }
            Csv.appendCsvValue(target, value).append('\n');
        }
    }

    private static StringBuilder appendCsvValue(StringBuilder target, Object value) {
        target.append('\"').append(String.valueOf(value).replace("\"", "\"\"")).append('\"');
        return target;
    }

    public static Object fromCsv(String csv) {
        return Csv.fromCsv(csv, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object fromCsv(String csv, boolean withTokens) {
        try (BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(csv.getBytes()));){
            CsvDataSet dataSet = CsvParser.parse(inputStream);
            Object object = withTokens ? Csv.transformType(dataSet) : Csv.transformData(dataSet);
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<?> transformData(CsvDataSet dataSet) {
        CsvHeader header = dataSet.getHeader();
        List<Object> names = new ArrayList();
        if (header != null) {
            names = header.getFields().stream().map(f -> f.getToken()).collect(Collectors.toList());
        } else {
            List<CsvRecord> records = dataSet.getRecords();
            if (!records.isEmpty()) {
                ArrayList<String> labels = new ArrayList<String>();
                for (int i = 0; i < records.get(0).getSize(); ++i) {
                    labels.add("Field" + (i + 1));
                }
                names = labels;
            }
        }
        ArrayList<DataBindings> list = new ArrayList<DataBindings>();
        for (CsvRecord record : dataSet.getRecords()) {
            DataBindings bindings = new DataBindings();
            List<CsvField> fields = record.getFields();
            for (int fieldNum = 0; fieldNum < fields.size(); ++fieldNum) {
                CsvField field = fields.get(fieldNum);
                Object name = names.get(fieldNum);
                bindings.put(name instanceof CsvToken ? ((CsvToken)name).getData() : name.toString(), (Object)field.getToken().getData());
            }
            list.add(bindings);
        }
        return list;
    }

    private static DataBindings transformType(CsvDataSet dataSet) {
        CsvHeader header = dataSet.getHeader();
        List<Object> names = new ArrayList();
        if (header != null) {
            names = header.getFields().stream().map(f -> f.getToken()).collect(Collectors.toList());
        } else {
            List<CsvRecord> records = dataSet.getRecords();
            if (!records.isEmpty()) {
                ArrayList<String> labels = new ArrayList<String>();
                for (int i = 0; i < records.get(0).getSize(); ++i) {
                    labels.add("Field" + (i + 1));
                }
                names = labels;
            }
        }
        DataBindings typeBindings = new DataBindings();
        typeBindings.put("$schema", (Object)"http://json-schema.org/draft-04/schema#");
        typeBindings.put("synthetic", (Object)true);
        typeBindings.put("type", (Object)"array");
        DataBindings items = new DataBindings();
        typeBindings.put("items", (Object)items);
        items.put("type", (Object)"object");
        DataBindings properties = new DataBindings();
        items.put("properties", (Object)properties);
        List<Class> types = dataSet.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            String t;
            DataBindings property = new DataBindings();
            Object nameObj = names.get(i);
            if (nameObj instanceof CsvToken) {
                properties.put(((CsvToken)nameObj).getData(), Csv.makeTokensValue((CsvToken)nameObj, property));
            } else {
                properties.put(nameObj.toString(), (Object)property);
            }
            Class type = types.get(i);
            String format = null;
            if (type == Boolean.class) {
                t = "boolean";
            } else if (type == Integer.class) {
                t = "integer";
            } else if (type == Double.class) {
                t = "number";
            } else {
                t = "string";
                if (type == Long.class) {
                    format = "int64";
                } else if (type == BigInteger.class) {
                    format = "big-integer";
                } else if (type == BigDecimal.class) {
                    format = "big-decimal";
                } else if (type == LocalDateTime.class) {
                    format = "date-time";
                } else if (type == LocalDate.class) {
                    format = "date";
                } else if (type == LocalTime.class) {
                    format = "time";
                }
            }
            property.put("type", (Object)t);
            property.put("nullable", (Object)true);
            if (format == null) continue;
            property.put("format", (Object)format);
        }
        return typeBindings;
    }

    private static Object makeTokensValue(CsvToken name, DataBindings property) {
        return new Pair<Token[], DataBindings>(new Token[]{Csv.makeToken(name), null}, property);
    }

    private static Token makeToken(CsvToken token) {
        return new Token(TokenType.STRING, token.getData(), token.getOffset(), token.getLine(), -1);
    }
}

