/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing;

import graphql.Internal;
import graphql.schema.diffing.Edge;
import graphql.schema.diffing.Vertex;
import java.util.Objects;

@Internal
public class EditOperation {
    private Operation operation;
    private String description;
    private Vertex sourceVertex;
    private Vertex targetVertex;
    private Edge sourceEdge;
    private Edge targetEdge;

    private EditOperation(Operation operation, String description, Vertex sourceVertex, Vertex targetVertex, Edge sourceEdge, Edge targetEdge) {
        this.operation = operation;
        this.description = description;
        this.sourceVertex = sourceVertex;
        this.targetVertex = targetVertex;
        this.sourceEdge = sourceEdge;
        this.targetEdge = targetEdge;
    }

    public static EditOperation deleteVertex(String description, Vertex sourceVertex, Vertex targetVertex) {
        return new EditOperation(Operation.DELETE_VERTEX, description, sourceVertex, targetVertex, null, null);
    }

    public static EditOperation insertVertex(String description, Vertex sourceVertex, Vertex targetVertex) {
        return new EditOperation(Operation.INSERT_VERTEX, description, sourceVertex, targetVertex, null, null);
    }

    public static EditOperation changeVertex(String description, Vertex sourceVertex, Vertex targetVertex) {
        return new EditOperation(Operation.CHANGE_VERTEX, description, sourceVertex, targetVertex, null, null);
    }

    public static EditOperation deleteEdge(String description, Edge sourceEdge) {
        return new EditOperation(Operation.DELETE_EDGE, description, null, null, sourceEdge, null);
    }

    public static EditOperation insertEdge(String description, Edge targetEdge) {
        return new EditOperation(Operation.INSERT_EDGE, description, null, null, null, targetEdge);
    }

    public static EditOperation changeEdge(String description, Edge sourceEdge, Edge targetEdge) {
        return new EditOperation(Operation.CHANGE_EDGE, description, null, null, sourceEdge, targetEdge);
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Vertex getSourceVertex() {
        return this.sourceVertex;
    }

    public Vertex getTargetVertex() {
        return this.targetVertex;
    }

    public Edge getSourceEdge() {
        return this.sourceEdge;
    }

    public Edge getTargetEdge() {
        return this.targetEdge;
    }

    public String toString() {
        return "EditOperation{operation=" + (Object)((Object)this.operation) + ", description='" + this.description + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditOperation that = (EditOperation)o;
        return this.operation == that.operation && Objects.equals(this.description, that.description) && Objects.equals(this.sourceVertex, that.sourceVertex) && Objects.equals(this.targetVertex, that.targetVertex) && Objects.equals(this.sourceEdge, that.sourceEdge) && Objects.equals(this.targetEdge, that.targetEdge);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.description, this.sourceVertex, this.targetVertex, this.sourceEdge, this.targetEdge});
    }

    public static enum Operation {
        CHANGE_VERTEX,
        DELETE_VERTEX,
        INSERT_VERTEX,
        CHANGE_EDGE,
        INSERT_EDGE,
        DELETE_EDGE;

    }
}

