/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.GraphQLException;
import graphql.Internal;
import graphql.InvalidSyntaxError;
import graphql.PublicApi;
import graphql.language.SourceLocation;
import java.util.Collections;
import java.util.List;

@PublicApi
public class InvalidSyntaxException
extends GraphQLException {
    private final String message;
    private final String sourcePreview;
    private final String offendingToken;
    private final SourceLocation location;

    @Internal
    protected InvalidSyntaxException(String msg, SourceLocation location, String offendingToken, String sourcePreview, Exception cause) {
        super(cause);
        this.message = msg;
        this.sourcePreview = sourcePreview;
        this.offendingToken = offendingToken;
        this.location = location;
    }

    public InvalidSyntaxError toInvalidSyntaxError() {
        List<SourceLocation> sourceLocations = this.location == null ? null : Collections.singletonList(this.location);
        return new InvalidSyntaxError(sourceLocations, this.message, this.sourcePreview, this.offendingToken);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public SourceLocation getLocation() {
        return this.location;
    }

    public String getSourcePreview() {
        return this.sourcePreview;
    }

    public String getOffendingToken() {
        return this.offendingToken;
    }
}

