/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.CoercedVariables;
import graphql.execution.InputMapDefinesTooManyFieldsException;
import graphql.execution.NonNullableValueCoercedAsNullException;
import graphql.execution.RawVariables;
import graphql.execution.TypeFromAST;
import graphql.execution.ValuesResolver;
import graphql.execution.ValuesResolverLegacy;
import graphql.language.ArrayValue;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.normalized.NormalizedInputValue;
import graphql.schema.CoercingParseValueException;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.InputValueWithState;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.util.FpKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import manifold.shade.org.jetbrains.annotations.NotNull;
import manifold.shade.org.jetbrains.annotations.Nullable;

@Internal
class ValuesResolverConversion {
    ValuesResolverConversion() {
    }

    static Object valueToLiteralImpl(GraphqlFieldVisibility fieldVisibility, InputValueWithState inputValueWithState, GraphQLType type, ValuesResolver.ValueMode valueMode, GraphQLContext graphqlContext, Locale locale) {
        if (inputValueWithState.isInternal()) {
            if (valueMode == ValuesResolver.ValueMode.NORMALIZED) {
                return Assert.assertShouldNeverHappen("can't infer normalized structure", new Object[0]);
            }
            return ValuesResolverLegacy.valueToLiteralLegacy(inputValueWithState.getValue(), type, graphqlContext, locale);
        }
        if (inputValueWithState.isLiteral()) {
            return inputValueWithState.getValue();
        }
        if (inputValueWithState.isExternal()) {
            return ValuesResolverConversion.externalValueToLiteral(fieldVisibility, inputValueWithState.getValue(), (GraphQLInputType)type, valueMode, graphqlContext, locale);
        }
        return Assert.assertShouldNeverHappen("unexpected value state " + inputValueWithState, new Object[0]);
    }

    static Object externalValueToInternalValue(GraphqlFieldVisibility fieldVisibility, Object externalValue, GraphQLInputType type, GraphQLContext graphqlContext, Locale locale) {
        return ValuesResolverConversion.externalValueToInternalValueImpl(fieldVisibility, type, externalValue, graphqlContext, locale);
    }

    @Nullable
    static Object valueToInternalValueImpl(InputValueWithState inputValueWithState, GraphQLType type, GraphQLContext graphqlContext, Locale locale) {
        DefaultGraphqlFieldVisibility fieldVisibility = DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
        if (inputValueWithState.isInternal()) {
            return inputValueWithState.getValue();
        }
        if (inputValueWithState.isLiteral()) {
            return ValuesResolverConversion.literalToInternalValue(fieldVisibility, type, (Value)inputValueWithState.getValue(), CoercedVariables.emptyVariables(), graphqlContext, locale);
        }
        if (inputValueWithState.isExternal()) {
            return ValuesResolverConversion.externalValueToInternalValueImpl(fieldVisibility, type, inputValueWithState.getValue(), graphqlContext, locale);
        }
        return Assert.assertShouldNeverHappen("unexpected value state " + inputValueWithState, new Object[0]);
    }

    static Object externalValueToLiteral(GraphqlFieldVisibility fieldVisibility, @Nullable Object value, GraphQLInputType type, ValuesResolver.ValueMode valueMode, GraphQLContext graphqlContext, Locale locale) {
        if (value == null) {
            return NullValue.newNullValue().build();
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return ValuesResolverConversion.externalValueToLiteral(fieldVisibility, value, (GraphQLInputType)GraphQLTypeUtil.unwrapNonNull(type), valueMode, graphqlContext, locale);
        }
        if (type instanceof GraphQLScalarType) {
            return ValuesResolverConversion.externalValueToLiteralForScalar((GraphQLScalarType)type, value, graphqlContext, locale);
        }
        if (type instanceof GraphQLEnumType) {
            return ValuesResolverConversion.externalValueToLiteralForEnum((GraphQLEnumType)type, value, graphqlContext, locale);
        }
        if (type instanceof GraphQLList) {
            return ValuesResolverConversion.externalValueToLiteralForList(fieldVisibility, (GraphQLList)type, value, valueMode, graphqlContext, locale);
        }
        if (type instanceof GraphQLInputObjectType) {
            return ValuesResolverConversion.externalValueToLiteralForObject(fieldVisibility, (GraphQLInputObjectType)type, value, valueMode, graphqlContext, locale);
        }
        return Assert.assertShouldNeverHappen("unexpected type %s", type);
    }

    private static Value<?> externalValueToLiteralForScalar(GraphQLScalarType scalarType, Object value, GraphQLContext graphqlContext, @NotNull Locale locale) {
        return scalarType.getCoercing().valueToLiteral(value, graphqlContext, locale);
    }

    private static Value<?> externalValueToLiteralForEnum(GraphQLEnumType enumType, Object value, GraphQLContext graphqlContext, Locale locale) {
        return enumType.valueToLiteral(value, graphqlContext, locale);
    }

    private static Object externalValueToLiteralForList(GraphqlFieldVisibility fieldVisibility, GraphQLList listType, Object value, ValuesResolver.ValueMode valueMode, GraphQLContext graphqlContext, Locale locale) {
        GraphQLInputType wrappedType = (GraphQLInputType)listType.getWrappedType();
        List<Value> result = FpKit.toListOrSingletonList(value).stream().map(val2 -> ValuesResolverConversion.externalValueToLiteral(fieldVisibility, val2, wrappedType, valueMode, graphqlContext, locale)).collect(Collectors.toList());
        if (valueMode == ValuesResolver.ValueMode.NORMALIZED) {
            return result;
        }
        return ArrayValue.newArrayValue().values(result).build();
    }

    private static Object externalValueToLiteralForObject(GraphqlFieldVisibility fieldVisibility, GraphQLInputObjectType inputObjectType, Object inputValue, ValuesResolver.ValueMode valueMode, GraphQLContext graphqlContext, Locale locale) {
        Assert.assertTrue(inputValue instanceof Map, () -> "Expect Map as input");
        Map inputMap = (Map)inputValue;
        List<GraphQLInputObjectField> fieldDefinitions = fieldVisibility.getFieldDefinitions(inputObjectType);
        LinkedHashMap<String, NormalizedInputValue> normalizedResult = new LinkedHashMap<String, NormalizedInputValue>();
        ImmutableList.Builder objectFields = ImmutableList.builder();
        for (GraphQLInputObjectField inputFieldDefinition : fieldDefinitions) {
            GraphQLInputType fieldType = inputFieldDefinition.getType();
            String fieldName = inputFieldDefinition.getName();
            boolean hasValue = inputMap.containsKey(fieldName);
            Object fieldValue = inputMap.getOrDefault(fieldName, null);
            if (!hasValue && inputFieldDefinition.hasSetDefaultValue()) {
                Object defaultValueLiteral = ValuesResolverConversion.valueToLiteralImpl(fieldVisibility, inputFieldDefinition.getInputFieldDefaultValue(), fieldType, ValuesResolver.ValueMode.LITERAL, graphqlContext, locale);
                if (valueMode == ValuesResolver.ValueMode.LITERAL) {
                    normalizedResult.put(fieldName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(fieldType), defaultValueLiteral));
                    continue;
                }
                objectFields.add(ObjectField.newObjectField().name(fieldName).value((Value)defaultValueLiteral).build());
                continue;
            }
            if (!hasValue) continue;
            if (fieldValue == null) {
                if (valueMode == ValuesResolver.ValueMode.NORMALIZED) {
                    normalizedResult.put(fieldName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(fieldType), null));
                    continue;
                }
                objectFields.add(ObjectField.newObjectField().name(fieldName).value(NullValue.newNullValue().build()).build());
                continue;
            }
            Object literal = ValuesResolverConversion.externalValueToLiteral(fieldVisibility, fieldValue, fieldType, valueMode, graphqlContext, locale);
            if (valueMode == ValuesResolver.ValueMode.NORMALIZED) {
                normalizedResult.put(fieldName, new NormalizedInputValue(GraphQLTypeUtil.simplePrint(fieldType), literal));
                continue;
            }
            objectFields.add(ObjectField.newObjectField().name(fieldName).value((Value)literal).build());
        }
        if (valueMode == ValuesResolver.ValueMode.NORMALIZED) {
            return normalizedResult;
        }
        return ObjectValue.newObjectValue().objectFields((List<ObjectField>)((Object)objectFields.build())).build();
    }

    static CoercedVariables externalValueToInternalValueForVariables(GraphQLSchema schema, List<VariableDefinition> variableDefinitions, RawVariables rawVariables, GraphQLContext graphqlContext, Locale locale) {
        GraphqlFieldVisibility fieldVisibility = schema.getCodeRegistry().getFieldVisibility();
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        for (VariableDefinition variableDefinition : variableDefinitions) {
            try {
                String variableName = variableDefinition.getName();
                GraphQLType variableType = TypeFromAST.getTypeFromAST(schema, variableDefinition.getType());
                Assert.assertTrue(variableType instanceof GraphQLInputType);
                Value defaultValue = variableDefinition.getDefaultValue();
                boolean hasValue = rawVariables.containsKey(variableName);
                Object value = rawVariables.get(variableName);
                if (!hasValue && defaultValue != null) {
                    Object coercedDefaultValue = ValuesResolverConversion.literalToInternalValue(fieldVisibility, variableType, defaultValue, CoercedVariables.emptyVariables(), graphqlContext, locale);
                    coercedValues.put(variableName, coercedDefaultValue);
                    continue;
                }
                if (GraphQLTypeUtil.isNonNull(variableType) && (!hasValue || value == null)) {
                    throw new NonNullableValueCoercedAsNullException(variableDefinition, variableType);
                }
                if (!hasValue) continue;
                if (value == null) {
                    coercedValues.put(variableName, null);
                    continue;
                }
                Object coercedValue = ValuesResolverConversion.externalValueToInternalValueImpl(fieldVisibility, variableType, value, graphqlContext, locale);
                coercedValues.put(variableName, coercedValue);
            }
            catch (CoercingParseValueException e) {
                throw ((CoercingParseValueException.Builder)((CoercingParseValueException.Builder)((CoercingParseValueException.Builder)((CoercingParseValueException.Builder)CoercingParseValueException.newCoercingParseValueException().message(String.format("Variable '%s' has an invalid value: %s", variableDefinition.getName(), e.getMessage()))).extensions(e.getExtensions())).cause(e.getCause())).sourceLocation(variableDefinition.getSourceLocation())).build();
            }
            catch (NonNullableValueCoercedAsNullException e) {
                throw new NonNullableValueCoercedAsNullException(variableDefinition, e.getMessage());
            }
        }
        return CoercedVariables.of(coercedValues);
    }

    static Object externalValueToInternalValueImpl(GraphqlFieldVisibility fieldVisibility, GraphQLType graphQLType, Object value, GraphQLContext graphqlContext, Locale locale) throws NonNullableValueCoercedAsNullException, CoercingParseValueException {
        if (GraphQLTypeUtil.isNonNull(graphQLType)) {
            Object returnValue = ValuesResolverConversion.externalValueToInternalValueImpl(fieldVisibility, GraphQLTypeUtil.unwrapOne(graphQLType), value, graphqlContext, locale);
            if (returnValue == null) {
                throw new NonNullableValueCoercedAsNullException(graphQLType);
            }
            return returnValue;
        }
        if (value == null) {
            return null;
        }
        if (graphQLType instanceof GraphQLScalarType) {
            return ValuesResolverConversion.externalValueToInternalValueForScalar((GraphQLScalarType)graphQLType, value, graphqlContext, locale);
        }
        if (graphQLType instanceof GraphQLEnumType) {
            return ValuesResolverConversion.externalValueToInternalValueForEnum((GraphQLEnumType)graphQLType, value, graphqlContext, locale);
        }
        if (graphQLType instanceof GraphQLList) {
            return ValuesResolverConversion.externalValueToInternalValueForList(fieldVisibility, (GraphQLList)graphQLType, value, graphqlContext, locale);
        }
        if (graphQLType instanceof GraphQLInputObjectType) {
            if (value instanceof Map) {
                return ValuesResolverConversion.externalValueToInternalValueForObject(fieldVisibility, (GraphQLInputObjectType)graphQLType, (Map)value, graphqlContext, locale);
            }
            throw ((CoercingParseValueException.Builder)CoercingParseValueException.newCoercingParseValueException().message("Expected type 'Map' but was '" + value.getClass().getSimpleName() + "'. Variables for input objects must be an instance of type 'Map'.")).build();
        }
        return Assert.assertShouldNeverHappen("unhandled type %s", graphQLType);
    }

    private static Object externalValueToInternalValueForObject(GraphqlFieldVisibility fieldVisibility, GraphQLInputObjectType inputObjectType, Map<String, Object> inputMap, GraphQLContext graphqlContext, Locale locale) throws NonNullableValueCoercedAsNullException, CoercingParseValueException {
        List<GraphQLInputObjectField> fieldDefinitions = fieldVisibility.getFieldDefinitions(inputObjectType);
        ImmutableList<String> fieldNames = ImmutableKit.map(fieldDefinitions, GraphQLInputObjectField::getName);
        for (String providedFieldName : inputMap.keySet()) {
            if (fieldNames.contains(providedFieldName)) continue;
            throw new InputMapDefinesTooManyFieldsException(inputObjectType, providedFieldName);
        }
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        for (GraphQLInputObjectField inputFieldDefinition : fieldDefinitions) {
            GraphQLInputType fieldType = inputFieldDefinition.getType();
            String fieldName = inputFieldDefinition.getName();
            InputValueWithState defaultValue = inputFieldDefinition.getInputFieldDefaultValue();
            boolean hasValue = inputMap.containsKey(fieldName);
            Object value = inputMap.getOrDefault(fieldName, null);
            if (!hasValue && inputFieldDefinition.hasSetDefaultValue()) {
                Object coercedDefaultValue = ValuesResolverConversion.defaultValueToInternalValue(fieldVisibility, defaultValue, fieldType, graphqlContext, locale);
                coercedValues.put(fieldName, coercedDefaultValue);
                continue;
            }
            if (GraphQLTypeUtil.isNonNull(fieldType) && (!hasValue || value == null)) {
                throw new NonNullableValueCoercedAsNullException(fieldName, ImmutableKit.emptyList(), (GraphQLType)fieldType);
            }
            if (!hasValue) continue;
            if (value == null) {
                coercedValues.put(fieldName, null);
                continue;
            }
            value = ValuesResolverConversion.externalValueToInternalValueImpl(fieldVisibility, fieldType, value, graphqlContext, locale);
            coercedValues.put(fieldName, value);
        }
        return coercedValues;
    }

    private static Object externalValueToInternalValueForScalar(GraphQLScalarType graphQLScalarType, Object value, GraphQLContext graphqlContext, Locale locale) throws CoercingParseValueException {
        return graphQLScalarType.getCoercing().parseValue(value, graphqlContext, locale);
    }

    private static Object externalValueToInternalValueForEnum(GraphQLEnumType graphQLEnumType, Object value, GraphQLContext graphqlContext, Locale locale) throws CoercingParseValueException {
        return graphQLEnumType.parseValue(value, graphqlContext, locale);
    }

    private static List externalValueToInternalValueForList(GraphqlFieldVisibility fieldVisibility, GraphQLList graphQLList, Object value, GraphQLContext graphqlContext, Locale locale) throws CoercingParseValueException, NonNullableValueCoercedAsNullException {
        GraphQLType wrappedType = graphQLList.getWrappedType();
        return FpKit.toListOrSingletonList(value).stream().map(val2 -> ValuesResolverConversion.externalValueToInternalValueImpl(fieldVisibility, wrappedType, val2, graphqlContext, locale)).collect(Collectors.toList());
    }

    static Object literalToInternalValue(GraphqlFieldVisibility fieldVisibility, GraphQLType type, Value inputValue, CoercedVariables coercedVariables, GraphQLContext graphqlContext, Locale locale) {
        return ValuesResolverConversion.literalToInternalValueImpl(fieldVisibility, type, inputValue, coercedVariables, graphqlContext, locale);
    }

    @Nullable
    private static Object literalToInternalValueImpl(GraphqlFieldVisibility fieldVisibility, GraphQLType type, Value inputValue, CoercedVariables coercedVariables, GraphQLContext graphqlContext, Locale locale) {
        if (inputValue instanceof VariableReference) {
            return coercedVariables.get(((VariableReference)inputValue).getName());
        }
        if (inputValue instanceof NullValue) {
            return null;
        }
        if (type instanceof GraphQLScalarType) {
            return ValuesResolverConversion.literalToInternalValueForScalar(inputValue, (GraphQLScalarType)type, coercedVariables, graphqlContext, locale);
        }
        if (GraphQLTypeUtil.isNonNull(type)) {
            return ValuesResolverConversion.literalToInternalValue(fieldVisibility, GraphQLTypeUtil.unwrapOne(type), inputValue, coercedVariables, graphqlContext, locale);
        }
        if (type instanceof GraphQLInputObjectType) {
            return ValuesResolverConversion.literalToInternalValueForInputObject(fieldVisibility, (GraphQLInputObjectType)type, (ObjectValue)inputValue, coercedVariables, graphqlContext, locale);
        }
        if (type instanceof GraphQLEnumType) {
            return ((GraphQLEnumType)type).parseLiteral(inputValue, graphqlContext, locale);
        }
        if (GraphQLTypeUtil.isList(type)) {
            return ValuesResolverConversion.literalToInternalValueForList(fieldVisibility, (GraphQLList)type, inputValue, coercedVariables, graphqlContext, locale);
        }
        return null;
    }

    private static Object literalToInternalValueForScalar(Value inputValue, GraphQLScalarType scalarType, CoercedVariables coercedVariables, GraphQLContext graphqlContext, @NotNull Locale locale) {
        return scalarType.getCoercing().parseLiteral(inputValue, coercedVariables, graphqlContext, locale);
    }

    private static Object literalToInternalValueForList(GraphqlFieldVisibility fieldVisibility, GraphQLList graphQLList, Value value, CoercedVariables coercedVariables, GraphQLContext graphqlContext, Locale locale) {
        if (value instanceof ArrayValue) {
            ArrayValue arrayValue = (ArrayValue)value;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Value singleValue : arrayValue.getValues()) {
                result.add(ValuesResolverConversion.literalToInternalValue(fieldVisibility, graphQLList.getWrappedType(), singleValue, coercedVariables, graphqlContext, locale));
            }
            return result;
        }
        return Collections.singletonList(ValuesResolverConversion.literalToInternalValue(fieldVisibility, graphQLList.getWrappedType(), value, coercedVariables, graphqlContext, locale));
    }

    private static Object literalToInternalValueForInputObject(GraphqlFieldVisibility fieldVisibility, GraphQLInputObjectType type, ObjectValue inputValue, CoercedVariables coercedVariables, GraphQLContext graphqlContext, Locale locale) {
        LinkedHashMap<String, Object> coercedValues = new LinkedHashMap<String, Object>();
        Map<String, ObjectField> inputFieldsByName = ValuesResolverConversion.mapObjectValueFieldsByName(inputValue);
        List<GraphQLInputObjectField> inputFieldTypes = fieldVisibility.getFieldDefinitions(type);
        for (GraphQLInputObjectField inputFieldDefinition : inputFieldTypes) {
            Object value;
            Value fieldValue;
            GraphQLInputType fieldType = inputFieldDefinition.getType();
            String fieldName = inputFieldDefinition.getName();
            ObjectField field = inputFieldsByName.get(fieldName);
            boolean hasValue = field != null;
            Value value2 = fieldValue = field != null ? field.getValue() : null;
            if (fieldValue instanceof VariableReference) {
                String variableName = ((VariableReference)fieldValue).getName();
                hasValue = coercedVariables.containsKey(variableName);
                value = coercedVariables.get(variableName);
            } else {
                value = fieldValue;
            }
            if (!hasValue && inputFieldDefinition.hasSetDefaultValue()) {
                Object coercedDefaultValue = ValuesResolverConversion.defaultValueToInternalValue(fieldVisibility, inputFieldDefinition.getInputFieldDefaultValue(), fieldType, graphqlContext, locale);
                coercedValues.put(fieldName, coercedDefaultValue);
                continue;
            }
            if (GraphQLTypeUtil.isNonNull(fieldType) && (!hasValue || ValuesResolverConversion.isNullValue(value))) {
                return Assert.assertShouldNeverHappen("Should have been validated before", new Object[0]);
            }
            if (!hasValue) continue;
            if (ValuesResolverConversion.isNullValue(value)) {
                coercedValues.put(fieldName, value);
                continue;
            }
            if (fieldValue instanceof VariableReference) {
                coercedValues.put(fieldName, value);
                continue;
            }
            value = ValuesResolverConversion.literalToInternalValue(fieldVisibility, fieldType, fieldValue, coercedVariables, graphqlContext, locale);
            coercedValues.put(fieldName, value);
        }
        return coercedValues;
    }

    static boolean isNullValue(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof NormalizedInputValue)) {
            return false;
        }
        return ((NormalizedInputValue)value).getValue() == null;
    }

    private static Map<String, ObjectField> mapObjectValueFieldsByName(ObjectValue inputValue) {
        LinkedHashMap<String, ObjectField> inputValueFieldsByName = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : inputValue.getObjectFields()) {
            inputValueFieldsByName.put(objectField.getName(), objectField);
        }
        return inputValueFieldsByName;
    }

    static Object defaultValueToInternalValue(GraphqlFieldVisibility fieldVisibility, InputValueWithState defaultValue, GraphQLInputType type, GraphQLContext graphqlContext, Locale locale) {
        if (defaultValue.isInternal()) {
            return defaultValue.getValue();
        }
        if (defaultValue.isLiteral()) {
            return ValuesResolverConversion.literalToInternalValue(fieldVisibility, type, (Value)defaultValue.getValue(), CoercedVariables.emptyVariables(), graphqlContext, locale);
        }
        if (defaultValue.isExternal()) {
            return ValuesResolverConversion.externalValueToInternalValueImpl(fieldVisibility, type, defaultValue.getValue(), graphqlContext, locale);
        }
        return Assert.assertShouldNeverHappen();
    }
}

