/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;

@PublicApi
public class FetchedValue {
    private final Object fetchedValue;
    private final Object rawFetchedValue;
    private final Object localContext;
    private final ImmutableList<GraphQLError> errors;

    private FetchedValue(Object fetchedValue, Object rawFetchedValue, ImmutableList<GraphQLError> errors, Object localContext) {
        this.fetchedValue = fetchedValue;
        this.rawFetchedValue = rawFetchedValue;
        this.errors = errors;
        this.localContext = localContext;
    }

    public Object getFetchedValue() {
        return this.fetchedValue;
    }

    public Object getRawFetchedValue() {
        return this.rawFetchedValue;
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }

    public Object getLocalContext() {
        return this.localContext;
    }

    public FetchedValue transform(Consumer<Builder> builderConsumer) {
        Builder builder = FetchedValue.newFetchedValue(this);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public String toString() {
        return "FetchedValue{fetchedValue=" + this.fetchedValue + ", rawFetchedValue=" + this.rawFetchedValue + ", localContext=" + this.localContext + ", errors=" + this.errors + '}';
    }

    public static Builder newFetchedValue() {
        return new Builder();
    }

    public static Builder newFetchedValue(FetchedValue otherValue) {
        return new Builder().fetchedValue(otherValue.getFetchedValue()).rawFetchedValue(otherValue.getRawFetchedValue()).errors(otherValue.getErrors()).localContext(otherValue.getLocalContext());
    }

    public static class Builder {
        private Object fetchedValue;
        private Object rawFetchedValue;
        private Object localContext;
        private ImmutableList<GraphQLError> errors = ImmutableList.of();

        public Builder fetchedValue(Object fetchedValue) {
            this.fetchedValue = fetchedValue;
            return this;
        }

        public Builder rawFetchedValue(Object rawFetchedValue) {
            this.rawFetchedValue = rawFetchedValue;
            return this;
        }

        public Builder localContext(Object localContext) {
            this.localContext = localContext;
            return this;
        }

        public Builder errors(List<GraphQLError> errors) {
            this.errors = ImmutableList.copyOf(errors);
            return this;
        }

        public FetchedValue build() {
            return new FetchedValue(this.fetchedValue, this.rawFetchedValue, this.errors, this.localContext);
        }
    }
}

