/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.Acceleration;
import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.Force;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.Length;
import manifold.science.measures.LengthUnit;
import manifold.science.measures.Mass;
import manifold.science.measures.MassUnit;
import manifold.science.measures.Momentum;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.Power;
import manifold.science.measures.PowerUnit;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.VelocityUnit;
import manifold.science.util.Rational;

public final class Velocity
extends AbstractMeasure<VelocityUnit, Velocity> {
    public Velocity(Rational value, VelocityUnit unit, VelocityUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Velocity(Rational value, VelocityUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public VelocityUnit getBaseUnit() {
        return VelocityUnit.BASE;
    }

    @Override
    public Velocity make(Rational value, VelocityUnit unit, VelocityUnit displayUnit) {
        return new Velocity(value, unit, displayUnit);
    }

    @Override
    public Velocity make(Rational value, VelocityUnit unit) {
        return new Velocity(value, unit, unit);
    }

    public Length times(Time t) {
        return new Length(this.toBaseNumber().times(t.toBaseNumber()), LengthUnit.BASE, ((VelocityUnit)this.getDisplayUnit()).getLengthUnit());
    }

    public Acceleration div(Time t) {
        return new Acceleration(this.toBaseNumber().div(t.toBaseNumber()), AccelerationUnit.BASE, AccelerationUnit.get((VelocityUnit)this.getDisplayUnit(), (TimeUnit)t.getDisplayUnit()));
    }

    public Time div(Acceleration acc) {
        return new Time(this.toBaseNumber().div(acc.toBaseNumber()), TimeUnit.BASE, ((AccelerationUnit)acc.getDisplayUnit()).getTimeUnit());
    }

    public Momentum times(Mass mass) {
        return new Momentum(this.toBaseNumber().times(mass.toBaseNumber()), MomentumUnit.BASE, MomentumUnit.get((MassUnit)mass.getDisplayUnit(), (VelocityUnit)this.getDisplayUnit()));
    }

    public Power times(Force force) {
        return new Power(this.toBaseNumber().times(force.toBaseNumber()), PowerUnit.BASE, ((VelocityUnit)this.getDisplayUnit()).times((ForceUnit)force.getDisplayUnit()));
    }
}

