/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.EnergyUnit;
import manifold.science.measures.MagneticFlux;
import manifold.science.measures.MagneticFluxDensityUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class MagneticFluxUnit
extends AbstractQuotientUnit<EnergyUnit, CurrentUnit, MagneticFlux, MagneticFluxUnit> {
    private static final UnitCache<MagneticFluxUnit> CACHE = new UnitCache();
    public static final MagneticFluxUnit Wb;
    public static final MagneticFluxUnit BASE;

    public static MagneticFluxUnit get(EnergyUnit energyUnit, CurrentUnit currentUnit) {
        return MagneticFluxUnit.get(energyUnit, currentUnit, null, null, null);
    }

    public static MagneticFluxUnit get(EnergyUnit energyUnit, CurrentUnit currentUnit, Rational factor, String name, String symbol) {
        MagneticFluxUnit unit = new MagneticFluxUnit(energyUnit, currentUnit, factor, name, symbol);
        return (MagneticFluxUnit)CACHE.get(unit);
    }

    private MagneticFluxUnit(EnergyUnit energyUnit, CurrentUnit currentUnit, Rational factor, String name, String symbol) {
        super(energyUnit, currentUnit, factor, name, symbol);
    }

    @Override
    public MagneticFlux makeDimension(Number amount) {
        return new MagneticFlux(Rational.get(amount), this);
    }

    public EnergyUnit getEnergyUnit() {
        return (EnergyUnit)this.getLeftUnit();
    }

    public CurrentUnit getCurrentUnit() {
        return (CurrentUnit)this.getRightUnit();
    }

    public MagneticFluxDensityUnit div(AreaUnit area) {
        return MagneticFluxDensityUnit.get(this, area);
    }

    public AreaUnit div(MagneticFluxDensityUnit mf) {
        return mf.getAreaUnit();
    }

    static {
        BASE = Wb = MagneticFluxUnit.get(EnergyUnit.BASE, CurrentUnit.BASE, CoercionConstants.r.postfixBind(1), "Weber", "Wb");
    }
}

