/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractQuotientUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.Conductance;
import manifold.science.measures.CurrentUnit;
import manifold.science.measures.PotentialUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class ConductanceUnit
extends AbstractQuotientUnit<CurrentUnit, PotentialUnit, Conductance, ConductanceUnit> {
    private static final UnitCache<ConductanceUnit> CACHE = new UnitCache();
    public static final ConductanceUnit S;
    public static final ConductanceUnit BASE;

    public static ConductanceUnit get(CurrentUnit currentUnit, PotentialUnit potentialUnit) {
        return ConductanceUnit.get(currentUnit, potentialUnit, null, null, null);
    }

    public static ConductanceUnit get(CurrentUnit currentUnit, PotentialUnit potentialUnit, Rational factor, String name, String symbol) {
        ConductanceUnit unit = new ConductanceUnit(currentUnit, potentialUnit, factor, name, symbol);
        return (ConductanceUnit)CACHE.get(unit);
    }

    @Override
    public Conductance makeDimension(Number amount) {
        return new Conductance(Rational.get(amount), this);
    }

    private ConductanceUnit(CurrentUnit currentUnit, PotentialUnit potentialUnit, Rational factor, String name, String symbol) {
        super(currentUnit, potentialUnit, factor, name, symbol);
    }

    public CurrentUnit getCurrentUnit() {
        return (CurrentUnit)this.getLeftUnit();
    }

    public PotentialUnit getPotentialUnit() {
        return (PotentialUnit)this.getRightUnit();
    }

    static {
        BASE = S = ConductanceUnit.get(CurrentUnit.BASE, PotentialUnit.BASE, CoercionConstants.r.postfixBind(1), "Siemens", "S");
    }
}

