/*
 * Decompiled with CFR 0.152.
 */
package manifold.api.gen;

import com.sun.source.tree.Tree;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.lang.model.element.ElementKind;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import manifold.api.gen.AbstractSrcMethod;
import manifold.api.gen.SrcConstructor;
import manifold.api.gen.SrcField;
import manifold.api.gen.SrcGetProperty;
import manifold.api.gen.SrcSetProperty;
import manifold.api.gen.SrcStatement;
import manifold.api.gen.SrcStatementBlock;
import manifold.api.gen.SrcType;
import manifold.api.host.IModule;
import manifold.api.type.ContributorKind;
import manifold.api.type.ITypeManifold;
import manifold.rt.api.util.ManClassUtil;

public class AbstractSrcClass<T extends AbstractSrcClass<T>>
extends SrcStatement<T> {
    private final String _package;
    private final String _originalSimpleName;
    private final List<String> _imports;
    private final Kind _kind;
    private SrcType _superClass;
    private final AbstractSrcClass _enclosingClass;
    private final List<SrcType> _interfaces = new ArrayList<SrcType>();
    private final List<SrcField> _fields = new ArrayList<SrcField>();
    private final List<SrcField> _enumConsts = new ArrayList<SrcField>();
    private final List<SrcConstructor> _constructors = new ArrayList<SrcConstructor>();
    private final List<AbstractSrcMethod> _methods = new ArrayList<AbstractSrcMethod>();
    private final List<SrcStatementBlock> _staticBlocks = new ArrayList<SrcStatementBlock>();
    private final TreeMap<String, SrcGetProperty> _getProperties = new TreeMap();
    private final TreeMap<String, SrcSetProperty> _setProperties = new TreeMap();
    private final List<AbstractSrcClass> _innerClasses = new ArrayList<AbstractSrcClass>();
    private final List<SrcType> _typeVars;
    private final IModule _module;
    private final JavaFileManager.Location _location;
    private final DiagnosticListener<JavaFileObject> _errorHandler;
    private boolean _binary;

    public AbstractSrcClass(String fqn, Kind kind) {
        this(fqn, null, kind);
    }

    public AbstractSrcClass(String fqn, AbstractSrcClass enclosingClass, Kind kind) {
        this(fqn, enclosingClass, kind, null, null, null);
    }

    public AbstractSrcClass(String fqn, AbstractSrcClass enclosingClass, Kind kind, JavaFileManager.Location location, IModule module, DiagnosticListener<JavaFileObject> errorHandler) {
        super(enclosingClass);
        this._enclosingClass = enclosingClass;
        this._package = ManClassUtil.getPackage(fqn);
        this._originalSimpleName = ManClassUtil.getShortClassName(fqn);
        this.disambiguateSimpleName(fqn);
        this._kind = kind;
        this._imports = new ArrayList<String>();
        this._typeVars = new ArrayList<SrcType>();
        this._location = location;
        this._module = module;
        this._errorHandler = errorHandler;
    }

    private void disambiguateSimpleName(String fqn) {
        String simpleName = ManClassUtil.getShortClassName(fqn);
        if (this.duplicatesEnclosing(simpleName)) {
            simpleName = this._enclosingClass.getSimpleName() + '_' + simpleName;
        }
        this.name(simpleName);
    }

    private boolean duplicatesEnclosing(String simpleName) {
        if (this._enclosingClass != null) {
            return this._enclosingClass.getSimpleName().equals(simpleName) || this._enclosingClass.duplicatesEnclosing(simpleName);
        }
        return false;
    }

    public String getDisambiguatedNameInNest(String name) {
        for (AbstractSrcClass inner : this.getInnerClasses()) {
            if (!name.equals(inner._originalSimpleName)) continue;
            return inner.getSimpleName();
        }
        return name;
    }

    public T superClass(SrcType superClass) {
        this._superClass = superClass;
        return (T)this;
    }

    public T superClass(Class superClass) {
        this._superClass = new SrcType(superClass);
        return (T)this;
    }

    public T superClass(String superClass) {
        this._superClass = new SrcType(superClass);
        return (T)this;
    }

    public T addInterface(SrcType iface) {
        this._interfaces.add(iface);
        iface.setOwner(this);
        return (T)this;
    }

    public T addInterface(Class iface) {
        SrcType t = new SrcType(iface);
        return this.addInterface(t);
    }

    public T addInterface(String iface) {
        SrcType t = new SrcType(iface);
        return this.addInterface(t);
    }

    public T addField(SrcField field) {
        this._fields.add(field);
        field.setOwner(this);
        return (T)this;
    }

    public T addEnumConst(SrcField enumConst) {
        this._enumConsts.add(enumConst);
        enumConst.setOwner(this);
        return (T)this;
    }

    public T addConstructor(SrcConstructor ctor) {
        this._constructors.add(ctor);
        ctor.setOwner(this);
        return (T)this;
    }

    public T addMethod(AbstractSrcMethod method) {
        this._methods.add(method);
        method.setOwner(this);
        return (T)this;
    }

    public T addGetProperty(SrcGetProperty property) {
        this._getProperties.put(property.getSimpleName(), property);
        property.setOwner(this);
        return (T)this;
    }

    public T addSetProperty(SrcSetProperty property) {
        this._setProperties.put(property.getSimpleName(), property);
        property.setOwner(this);
        return (T)this;
    }

    public T addInnerClass(AbstractSrcClass innerClass) {
        this._innerClasses.add(innerClass);
        innerClass.setOwner(this);
        return (T)this;
    }

    public T addStaticBlock(SrcStatementBlock block) {
        this._staticBlocks.add(block);
        block.setOwner(this);
        return (T)this;
    }

    public T imports(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this._imports.add(c.getName());
        }
        return (T)this;
    }

    public T imports(String ... classes) {
        this._imports.addAll(Arrays.asList(classes));
        return (T)this;
    }

    public T addImport(Class cls) {
        if (cls.getEnclosingClass() != null) {
            return this.addImport(cls.getCanonicalName());
        }
        return this.addImport(cls.getTypeName());
    }

    public T addImport(String path) {
        this._imports.add(path);
        return (T)this;
    }

    public T addStaticImport(String path) {
        this._imports.add("static " + path);
        return (T)this;
    }

    public String getPackage() {
        return this._package;
    }

    public Kind getKind() {
        return this._kind;
    }

    public SrcType getSuperClass() {
        return this._superClass;
    }

    public AbstractSrcClass<?> getEnclosingClass() {
        return this._enclosingClass;
    }

    public List<SrcType> getInterfaces() {
        return this._interfaces;
    }

    public List<SrcField> getFields() {
        return this._fields;
    }

    public List<SrcField> getEnumConsts() {
        return this._enumConsts;
    }

    public List<SrcConstructor> getConstructors() {
        return this._constructors;
    }

    public List<AbstractSrcMethod> getMethods() {
        return this._methods;
    }

    public List<SrcStatementBlock> getStaticBlocks() {
        return this._staticBlocks;
    }

    public List<AbstractSrcClass> getInnerClasses() {
        return this._innerClasses;
    }

    public void addTypeVar(SrcType typeVar) {
        this._typeVars.add(typeVar);
    }

    public String getName() {
        return (this._package.isEmpty() ? "" : this._package + '.') + this.getSimpleName();
    }

    public boolean isInterface() {
        return this._kind == Kind.Interface;
    }

    public boolean isEnum() {
        return this._kind == Kind.Enum;
    }

    public boolean isAnnotation() {
        return this._kind == Kind.Annotation;
    }

    public boolean isRecord() {
        return this._kind == Kind.Record;
    }

    public List<SrcType> getTypeVariables() {
        return this._typeVars;
    }

    public boolean isBinary() {
        return this._binary || this.getEnclosingClass() != null && this.getEnclosingClass().isBinary();
    }

    public void setBinary(boolean binary) {
        this._binary = binary;
    }

    public JavaFileManager.Location getLocation() {
        return this.getEnclosingClass() != null ? this.getEnclosingClass().getLocation() : this._location;
    }

    public IModule getModule() {
        return this.getEnclosingClass() != null ? this.getEnclosingClass().getModule() : this._module;
    }

    public DiagnosticListener<JavaFileObject> getErrorHandler() {
        return this.getEnclosingClass() != null ? this.getEnclosingClass().getErrorHandler() : this._errorHandler;
    }

    public StringBuilder render() {
        return this.render(0);
    }

    public StringBuilder render(int indent) {
        return this.render(new StringBuilder(), indent);
    }

    @Override
    public StringBuilder render(StringBuilder sb, int indent) {
        return this.render(sb, indent, true);
    }

    public StringBuilder render(StringBuilder sb, int indent, boolean includePackage) {
        if (includePackage) {
            this.renderPackage(sb);
        }
        StringBuilder sbType = new StringBuilder();
        switch (this._kind) {
            case Enum: {
                this.renderEnum(sbType, indent);
                break;
            }
            case Annotation: {
                this.renderAnnotation(sbType, indent);
                break;
            }
            case Class: 
            case Interface: {
                this.renderClassOrInterface(sbType, indent);
                break;
            }
            case Record: {
                this.renderRecord(sbType, indent);
            }
        }
        if (this.getEnclosingClass() != null) {
            this.supplementInner(this.getName(), sbType);
        }
        sb.append((CharSequence)sbType);
        return sb;
    }

    private void supplementInner(String fqnInner, StringBuilder innerSource) {
        if (this.getModule() == null || this.getLocation() == null) {
            return;
        }
        Set<ITypeManifold> sps = this.getModule().findTypeManifoldsFor(fqnInner);
        for (ITypeManifold sp : sps) {
            String source;
            if (sp.getContributorKind() != ContributorKind.Supplemental || (source = sp.contribute(this.getLocation(), fqnInner, this.isBinary(), innerSource.toString(), this.getErrorHandler())) == null) continue;
            innerSource.replace(0, innerSource.length(), source);
        }
    }

    private void renderPackage(StringBuilder sb) {
        sb.append("/* Generated by Manifold */\n");
        if (!this._package.isEmpty()) {
            sb.append("package ").append(this._package).append(";\n\n");
        }
        sb.append('\n');
        for (String u : this._imports) {
            sb.append("import ").append(u).append(";\n");
        }
    }

    private void renderAnnotation(StringBuilder sb, int indent) {
        this.renderAnnotations(sb, indent, false);
        this.indent(sb, indent);
        this.renderModifiers(sb, this.getModifiers() & 0xFFFFFFFFFFFFFBEFL, false, 1);
        sb.append("@interface ").append(this.getSimpleName()).append(" {\n");
        this.renderClassFeatures(sb, indent + 2);
        this.indent(sb, indent);
        sb.append("}\n\n");
    }

    private void renderEnum(StringBuilder sb, int indent) {
        this.renderAnnotations(sb, indent, false);
        this.indent(sb, indent);
        this.renderModifiers(sb, this.getModifiers() & 0xFFFFFFFFFFFFFFEFL, false, 1);
        sb.append("enum ").append(this.getSimpleName()).append(this.renderClassImplements(sb)).append(" {\n");
        this.renderEnumConstants(sb, indent + 2);
        this.renderClassFeatures(sb, indent + 2);
        this.indent(sb, indent);
        sb.append("}\n\n");
    }

    private void renderEnumConstants(StringBuilder sb, int indent) {
        for (int i = 0; i < this._enumConsts.size(); ++i) {
            SrcField c = this._enumConsts.get(i);
            c.renderAnnotations(sb, indent, false);
            this.indent(sb, indent);
            sb.append(c.getSimpleName());
            if (i == this._enumConsts.size() - 1) {
                sb.append(";\n\n");
                continue;
            }
            sb.append(",\n");
        }
    }

    private void renderClassOrInterface(StringBuilder sb, int indent) {
        this.renderAnnotations(sb, indent, false);
        this.indent(sb, indent);
        this.renderModifiers(sb, false, 1);
        sb.append(this._kind == Kind.Interface ? "interface " : "class ").append(this.getSimpleName()).append(this.renderTypeVars(this._typeVars, sb)).append(this.genClassExtends(sb)).append(this.renderClassImplements(sb)).append(" {\n");
        this.renderClassFeatures(sb, indent + 2);
        this.indent(sb, indent);
        sb.append("}\n\n");
    }

    private void renderRecord(StringBuilder sb, int indent) {
        this.renderAnnotations(sb, indent, false);
        this.indent(sb, indent);
        this.renderModifiers(sb, false, 1);
        sb.append("record ").append(this.getSimpleName()).append(this.renderTypeVars(this._typeVars, sb));
        this.renderRecordParams(sb);
        sb.append(this.renderClassImplements(sb)).append(" {\n");
        this.renderClassFeatures(sb, indent + 2);
        this.indent(sb, indent);
        sb.append("}\n\n");
    }

    private StringBuilder renderRecordParams(StringBuilder sb) {
        AbstractSrcMethod ctor = this.findPrimaryConstructor();
        ctor.renderParameters(sb);
        return sb;
    }

    public AbstractSrcMethod findPrimaryConstructor() {
        return this._methods.stream().filter(c -> c.isPrimaryConstructor()).findFirst().orElse(this._constructors.stream().filter(m -> m.isPrimaryConstructor()).findFirst().orElse(null));
    }

    private void renderClassFeatures(StringBuilder sb, int indent) {
        this.renderFields(sb, indent);
        this.renderConstructors(sb, indent);
        this.renderProperties(sb, indent);
        this.renderMethods(sb, indent);
        this.renderInnerClasses(sb, indent);
        this.renderStaticBlocks(sb, indent);
    }

    private String renderClassImplements(StringBuilder sb) {
        if (this._interfaces.size() == 0) {
            return "";
        }
        if (this.getKind() == Kind.Interface) {
            sb.append(" extends ");
        } else {
            sb.append(" implements ");
        }
        for (int i = 0; i < this._interfaces.size(); ++i) {
            SrcType iface = this._interfaces.get(i);
            sb.append(i > 0 ? ", " : "");
            iface.render(sb, 0);
        }
        return "";
    }

    private String genClassExtends(StringBuilder sb) {
        if (this._superClass == null) {
            return "";
        }
        sb.append(" extends ");
        this._superClass.render(sb, 0);
        return "";
    }

    private void renderFields(StringBuilder sb, int indent) {
        for (SrcField field : this._fields) {
            if (this._kind == Kind.Record && !Modifier.isStatic((int)field.getModifiers())) {
                return;
            }
            field.render(sb, indent);
        }
    }

    private void renderMethods(StringBuilder sb, int indent) {
        for (AbstractSrcMethod method : this._methods) {
            method.render(sb, indent);
        }
    }

    private void renderStaticBlocks(StringBuilder sb, int indent) {
        for (SrcStatementBlock block : this._staticBlocks) {
            sb.append("\n").append(this.indent(sb, indent)).append("static {");
            block.render(sb, indent);
            sb.append("\n").append(this.indent(sb, indent)).append("}");
        }
    }

    private void renderConstructors(StringBuilder sb, int indent) {
        for (SrcConstructor ctor : this._constructors) {
            ctor.render(sb, indent);
        }
    }

    private void renderProperties(StringBuilder sb, int indent) {
        boolean separator = false;
        for (Map.Entry<String, SrcGetProperty> entry : this._getProperties.entrySet()) {
            entry.getValue().render(sb, indent);
            SrcSetProperty srcSetProperty = this._setProperties.get(entry.getKey());
            if (srcSetProperty != null) {
                srcSetProperty.render(sb, indent);
            }
            separator = true;
        }
        if (separator) {
            sb.append("\n");
            separator = false;
        }
        for (Map.Entry<String, AbstractSrcMethod> entry : this._setProperties.entrySet()) {
            SrcGetProperty srcGetProperty = this._getProperties.get(entry.getKey());
            if (srcGetProperty != null) continue;
            ((SrcSetProperty)entry.getValue()).render(sb, indent);
            separator = true;
        }
        if (separator) {
            sb.append("\n");
        }
    }

    private void renderInnerClasses(StringBuilder sb, int indent) {
        for (AbstractSrcClass innerClass : this._innerClasses) {
            innerClass.render(sb, indent, false);
        }
    }

    public static enum Kind {
        Class,
        Interface,
        Annotation,
        Enum,
        Record;


        public static Kind from(ElementKind kind) {
            switch (kind) {
                case ENUM: {
                    return Enum;
                }
                case CLASS: {
                    return Class;
                }
                case ANNOTATION_TYPE: {
                    return Annotation;
                }
                case INTERFACE: {
                    return Interface;
                }
            }
            if (kind.name().equals("RECORD")) {
                return Record;
            }
            throw new IllegalArgumentException("Unhandled kind: " + (Object)((Object)kind));
        }

        public static Kind from(Tree.Kind kind) {
            switch (kind) {
                case ENUM: {
                    return Enum;
                }
                case CLASS: {
                    return Class;
                }
                case ANNOTATION_TYPE: {
                    return Annotation;
                }
                case INTERFACE: {
                    return Interface;
                }
            }
            if (kind.name().equals("RECORD")) {
                return Record;
            }
            throw new IllegalArgumentException("Unhandled kind: " + (Object)((Object)kind));
        }
    }
}

