/*
 * Decompiled with CFR 0.152.
 */
package manifold.util.concurrent;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class LockingLazyVar<T> {
    private static final Object NULL = new Object();
    private volatile T _val = null;
    private final ReadWriteLock _rwLock;

    protected LockingLazyVar() {
        this(new ReentrantReadWriteLock());
    }

    protected LockingLazyVar(ReadWriteLock lock) {
        this._rwLock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get() {
        T result;
        Lock rLock = this._rwLock.readLock();
        rLock.lock();
        try {
            result = this._val;
        }
        finally {
            rLock.unlock();
        }
        if (result == NULL) {
            return null;
        }
        if (result != null) {
            return result;
        }
        Lock wLock = this._rwLock.writeLock();
        wLock.lock();
        try {
            result = this._val;
            if (result == NULL) {
                T t = null;
                return t;
            }
            if (result == null) {
                result = this.init();
                this._val = result == null ? NULL : result;
            }
        }
        finally {
            wLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T set(T value) {
        if (value == null) {
            value = NULL;
        }
        T prev = this.get();
        Lock wLock = this._rwLock.writeLock();
        wLock.lock();
        try {
            this._val = value;
        }
        finally {
            wLock.unlock();
        }
        return prev;
    }

    protected abstract T init();

    public final T clear() {
        T prev;
        Lock wLock = this._rwLock.writeLock();
        wLock.lock();
        try {
            prev = this._val;
            this._val = null;
        }
        finally {
            wLock.unlock();
        }
        return prev;
    }

    public final void clearNoLock() {
        this._val = null;
    }

    public boolean isLoaded() {
        Lock rLock = this._rwLock.readLock();
        rLock.lock();
        try {
            boolean bl = this._val != null;
            return bl;
        }
        finally {
            rLock.unlock();
        }
    }

    public static <Q> LockingLazyVar<Q> make(final LazyVarInit<Q> init) {
        return new LockingLazyVar<Q>(){

            @Override
            protected Q init() {
                return init.init();
            }
        };
    }

    public static <Q> LockingLazyVar<Q> make(ReadWriteLock lock, final LazyVarInit<Q> init) {
        return new LockingLazyVar<Q>(lock){

            @Override
            protected Q init() {
                return init.init();
            }
        };
    }

    public static interface LazyVarInit<Q> {
        public Q init();
    }
}

