/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractPrimaryUnit;
import manifold.science.api.UnitCache;
import manifold.science.measures.AccelerationUnit;
import manifold.science.measures.AreaUnit;
import manifold.science.measures.DensityUnit;
import manifold.science.measures.ForceUnit;
import manifold.science.measures.Mass;
import manifold.science.measures.MetricScaleUnit;
import manifold.science.measures.MomentumUnit;
import manifold.science.measures.PressureUnit;
import manifold.science.measures.VelocityUnit;
import manifold.science.measures.VolumeUnit;
import manifold.science.util.CoercionConstants;
import manifold.science.util.Rational;

public final class MassUnit
extends AbstractPrimaryUnit<Mass, MassUnit> {
    private static final UnitCache<MassUnit> CACHE = new UnitCache();
    public static final MassUnit AtomicMass = MassUnit.get(CoercionConstants.r.postfixBind("1.6605402e-27"), "AMU", "amu");
    public static final MassUnit Nano = MassUnit.get(MetricScaleUnit.p.postfixBind(1), "Nanogram", "\u00b5g");
    public static final MassUnit Micro = MassUnit.get(MetricScaleUnit.n.postfixBind(1), "Microgram", "\u00b5g");
    public static final MassUnit Milli = MassUnit.get(MetricScaleUnit.u.postfixBind(1), "Milligram", "mg");
    public static final MassUnit Gram = MassUnit.get(MetricScaleUnit.m.postfixBind(1), "Gram", "g");
    public static final MassUnit Kilogram = MassUnit.get(CoercionConstants.r.postfixBind(1), "Kilogram", "kg");
    public static final MassUnit Tonne = MassUnit.get(MetricScaleUnit.k.postfixBind(1), "Metric Ton", "tonne");
    public static final MassUnit Carat = MassUnit.get(CoercionConstants.r.postfixBind("0.0002"), "Carat", "ct");
    public static final MassUnit Dram = MassUnit.get(CoercionConstants.r.postfixBind("0.001771845195312"), "Dram", "dr");
    public static final MassUnit Grain = MassUnit.get(CoercionConstants.r.postfixBind("6.47989e-5"), "Grain", "gr");
    public static final MassUnit Newton = MassUnit.get(CoercionConstants.r.postfixBind("0.101971621"), "Newton", "N");
    public static final MassUnit Ounce = MassUnit.get(CoercionConstants.r.postfixBind("0.0283495"), "Ounce", "oz");
    public static final MassUnit TroyOunce = MassUnit.get(CoercionConstants.r.postfixBind("0.0311035"), "Troy Ounce", "ozt");
    public static final MassUnit Pound = MassUnit.get(CoercionConstants.r.postfixBind("0.45359237"), "Pound", "lb");
    public static final MassUnit Slug = MassUnit.get(CoercionConstants.r.postfixBind("14.593902937"), "Slug", "slug");
    public static final MassUnit Stone = MassUnit.get(CoercionConstants.r.postfixBind("6.35029"), "Stone", "st");
    public static final MassUnit Ton = MassUnit.get(CoercionConstants.r.postfixBind("907.185"), "Ton (US, short)", "sht");
    public static final MassUnit TonUK = MassUnit.get(CoercionConstants.r.postfixBind("1016.05"), "Ton (UK, long)", "lt");
    public static final MassUnit Solar = MassUnit.get(CoercionConstants.r.postfixBind("1.9889200011445836e30"), "Solar Masses", "M\u2609");
    public static final MassUnit BASE = Kilogram;

    public static MassUnit get(Rational kilogramFactor, String name, String symbol) {
        return (MassUnit)CACHE.get(new MassUnit(kilogramFactor, name, symbol));
    }

    private MassUnit(Rational kilogramFactor, String name, String symbol) {
        super(kilogramFactor, name, symbol);
    }

    @Override
    public Mass makeDimension(Number amount) {
        return new Mass(Rational.get(amount), this);
    }

    public MomentumUnit times(VelocityUnit velocity) {
        return MomentumUnit.get(this, velocity);
    }

    public ForceUnit times(AccelerationUnit acc) {
        return ForceUnit.get(this, acc);
    }

    public PressureUnit div(AreaUnit area) {
        return PressureUnit.get(this, area);
    }

    public AreaUnit div(PressureUnit pressure) {
        return pressure.getAreaUnit();
    }

    public DensityUnit div(VolumeUnit volume) {
        return DensityUnit.get(this, volume);
    }

    public VolumeUnit div(DensityUnit d) {
        return d.getVolumeUnit();
    }
}

