/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.api;

import manifold.science.api.AbstractBinaryUnit;
import manifold.science.api.Dimension;
import manifold.science.api.Unit;
import manifold.science.util.Rational;

public abstract class AbstractProductUnit<A extends Unit, B extends Unit, D extends Dimension<D>, U extends AbstractProductUnit<A, B, D, U>>
extends AbstractBinaryUnit<A, B, D, U> {
    protected AbstractProductUnit(A leftUnit, B rightUnit) {
        this(leftUnit, rightUnit, null, null, null);
    }

    protected AbstractProductUnit(A leftUnit, B rightUnit, Rational factor) {
        this(leftUnit, rightUnit, factor, null, null);
    }

    protected AbstractProductUnit(A leftUnit, B rightUnit, Rational factor, String name) {
        this(leftUnit, rightUnit, factor, name, null);
    }

    protected AbstractProductUnit(A leftUnit, B rightUnit, Rational factor, String name, String symbol) {
        super(leftUnit, rightUnit, factor, name, symbol);
    }

    @Override
    public String getName() {
        String unitName = super.getName();
        return unitName == null ? this.getLeftUnit().getName() + " " + this.getRightUnit().getName() : unitName;
    }

    @Override
    public String getSymbol() {
        String unitSymbol = super.getSymbol();
        return unitSymbol == null ? this.getLeftUnit().getSymbol() + "\u22c5" + this.getRightUnit().getSymbol() : unitSymbol;
    }

    @Override
    public String getFullName() {
        return this.getLeftUnit().getFullName() + " " + this.getRightUnit().getFullName();
    }

    @Override
    public String getFullSymbol() {
        return this.getLeftUnit().getFullSymbol() + "\u22c5" + this.getRightUnit().getFullSymbol();
    }

    @Override
    public Rational toBaseUnits(Rational myUnits) {
        return this.getLeftUnit().toBaseUnits(Rational.ONE).times(this.getRightUnit().toBaseUnits(Rational.ONE)).times(myUnits).times(this.getFactor());
    }

    @Override
    public Rational toNumber() {
        return this.getLeftUnit().toNumber().times(this.getRightUnit().toNumber());
    }

    public B div(A a) {
        return this.getRightUnit();
    }
}

