/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.parser.Tokens;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaFileObject;
import manifold.api.util.fingerprint.Fingerprint;
import manifold.internal.javac.HostKind;
import manifold.internal.javac.JavacPlugin;

public class FragmentProcessor {
    public static final String FRAGMENT_START = "[>";
    public static final String FRAGMENT_END = "<]";
    public static final char SCHEMA_NAME_SEPARATOR = ':';
    private static final FragmentProcessor INSTANCE = new FragmentProcessor();
    public static final String ANONYMOUS_FRAGMENT_PREFIX = "Fragment_";

    public static FragmentProcessor instance() {
        return INSTANCE;
    }

    void processComment(JavaFileObject sourceFile, int pos, String comment, Tokens.Comment.CommentStyle style) {
        Fragment f = this.parseFragment(pos, comment, HostKind.from(style));
        if (f != null) {
            JavacPlugin.instance().registerType(sourceFile, f.getScope(), f.getOffset(), f.getName(), f.getExt(), f.getHostKind(), f._content);
        }
    }

    void processString(JavaFileObject sourceFile, int pos, String chars) {
        Fragment f = this.parseFragment(pos, chars, chars.length() > 3 && chars.charAt(1) == '\"' ? HostKind.TEXT_BLOCK_LITERAL : HostKind.DOUBLE_QUOTE_LITERAL);
        if (f != null) {
            JavacPlugin.instance().registerType(sourceFile, f.getScope(), f.getOffset(), f.getName(), f.getExt(), f.getHostKind(), f._content);
        }
    }

    public Fragment parseFragment(int pos, String chars, HostKind hostKind) {
        int index = 0;
        int end = chars.length();
        boolean isString = false;
        switch (hostKind) {
            case LINE_COMMENT: {
                index += 2;
                break;
            }
            case BLOCK_COMMENT: {
                index += 2;
                end -= 2;
                break;
            }
            case JAVADOC_COMMENT: {
                index += 3;
                end -= 2;
                break;
            }
            case DOUBLE_QUOTE_LITERAL: {
                isString = true;
                ++index;
                --end;
                break;
            }
            case TEXT_BLOCK_LITERAL: {
                isString = true;
                index += 3;
                end -= 3;
            }
        }
        index = this.skipSpaces(chars, index, end);
        if (index + 1 >= end) {
            return null;
        }
        if (FRAGMENT_START.charAt(0) == chars.charAt(index++) && FRAGMENT_START.charAt(1) == chars.charAt(index++)) {
            index = this.skipSpaces(chars, index, end);
            String name = isString && index < end && chars.charAt(index) == '.' ? "" : this.parseName(chars, index, end);
            if (name != null) {
                index += name.length();
                ArrayList<String> exts = new ArrayList<String>();
                if ((index = this.parseExtensions(chars, index, end, exts)) < end && !exts.isEmpty() && (index = this.skipSpaces(chars, index, end)) < end) {
                    String schema = null;
                    if (':' == chars.charAt(index)) {
                        ++index;
                        index += (schema = this.parseName(chars, index = this.skipSpaces(chars, index, end), end)) == null ? 0 : schema.length();
                        index = this.skipSpaces(chars, index, end);
                    }
                    if (index + 1 < end && FRAGMENT_END.charAt(0) == chars.charAt(index++) && FRAGMENT_END.charAt(1) == chars.charAt(index++)) {
                        String content = chars.substring(index, end);
                        name = isString ? this.handleAnonymousName(name, content) : name;
                        return new Fragment(pos + index, schema, this.makeBaseName(name, exts), (String)exts.get(exts.size() - 1), hostKind, content);
                    }
                }
            }
        }
        return null;
    }

    private String handleAnonymousName(String name, String content) {
        if (name.isEmpty()) {
            Fingerprint fingerprint = new Fingerprint(content);
            String suffix = fingerprint.toString();
            suffix = suffix.replace('-', '_');
            name = ANONYMOUS_FRAGMENT_PREFIX + suffix;
        }
        return name;
    }

    private int parseExtensions(String comment, int index, int end, List<String> exts) {
        String ext;
        while (index < end && '.' == comment.charAt(index) && (ext = this.parseName(comment, ++index, end)) != null) {
            exts.add(ext);
            index += ext.length();
        }
        return index;
    }

    private String makeBaseName(String name, List<String> exts) {
        StringBuilder sb = new StringBuilder(name);
        for (int i = 0; i < exts.size() - 1; ++i) {
            sb.append('.').append(exts.get(i));
        }
        return sb.toString();
    }

    private String parseName(String comment, int index, int end) {
        char c;
        StringBuilder sb = new StringBuilder();
        int start = index;
        while (index < end && (index == start ? Character.isJavaIdentifierStart(c = comment.charAt(index)) : Character.isJavaIdentifierPart(c = comment.charAt(index)))) {
            ++index;
            sb.append(c);
        }
        return index == start || index == end ? null : sb.toString();
    }

    private int skipSpaces(String comment, int index, int end) {
        while (index < end && Character.isWhitespace(comment.charAt(index))) {
            ++index;
        }
        return index;
    }

    public static class Fragment {
        private final int _offset;
        private final String _scope;
        private final String _name;
        private final String _ext;
        private final String _content;
        private final HostKind _hostKind;

        Fragment(int offset, String scope, String name, String ext, HostKind hostKind, String content) {
            this._offset = offset;
            this._scope = scope;
            this._name = name;
            this._ext = ext;
            this._hostKind = hostKind;
            this._content = content;
        }

        public int getOffset() {
            return this._offset;
        }

        public String getScope() {
            return this._scope;
        }

        public String getName() {
            return this._name;
        }

        public String getExt() {
            return this._ext;
        }

        public HostKind getHostKind() {
            return this._hostKind;
        }

        public String getContent() {
            return this._content;
        }
    }
}

