/*
 * Decompiled with CFR 0.152.
 */
package manifold.csv.rt.parser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import manifold.csv.rt.parser.CsvDataSet;
import manifold.csv.rt.parser.CsvField;
import manifold.csv.rt.parser.CsvHeader;
import manifold.csv.rt.parser.CsvRecord;
import manifold.csv.rt.parser.CsvToken;
import manifold.csv.rt.parser.CsvTokenizer;
import manifold.rt.api.util.StreamUtil;

public class CsvParser {
    private final CsvTokenizer _tokenizer;

    public static CsvDataSet parse(InputStream inputStream) {
        return new CsvParser(inputStream).parse();
    }

    private CsvParser(InputStream inputStream) {
        try {
            String content = StreamUtil.getContent(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            this._tokenizer = new CsvTokenizer(content);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private CsvDataSet parse() {
        return new CsvDataSet(this.parseHeader(), this.parseRecords(), this._tokenizer.getTypes());
    }

    private List<CsvRecord> parseRecords() {
        ArrayList<CsvRecord> records = new ArrayList<CsvRecord>();
        ArrayList<CsvField> fields = new ArrayList<CsvField>();
        while (true) {
            CsvToken token = this._tokenizer.nextToken();
            fields.add(new CsvField(token));
            if (!token.isLastInRecord()) continue;
            records.add(new CsvRecord(fields));
            if (token.isEof()) break;
            fields = new ArrayList();
        }
        return records;
    }

    private CsvHeader parseHeader() {
        if (this._tokenizer.hasHeader()) {
            CsvToken token;
            ArrayList<CsvField> fields = new ArrayList<CsvField>();
            do {
                token = this._tokenizer.nextToken();
                fields.add(new CsvField(token));
            } while (!token.isLastInRecord());
            return new CsvHeader(fields);
        }
        return null;
    }
}

