/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Internal;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Field;
import graphql.language.Node;
import graphql.language.NullValue;
import graphql.language.Value;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLTypeUtil;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public class ProvidedNonNullArguments
extends AbstractRule {
    public ProvidedNonNullArguments(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkField(Field field) {
        GraphQLFieldDefinition fieldDef = this.getValidationContext().getFieldDef();
        if (fieldDef == null) {
            return;
        }
        Map<String, Argument> argumentMap = this.argumentMap(field.getArguments());
        for (GraphQLArgument graphQLArgument : fieldDef.getArguments()) {
            Value value;
            Argument argument = argumentMap.get(graphQLArgument.getName());
            boolean nonNullType = GraphQLTypeUtil.isNonNull(graphQLArgument.getType());
            boolean noDefaultValue = graphQLArgument.getArgumentDefaultValue().isNotSet();
            if (argument == null && nonNullType && noDefaultValue) {
                String message = String.format("Missing field argument %s", graphQLArgument.getName());
                this.addError(ValidationErrorType.MissingFieldArgument, field.getSourceLocation(), message);
            }
            if (argument == null || (value = argument.getValue()) != null && !(value instanceof NullValue) || !nonNullType || !noDefaultValue) continue;
            String message = String.format("null value for non-null field argument %s", graphQLArgument.getName());
            this.addError(ValidationErrorType.NullValueForNonNullArgument, field.getSourceLocation(), message);
        }
    }

    @Override
    public void checkDirective(Directive directive, List<Node> ancestors) {
        GraphQLDirective graphQLDirective = this.getValidationContext().getDirective();
        if (graphQLDirective == null) {
            return;
        }
        Map<String, Argument> argumentMap = this.argumentMap(directive.getArguments());
        for (GraphQLArgument graphQLArgument : graphQLDirective.getArguments()) {
            Argument argument = argumentMap.get(graphQLArgument.getName());
            boolean nonNullType = GraphQLTypeUtil.isNonNull(graphQLArgument.getType());
            boolean noDefaultValue = graphQLArgument.getArgumentDefaultValue().isNotSet();
            if (argument != null || !nonNullType || !noDefaultValue) continue;
            String message = String.format("Missing directive argument %s", graphQLArgument.getName());
            this.addError(ValidationErrorType.MissingDirectiveArgument, directive.getSourceLocation(), message);
        }
    }

    private Map<String, Argument> argumentMap(List<Argument> arguments) {
        LinkedHashMap<String, Argument> result = new LinkedHashMap<String, Argument>();
        for (Argument argument : arguments) {
            result.put(argument.getName(), argument);
        }
        return result;
    }
}

