/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.validation;

import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.ValuesResolver;
import graphql.language.AstPrinter;
import graphql.language.Value;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLImplementingType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.GraphQLUnionType;
import graphql.schema.validation.SchemaValidationError;
import graphql.schema.validation.SchemaValidationErrorCollector;
import graphql.schema.validation.SchemaValidationErrorType;
import graphql.util.FpKit;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Internal
public class TypesImplementInterfaces
extends GraphQLTypeVisitorStub {
    private static final Map<Class<? extends GraphQLImplementingType>, String> TYPE_OF_MAP = new HashMap<Class<? extends GraphQLImplementingType>, String>();

    @Override
    public TraversalControl visitGraphQLObjectType(GraphQLObjectType type, TraverserContext<GraphQLSchemaElement> context) {
        SchemaValidationErrorCollector validationErrorCollector = context.getVarFromParents(SchemaValidationErrorCollector.class);
        this.check(type, validationErrorCollector);
        return TraversalControl.CONTINUE;
    }

    @Override
    public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType type, TraverserContext<GraphQLSchemaElement> context) {
        SchemaValidationErrorCollector validationErrorCollector = context.getVarFromParents(SchemaValidationErrorCollector.class);
        this.check(type, validationErrorCollector);
        return TraversalControl.CONTINUE;
    }

    private void check(GraphQLImplementingType implementingType, SchemaValidationErrorCollector validationErrorCollector) {
        List<GraphQLNamedOutputType> interfaces = implementingType.getInterfaces();
        interfaces.forEach(interfaceType -> this.checkObjectImplementsInterface(implementingType, (GraphQLInterfaceType)interfaceType, validationErrorCollector));
    }

    private void checkObjectImplementsInterface(GraphQLImplementingType implementingType, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector) {
        List<GraphQLFieldDefinition> fieldDefinitions = interfaceType.getFieldDefinitions();
        for (GraphQLFieldDefinition interfaceFieldDef : fieldDefinitions) {
            GraphQLFieldDefinition objectFieldDef = implementingType.getFieldDefinition(interfaceFieldDef.getName());
            if (objectFieldDef == null) {
                validationErrorCollector.addError(this.error(String.format("%s type '%s' does not implement interface '%s' because field '%s' is missing", TYPE_OF_MAP.get(implementingType.getClass()), implementingType.getName(), interfaceType.getName(), interfaceFieldDef.getName())));
                continue;
            }
            this.checkFieldTypeCompatibility(implementingType, interfaceType, validationErrorCollector, interfaceFieldDef, objectFieldDef);
        }
        this.checkTransitiveImplementations(implementingType, interfaceType, validationErrorCollector);
    }

    private void checkTransitiveImplementations(GraphQLImplementingType implementingType, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector) {
        List<GraphQLNamedOutputType> implementedInterfaces = implementingType.getInterfaces();
        interfaceType.getInterfaces().forEach(transitiveInterface -> {
            if (transitiveInterface.equals(implementingType)) {
                validationErrorCollector.addError(this.error(String.format("%s type '%s' cannot implement '%s' because that would result on a circular reference", TYPE_OF_MAP.get(implementingType.getClass()), implementingType.getName(), interfaceType.getName())));
            } else if (!implementedInterfaces.contains(transitiveInterface)) {
                validationErrorCollector.addError(this.error(String.format("%s type '%s' must implement '%s' because it is implemented by '%s'", TYPE_OF_MAP.get(implementingType.getClass()), implementingType.getName(), transitiveInterface.getName(), interfaceType.getName())));
            }
        });
    }

    private void checkFieldTypeCompatibility(GraphQLImplementingType implementingType, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector, GraphQLFieldDefinition interfaceFieldDef, GraphQLFieldDefinition objectFieldDef) {
        String interfaceFieldDefStr = GraphQLTypeUtil.simplePrint(interfaceFieldDef.getType());
        String objectFieldDefStr = GraphQLTypeUtil.simplePrint(objectFieldDef.getType());
        if (!this.isCompatible(interfaceFieldDef.getType(), objectFieldDef.getType())) {
            validationErrorCollector.addError(this.error(String.format("%s type '%s' does not implement interface '%s' because field '%s' is defined as '%s' type and not as '%s' type", TYPE_OF_MAP.get(implementingType.getClass()), implementingType.getName(), interfaceType.getName(), interfaceFieldDef.getName(), objectFieldDefStr, interfaceFieldDefStr)));
        } else {
            this.checkFieldArgumentEquivalence(implementingType, interfaceType, validationErrorCollector, interfaceFieldDef, objectFieldDef);
        }
    }

    private void checkFieldArgumentEquivalence(GraphQLImplementingType implementingType, GraphQLInterfaceType interfaceType, SchemaValidationErrorCollector validationErrorCollector, GraphQLFieldDefinition interfaceFieldDef, GraphQLFieldDefinition objectFieldDef) {
        List<GraphQLArgument> interfaceArgs = interfaceFieldDef.getArguments();
        List<GraphQLArgument> objectArgs = objectFieldDef.getArguments();
        Map<String, GraphQLArgument> interfaceArgsByName = FpKit.getByName(interfaceArgs, GraphQLArgument::getName);
        ImmutableList<String> objectArgsNames = ImmutableKit.map(objectArgs, GraphQLArgument::getName);
        if (!objectArgsNames.containsAll(interfaceArgsByName.keySet())) {
            String missingArgsNames = interfaceArgsByName.keySet().stream().filter(name -> !objectArgsNames.contains(name)).collect(Collectors.joining(", "));
            validationErrorCollector.addError(this.error(String.format("%s type '%s' does not implement interface '%s' because field '%s' is missing argument(s): '%s'", TYPE_OF_MAP.get(implementingType.getClass()), implementingType.getName(), interfaceType.getName(), interfaceFieldDef.getName(), missingArgsNames)));
        } else {
            objectArgs.forEach(objectArg -> {
                GraphQLArgument interfaceArg = (GraphQLArgument)interfaceArgsByName.get(objectArg.getName());
                if (interfaceArg == null) {
                    if (objectArg.getType() instanceof GraphQLNonNull) {
                        validationErrorCollector.addError(this.error(String.format("%s type '%s' field '%s' defines an additional non-optional argument '%s' which is not allowed because field is also defined in interface '%s'", TYPE_OF_MAP.get(implementingType.getClass()), implementingType.getName(), objectFieldDef.getName(), objectArg.getName(), interfaceType.getName())));
                    }
                } else {
                    String interfaceArgStr = this.makeArgStr((GraphQLArgument)objectArg);
                    String objectArgStr = this.makeArgStr(interfaceArg);
                    boolean same = true;
                    if (!interfaceArgStr.equals(objectArgStr)) {
                        same = false;
                    }
                    if (objectArg.hasSetDefaultValue() && interfaceArg.hasSetDefaultValue()) {
                        Value<?> objectDefaultValue = ValuesResolver.valueToLiteral(objectArg.getArgumentDefaultValue(), objectArg.getType());
                        Value<?> interfaceDefaultValue = ValuesResolver.valueToLiteral(interfaceArg.getArgumentDefaultValue(), interfaceArg.getType());
                        if (!Objects.equals(AstPrinter.printAst(objectDefaultValue), AstPrinter.printAst(interfaceDefaultValue))) {
                            same = false;
                        }
                    } else if (objectArg.hasSetDefaultValue() || interfaceArg.hasSetDefaultValue()) {
                        same = false;
                    }
                    if (!same) {
                        validationErrorCollector.addError(this.error(String.format("%s type '%s' does not implement interface '%s' because field '%s' argument '%s' is defined differently", TYPE_OF_MAP.get(implementingType.getClass()), implementingType.getName(), interfaceType.getName(), interfaceFieldDef.getName(), objectArg.getName())));
                    }
                }
            });
        }
    }

    private String makeArgStr(GraphQLArgument argument) {
        return argument.getName() + ":" + GraphQLTypeUtil.simplePrint(argument.getType());
    }

    private SchemaValidationError error(String msg) {
        return new SchemaValidationError(SchemaValidationErrorType.ObjectDoesNotImplementItsInterfaces, msg);
    }

    boolean isCompatible(GraphQLOutputType constraintType, GraphQLOutputType objectType) {
        if (this.isSameType(constraintType, objectType)) {
            return true;
        }
        if (constraintType instanceof GraphQLUnionType) {
            return this.objectIsMemberOfUnion((GraphQLUnionType)constraintType, objectType);
        }
        if (constraintType instanceof GraphQLInterfaceType && objectType instanceof GraphQLObjectType) {
            return this.objectImplementsInterface((GraphQLInterfaceType)constraintType, (GraphQLObjectType)objectType);
        }
        if (constraintType instanceof GraphQLInterfaceType && objectType instanceof GraphQLInterfaceType) {
            return this.interfaceImplementsInterface((GraphQLInterfaceType)constraintType, (GraphQLInterfaceType)objectType);
        }
        if (GraphQLTypeUtil.isList(constraintType) && GraphQLTypeUtil.isList(objectType)) {
            GraphQLOutputType wrappedConstraintType = (GraphQLOutputType)GraphQLTypeUtil.unwrapOne(constraintType);
            GraphQLOutputType wrappedObjectType = (GraphQLOutputType)GraphQLTypeUtil.unwrapOne(objectType);
            return this.isCompatible(wrappedConstraintType, wrappedObjectType);
        }
        if (GraphQLTypeUtil.isNonNull(objectType)) {
            GraphQLOutputType nullableConstraint = GraphQLTypeUtil.isNonNull(constraintType) ? (GraphQLOutputType)GraphQLTypeUtil.unwrapOne(constraintType) : constraintType;
            GraphQLOutputType nullableObjectType = (GraphQLOutputType)GraphQLTypeUtil.unwrapOne(objectType);
            return this.isCompatible(nullableConstraint, nullableObjectType);
        }
        return false;
    }

    boolean isSameType(GraphQLOutputType a, GraphQLOutputType b) {
        String aDefString = GraphQLTypeUtil.simplePrint(a);
        String bDefString = GraphQLTypeUtil.simplePrint(b);
        return aDefString.equals(bDefString);
    }

    boolean objectImplementsInterface(GraphQLInterfaceType interfaceType, GraphQLObjectType objectType) {
        return objectType.getInterfaces().contains(interfaceType);
    }

    boolean interfaceImplementsInterface(GraphQLInterfaceType interfaceType, GraphQLInterfaceType implementingType) {
        return implementingType.getInterfaces().contains(interfaceType);
    }

    boolean objectIsMemberOfUnion(GraphQLUnionType unionType, GraphQLOutputType objectType) {
        return unionType.getTypes().contains(objectType);
    }

    static {
        TYPE_OF_MAP.put(GraphQLObjectType.class, "object");
        TYPE_OF_MAP.put(GraphQLInterfaceType.class, "interface");
    }
}

