/*
 * Decompiled with CFR 0.152.
 */
package graphql.normalized;

import graphql.Internal;
import graphql.language.Argument;
import graphql.language.AstComparator;
import graphql.normalized.ExecutableNormalizedField;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLNamedOutputType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Internal
public class ENFMerger {
    public static void merge(ExecutableNormalizedField parent, List<ExecutableNormalizedField> childrenWithSameResultKey, GraphQLSchema schema) {
        ArrayList possibleGroupsToMerge = new ArrayList();
        for (ExecutableNormalizedField executableNormalizedField : childrenWithSameResultKey) {
            boolean addToGroup = false;
            block1: for (Set set2 : possibleGroupsToMerge) {
                for (ExecutableNormalizedField fieldInGroup : set2) {
                    if (!executableNormalizedField.getFieldName().equals(fieldInGroup.getFieldName()) || !ENFMerger.sameArguments(executableNormalizedField.getAstArguments(), fieldInGroup.getAstArguments()) || !ENFMerger.isFieldInSharedInterface(executableNormalizedField, fieldInGroup, schema)) continue;
                    addToGroup = true;
                    set2.add(executableNormalizedField);
                    continue block1;
                }
            }
            if (addToGroup) continue;
            LinkedHashSet<ExecutableNormalizedField> group = new LinkedHashSet<ExecutableNormalizedField>();
            group.add(executableNormalizedField);
            possibleGroupsToMerge.add(group);
        }
        for (Set set3 : possibleGroupsToMerge) {
            ArrayList<Set<ExecutableNormalizedField>> listOfChildrenForGroup = new ArrayList<Set<ExecutableNormalizedField>>();
            for (ExecutableNormalizedField executableNormalizedField : set3) {
                LinkedHashSet<ExecutableNormalizedField> childrenSets = new LinkedHashSet<ExecutableNormalizedField>(executableNormalizedField.getChildren());
                listOfChildrenForGroup.add(childrenSets);
            }
            boolean mergeable = ENFMerger.areFieldSetsTheSame(listOfChildrenForGroup);
            if (!mergeable) continue;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            set3.forEach(f -> mergedObjects.addAll(f.getObjectTypeNames()));
            Iterator iterator = set3.iterator();
            ExecutableNormalizedField first = (ExecutableNormalizedField)iterator.next();
            while (iterator.hasNext()) {
                parent.getChildren().remove(iterator.next());
            }
            first.setObjectTypeNames(linkedHashSet);
        }
    }

    private static boolean isFieldInSharedInterface(ExecutableNormalizedField fieldOne, ExecutableNormalizedField fieldTwo, GraphQLSchema schema) {
        String firstObject = fieldOne.getSingleObjectTypeName();
        String secondObject = fieldTwo.getSingleObjectTypeName();
        String fieldName = fieldOne.getFieldName();
        GraphQLObjectType objectTypeOne = schema.getObjectType(firstObject);
        GraphQLObjectType objectTypeTwo = schema.getObjectType(secondObject);
        List<GraphQLNamedOutputType> interfacesOne = objectTypeOne.getInterfaces();
        List<GraphQLNamedOutputType> interfacesTwo = objectTypeTwo.getInterfaces();
        Optional<GraphQLInterfaceType> firstInterfaceFound = interfacesOne.stream().filter(singleInterface -> singleInterface.getFieldDefinition(fieldName) != null).findFirst();
        Optional<GraphQLInterfaceType> secondInterfaceFound = interfacesTwo.stream().filter(singleInterface -> singleInterface.getFieldDefinition(fieldName) != null).findFirst();
        if (!firstInterfaceFound.isPresent() || !secondInterfaceFound.isPresent()) {
            return false;
        }
        return firstInterfaceFound.get().getName().equals(secondInterfaceFound.get().getName());
    }

    private static boolean areFieldSetsTheSame(List<Set<ExecutableNormalizedField>> listOfSets) {
        if (listOfSets.size() == 0 || listOfSets.size() == 1) {
            return true;
        }
        Set<ExecutableNormalizedField> first = listOfSets.get(0);
        Iterator<Set<ExecutableNormalizedField>> iterator = listOfSets.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Set<ExecutableNormalizedField> set2 = iterator.next();
            if (ENFMerger.compareTwoFieldSets(first, set2)) continue;
            return false;
        }
        ArrayList<Set<ExecutableNormalizedField>> nextLevel = new ArrayList<Set<ExecutableNormalizedField>>();
        for (Set<ExecutableNormalizedField> set3 : listOfSets) {
            for (ExecutableNormalizedField fieldInSet : set3) {
                nextLevel.add(new LinkedHashSet<ExecutableNormalizedField>(fieldInSet.getChildren()));
            }
        }
        return ENFMerger.areFieldSetsTheSame(nextLevel);
    }

    private static boolean compareTwoFieldSets(Set<ExecutableNormalizedField> setOne, Set<ExecutableNormalizedField> setTwo) {
        if (setOne.size() != setTwo.size()) {
            return false;
        }
        for (ExecutableNormalizedField field : setOne) {
            if (ENFMerger.isContained(field, setTwo)) continue;
            return false;
        }
        return true;
    }

    private static boolean isContained(ExecutableNormalizedField searchFor, Set<ExecutableNormalizedField> set2) {
        for (ExecutableNormalizedField field : set2) {
            if (!ENFMerger.compareWithoutChildren(searchFor, field)) continue;
            return true;
        }
        return false;
    }

    private static boolean compareWithoutChildren(ExecutableNormalizedField one, ExecutableNormalizedField two) {
        if (!one.getObjectTypeNames().equals(two.getObjectTypeNames())) {
            return false;
        }
        if (!Objects.equals(one.getAlias(), two.getAlias())) {
            return false;
        }
        if (!Objects.equals(one.getFieldName(), two.getFieldName())) {
            return false;
        }
        return ENFMerger.sameArguments(one.getAstArguments(), two.getAstArguments());
    }

    private static boolean sameArguments(List<Argument> arguments1, List<Argument> arguments2) {
        if (arguments1.size() != arguments2.size()) {
            return false;
        }
        for (Argument argument : arguments1) {
            Argument matchedArgument = ENFMerger.findArgumentByName(argument.getName(), arguments2);
            if (matchedArgument == null) {
                return false;
            }
            if (AstComparator.sameValue(argument.getValue(), matchedArgument.getValue())) continue;
            return false;
        }
        return true;
    }

    private static Argument findArgumentByName(String name, List<Argument> arguments) {
        for (Argument argument : arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }
}

