/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.PublicSpi;
import graphql.SerializationError;
import graphql.TrivialDataFetcher;
import graphql.TypeMismatchError;
import graphql.UnresolvedTypeError;
import graphql.com.google.common.collect.ImmutableList;
import graphql.execution.AbortExecutionException;
import graphql.execution.Async;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherResult;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStepInfoFactory;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FetchedValue;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.FieldValueInfo;
import graphql.execution.MergedField;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.ResolveType;
import graphql.execution.ResultPath;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import graphql.execution.UnresolvedTypeException;
import graphql.execution.ValuesResolver;
import graphql.execution.directives.QueryDirectivesImpl;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldParameters;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.normalized.ExecutableNormalizedField;
import graphql.normalized.ExecutableNormalizedOperation;
import graphql.schema.CoercingSerializeException;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.DataFetchingFieldSelectionSet;
import graphql.schema.DataFetchingFieldSelectionSetImpl;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.util.FpKit;
import graphql.util.LogKit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import manifold.shade.org.slf4j.Logger;
import manifold.shade.org.slf4j.LoggerFactory;

@PublicSpi
public abstract class ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(ExecutionStrategy.class);
    private static final Logger logNotSafe = LogKit.getNotPrivacySafeLogger(ExecutionStrategy.class);
    protected final ValuesResolver valuesResolver = new ValuesResolver();
    protected final FieldCollector fieldCollector = new FieldCollector();
    protected final ExecutionStepInfoFactory executionStepInfoFactory = new ExecutionStepInfoFactory();
    private final ResolveType resolvedType = new ResolveType();
    protected final DataFetcherExceptionHandler dataFetcherExceptionHandler;

    protected ExecutionStrategy() {
        this.dataFetcherExceptionHandler = new SimpleDataFetcherExceptionHandler();
    }

    protected ExecutionStrategy(DataFetcherExceptionHandler dataFetcherExceptionHandler) {
        this.dataFetcherExceptionHandler = dataFetcherExceptionHandler;
    }

    public abstract CompletableFuture<ExecutionResult> execute(ExecutionContext var1, ExecutionStrategyParameters var2) throws NonNullableFieldWasNullException;

    protected CompletableFuture<ExecutionResult> resolveField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        return this.resolveFieldWithInfo(executionContext, parameters).thenCompose(FieldValueInfo::getFieldValue);
    }

    protected CompletableFuture<FieldValueInfo> resolveFieldWithInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext, parameters, parameters.getField().getSingleField());
        Supplier<ExecutionStepInfo> executionStepInfo = FpKit.intraThreadMemoize(() -> this.createExecutionStepInfo(executionContext, parameters, fieldDef, null));
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> fieldCtx = instrumentation.beginField(new InstrumentationFieldParameters(executionContext, executionStepInfo));
        CompletableFuture<FetchedValue> fetchFieldFuture = this.fetchField(executionContext, parameters);
        CompletionStage result = fetchFieldFuture.thenApply(fetchedValue -> this.completeField(executionContext, parameters, (FetchedValue)fetchedValue));
        CompletionStage executionResultFuture = ((CompletableFuture)result).thenCompose(FieldValueInfo::getFieldValue);
        fieldCtx.onDispatched((CompletableFuture<ExecutionResult>)executionResultFuture);
        ((CompletableFuture)executionResultFuture).whenComplete(fieldCtx::onCompleted);
        return result;
    }

    protected CompletableFuture<FetchedValue> fetchField(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        CompletableFuture<Object> fetchedValue;
        MergedField field = parameters.getField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field.getSingleField());
        GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
        GraphQLOutputType fieldType = fieldDef.getType();
        Supplier<ExecutionStepInfo> executionStepInfo = FpKit.intraThreadMemoize(() -> this.createExecutionStepInfo(executionContext, parameters, fieldDef, parentType));
        Supplier<Map<String, Object>> argumentValues = () -> ((ExecutionStepInfo)executionStepInfo.get()).getArguments();
        Supplier<ExecutableNormalizedField> normalizedFieldSupplier = this.getNormalizedField(executionContext, parameters, executionStepInfo);
        DataFetchingFieldSelectionSet fieldCollector = DataFetchingFieldSelectionSetImpl.newCollector(executionContext.getGraphQLSchema(), fieldType, normalizedFieldSupplier);
        QueryDirectivesImpl queryDirectives = new QueryDirectivesImpl(field, executionContext.getGraphQLSchema(), executionContext.getVariables());
        DataFetchingEnvironment environment = DataFetchingEnvironmentImpl.newDataFetchingEnvironment(executionContext).source(parameters.getSource()).localContext(parameters.getLocalContext()).arguments(argumentValues).fieldDefinition(fieldDef).mergedField(parameters.getField()).fieldType(fieldType).executionStepInfo(executionStepInfo).parentType(parentType).selectionSet(fieldCollector).queryDirectives(queryDirectives).build();
        DataFetcher<?> dataFetcher = codeRegistry.getDataFetcher(parentType, fieldDef);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldFetchParameters instrumentationFieldFetchParams = new InstrumentationFieldFetchParameters(executionContext, environment, parameters, dataFetcher instanceof TrivialDataFetcher);
        InstrumentationContext<Object> fetchCtx = instrumentation.beginFieldFetch(instrumentationFieldFetchParams);
        dataFetcher = instrumentation.instrumentDataFetcher(dataFetcher, instrumentationFieldFetchParams);
        ExecutionId executionId = executionContext.getExecutionId();
        try {
            Object fetchedValueRaw = dataFetcher.get(environment);
            fetchedValue = Async.toCompletableFuture(fetchedValueRaw);
        }
        catch (Exception e) {
            if (logNotSafe.isDebugEnabled()) {
                logNotSafe.debug(String.format("'%s', field '%s' fetch threw exception", executionId, executionStepInfo.get().getPath()), e);
            }
            fetchedValue = new CompletableFuture();
            fetchedValue.completeExceptionally(e);
        }
        fetchCtx.onDispatched(fetchedValue);
        return ((CompletableFuture)((CompletableFuture)fetchedValue.handle((result, exception) -> {
            fetchCtx.onCompleted(result, (Throwable)exception);
            if (exception != null) {
                return this.handleFetchingException(executionContext, environment, (Throwable)exception);
            }
            return CompletableFuture.completedFuture(result);
        })).thenCompose(Function.identity())).thenApply(result -> this.unboxPossibleDataFetcherResult(executionContext, parameters, result));
    }

    protected Supplier<ExecutableNormalizedField> getNormalizedField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Supplier<ExecutionStepInfo> executionStepInfo) {
        Supplier<ExecutableNormalizedOperation> normalizedQuery = executionContext.getNormalizedQueryTree();
        return () -> ((ExecutableNormalizedOperation)normalizedQuery.get()).getNormalizedField(parameters.getField(), ((ExecutionStepInfo)executionStepInfo.get()).getObjectType(), ((ExecutionStepInfo)executionStepInfo.get()).getPath());
    }

    protected FetchedValue unboxPossibleDataFetcherResult(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        if (result instanceof DataFetcherResult) {
            DataFetcherResult dataFetcherResult = (DataFetcherResult)result;
            executionContext.addErrors(dataFetcherResult.getErrors());
            Object localContext = dataFetcherResult.getLocalContext();
            if (localContext == null) {
                localContext = parameters.getLocalContext();
            }
            return FetchedValue.newFetchedValue().fetchedValue(executionContext.getValueUnboxer().unbox(dataFetcherResult.getData())).rawFetchedValue(dataFetcherResult.getData()).errors(dataFetcherResult.getErrors()).localContext(localContext).build();
        }
        return FetchedValue.newFetchedValue().fetchedValue(executionContext.getValueUnboxer().unbox(result)).rawFetchedValue(result).localContext(parameters.getLocalContext()).build();
    }

    protected <T> CompletableFuture<T> handleFetchingException(ExecutionContext executionContext, DataFetchingEnvironment environment, Throwable e) {
        DataFetcherExceptionHandlerParameters handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(environment).exception(e).build();
        try {
            return this.asyncHandleException(this.dataFetcherExceptionHandler, handlerParameters, executionContext);
        }
        catch (Exception handlerException) {
            handlerParameters = DataFetcherExceptionHandlerParameters.newExceptionParameters().dataFetchingEnvironment(environment).exception(handlerException).build();
            return this.asyncHandleException(new SimpleDataFetcherExceptionHandler(), handlerParameters, executionContext);
        }
    }

    private <T> CompletableFuture<T> asyncHandleException(DataFetcherExceptionHandler handler, DataFetcherExceptionHandlerParameters handlerParameters, ExecutionContext executionContext) {
        return handler.handleException(handlerParameters).thenApply(handlerResult -> DataFetcherResult.newResult().errors(handlerResult.getErrors()).build());
    }

    protected FieldValueInfo completeField(ExecutionContext executionContext, ExecutionStrategyParameters parameters, FetchedValue fetchedValue) {
        Field field = parameters.getField().getSingleField();
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        GraphQLFieldDefinition fieldDef = this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
        ExecutionStepInfo executionStepInfo = this.createExecutionStepInfo(executionContext, parameters, fieldDef, parentType);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, () -> executionStepInfo, fetchedValue);
        InstrumentationContext<ExecutionResult> ctxCompleteField = instrumentation.beginFieldComplete(instrumentationParams);
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, executionStepInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(executionStepInfo).source(fetchedValue.getFetchedValue()).localContext(fetchedValue.getLocalContext()).nonNullFieldValidator(nonNullableFieldValidator));
        if (log.isDebugEnabled()) {
            log.debug("'{}' completing field '{}'...", (Object)executionContext.getExecutionId(), (Object)executionStepInfo.getPath());
        }
        FieldValueInfo fieldValueInfo = this.completeValue(executionContext, newParameters);
        CompletableFuture<ExecutionResult> executionResultFuture = fieldValueInfo.getFieldValue();
        ctxCompleteField.onDispatched(executionResultFuture);
        executionResultFuture.whenComplete(ctxCompleteField::onCompleted);
        return fieldValueInfo;
    }

    protected FieldValueInfo completeValue(ExecutionContext executionContext, ExecutionStrategyParameters parameters) throws NonNullableFieldWasNullException {
        CompletableFuture<ExecutionResult> fieldValue;
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        Object result = executionContext.getValueUnboxer().unbox(parameters.getSource());
        GraphQLOutputType fieldType = executionStepInfo.getUnwrappedNonNullType();
        if (result == null) {
            CompletableFuture<ExecutionResult> fieldValue2 = this.completeValueForNull(executionContext, parameters);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.NULL).fieldValue(fieldValue2).build();
        }
        if (GraphQLTypeUtil.isList(fieldType)) {
            return this.completeValueForList(executionContext, parameters, result);
        }
        if (GraphQLTypeUtil.isScalar(fieldType)) {
            CompletableFuture<ExecutionResult> fieldValue3 = this.completeValueForScalar(executionContext, parameters, (GraphQLScalarType)fieldType, result);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.SCALAR).fieldValue(fieldValue3).build();
        }
        if (GraphQLTypeUtil.isEnum(fieldType)) {
            CompletableFuture<ExecutionResult> fieldValue4 = this.completeValueForEnum(executionContext, parameters, (GraphQLEnumType)fieldType, result);
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.ENUM).fieldValue(fieldValue4).build();
        }
        try {
            GraphQLObjectType resolvedObjectType = this.resolveType(executionContext, parameters, fieldType);
            fieldValue = this.completeValueForObject(executionContext, parameters, resolvedObjectType, result);
        }
        catch (UnresolvedTypeException ex) {
            this.handleUnresolvedTypeProblem(executionContext, parameters, ex);
            parameters.getNonNullFieldValidator().validate(parameters.getPath(), null);
            fieldValue = CompletableFuture.completedFuture(new ExecutionResultImpl(null, null));
        }
        return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.OBJECT).fieldValue(fieldValue).build();
    }

    private void handleUnresolvedTypeProblem(ExecutionContext context, ExecutionStrategyParameters parameters, UnresolvedTypeException e) {
        UnresolvedTypeError error = new UnresolvedTypeError(parameters.getPath(), parameters.getExecutionStepInfo(), e);
        logNotSafe.warn(error.getMessage(), e);
        context.addError(error);
    }

    protected CompletableFuture<ExecutionResult> completeValueForNull(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
        return Async.tryCatch(() -> {
            Object nullValue = parameters.getNonNullFieldValidator().validate(parameters.getPath(), null);
            return CompletableFuture.completedFuture(new ExecutionResultImpl(nullValue, null));
        });
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Object result) {
        Iterable<Object> resultIterable = this.toIterable(executionContext, parameters, result);
        try {
            resultIterable = parameters.getNonNullFieldValidator().validate(parameters.getPath(), resultIterable);
        }
        catch (NonNullableFieldWasNullException e) {
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(Async.exceptionallyCompletedFuture(e)).build();
        }
        if (resultIterable == null) {
            return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(CompletableFuture.completedFuture(new ExecutionResultImpl(null, null))).build();
        }
        return this.completeValueForList(executionContext, parameters, resultIterable);
    }

    protected FieldValueInfo completeValueForList(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Iterable<Object> iterableValues) {
        OptionalInt size = FpKit.toSize(iterableValues);
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        InstrumentationFieldCompleteParameters instrumentationParams = new InstrumentationFieldCompleteParameters(executionContext, parameters, () -> executionStepInfo, iterableValues);
        Instrumentation instrumentation = executionContext.getInstrumentation();
        InstrumentationContext<ExecutionResult> completeListCtx = instrumentation.beginFieldListComplete(instrumentationParams);
        ArrayList<FieldValueInfo> fieldValueInfos = new ArrayList<FieldValueInfo>(size.orElse(1));
        int index = 0;
        for (Object item2 : iterableValues) {
            ResultPath indexedPath = parameters.getPath().segment(index);
            ExecutionStepInfo stepInfoForListElement = this.executionStepInfoFactory.newExecutionStepInfoForListElement(executionStepInfo, index);
            NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, stepInfoForListElement);
            int finalIndex = index++;
            FetchedValue value = this.unboxPossibleDataFetcherResult(executionContext, parameters, item2);
            ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(stepInfoForListElement).nonNullFieldValidator(nonNullableFieldValidator).listSize(size.orElse(-1)).localContext(value.getLocalContext()).currentListIndex(finalIndex).path(indexedPath).source(value.getFetchedValue()));
            fieldValueInfos.add(this.completeValue(executionContext, newParameters));
        }
        CompletableFuture resultsFuture = Async.each(fieldValueInfos, (item, i) -> item.getFieldValue());
        CompletableFuture<ExecutionResult> overallResult = new CompletableFuture<ExecutionResult>();
        completeListCtx.onDispatched(overallResult);
        resultsFuture.whenComplete((results, exception) -> {
            if (exception != null) {
                ExecutionResult executionResult = this.handleNonNullException(executionContext, overallResult, (Throwable)exception);
                completeListCtx.onCompleted(executionResult, (Throwable)exception);
                return;
            }
            ArrayList completedResults = new ArrayList(results.size());
            for (ExecutionResult completedValue : results) {
                completedResults.add(completedValue.getData());
            }
            ExecutionResultImpl executionResult = new ExecutionResultImpl(completedResults, null);
            overallResult.complete(executionResult);
        });
        overallResult.whenComplete(completeListCtx::onCompleted);
        return FieldValueInfo.newFieldValueInfo(FieldValueInfo.CompleteValueType.LIST).fieldValue(overallResult).fieldValueInfos(fieldValueInfos).build();
    }

    protected CompletableFuture<ExecutionResult> completeValueForScalar(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLScalarType scalarType, Object result) {
        Object serialized;
        try {
            serialized = scalarType.getCoercing().serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        if (serialized instanceof Double && ((Double)serialized).isNaN()) {
            serialized = null;
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForEnum(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLEnumType enumType, Object result) {
        Object serialized;
        try {
            serialized = enumType.serialize(result);
        }
        catch (CoercingSerializeException e) {
            serialized = this.handleCoercionProblem(executionContext, parameters, e);
        }
        try {
            serialized = parameters.getNonNullFieldValidator().validate(parameters.getPath(), serialized);
        }
        catch (NonNullableFieldWasNullException e) {
            return Async.exceptionallyCompletedFuture(e);
        }
        return CompletableFuture.completedFuture(new ExecutionResultImpl(serialized, null));
    }

    protected CompletableFuture<ExecutionResult> completeValueForObject(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLObjectType resolvedObjectType, Object result) {
        ExecutionStepInfo executionStepInfo = parameters.getExecutionStepInfo();
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(resolvedObjectType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getVariables()).build();
        MergedSelectionSet subFields = this.fieldCollector.collectFields(collectorParameters, parameters.getField());
        ExecutionStepInfo newExecutionStepInfo = executionStepInfo.changeTypeWithPreservedNonNull(resolvedObjectType);
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, newExecutionStepInfo);
        ExecutionStrategyParameters newParameters = parameters.transform(builder -> builder.executionStepInfo(newExecutionStepInfo).fields(subFields).nonNullFieldValidator(nonNullableFieldValidator).source(result));
        return executionContext.getQueryStrategy().execute(executionContext, newParameters);
    }

    private Object handleCoercionProblem(ExecutionContext context, ExecutionStrategyParameters parameters, CoercingSerializeException e) {
        SerializationError error = new SerializationError(parameters.getPath(), e);
        logNotSafe.warn(error.getMessage(), e);
        context.addError(error);
        return null;
    }

    protected Iterable<Object> toIterable(Object result) {
        return FpKit.toIterable(result);
    }

    protected GraphQLObjectType resolveType(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLType fieldType) {
        return this.resolvedType.resolveType(executionContext, parameters.getField(), parameters.getSource(), parameters.getExecutionStepInfo().getArguments(), fieldType);
    }

    protected Iterable<Object> toIterable(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        if (FpKit.isIterable(result)) {
            return FpKit.toIterable(result);
        }
        this.handleTypeMismatchProblem(context, parameters, result);
        return null;
    }

    private void handleTypeMismatchProblem(ExecutionContext context, ExecutionStrategyParameters parameters, Object result) {
        TypeMismatchError error = new TypeMismatchError(parameters.getPath(), parameters.getExecutionStepInfo().getUnwrappedNonNullType());
        logNotSafe.warn("{} got {}", (Object)error.getMessage(), (Object)result.getClass());
        context.addError(error);
    }

    protected GraphQLFieldDefinition getFieldDef(ExecutionContext executionContext, ExecutionStrategyParameters parameters, Field field) {
        GraphQLObjectType parentType = (GraphQLObjectType)parameters.getExecutionStepInfo().getUnwrappedNonNullType();
        return this.getFieldDef(executionContext.getGraphQLSchema(), parentType, field);
    }

    protected GraphQLFieldDefinition getFieldDef(GraphQLSchema schema, GraphQLObjectType parentType, Field field) {
        return Introspection.getFieldDef(schema, parentType, field.getName());
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            throw new NonNullableFieldWasNullException(e);
        }
    }

    protected void assertNonNullFieldPrecondition(NonNullableFieldWasNullException e, CompletableFuture<?> completableFuture) throws NonNullableFieldWasNullException {
        ExecutionStepInfo executionStepInfo = e.getExecutionStepInfo();
        if (executionStepInfo.hasParent() && executionStepInfo.getParent().isNonNullType()) {
            completableFuture.completeExceptionally(new NonNullableFieldWasNullException(e));
        }
    }

    protected ExecutionResult handleNonNullException(ExecutionContext executionContext, CompletableFuture<ExecutionResult> result, Throwable e) {
        ExecutionResult executionResult = null;
        ImmutableList<GraphQLError> errors = ImmutableList.copyOf(executionContext.getErrors());
        Throwable underlyingException = e;
        if (e instanceof CompletionException) {
            underlyingException = e.getCause();
        }
        if (underlyingException instanceof NonNullableFieldWasNullException) {
            this.assertNonNullFieldPrecondition((NonNullableFieldWasNullException)underlyingException, result);
            if (!result.isDone()) {
                executionResult = new ExecutionResultImpl(null, errors);
                result.complete(executionResult);
            }
        } else if (underlyingException instanceof AbortExecutionException) {
            AbortExecutionException abortException = (AbortExecutionException)underlyingException;
            executionResult = abortException.toExecutionResult();
            result.complete(executionResult);
        } else {
            result.completeExceptionally(e);
        }
        return executionResult;
    }

    protected ExecutionStepInfo createExecutionStepInfo(ExecutionContext executionContext, ExecutionStrategyParameters parameters, GraphQLFieldDefinition fieldDefinition, GraphQLObjectType fieldContainer) {
        MergedField field = parameters.getField();
        ExecutionStepInfo parentStepInfo = parameters.getExecutionStepInfo();
        GraphQLOutputType fieldType = fieldDefinition.getType();
        List<GraphQLArgument> fieldArgDefs = fieldDefinition.getArguments();
        Map<String, Object> argumentValues = Collections.emptyMap();
        if (!fieldArgDefs.isEmpty()) {
            List<Argument> fieldArgs = field.getArguments();
            GraphQLCodeRegistry codeRegistry = executionContext.getGraphQLSchema().getCodeRegistry();
            argumentValues = this.valuesResolver.getArgumentValues(codeRegistry, fieldArgDefs, fieldArgs, executionContext.getVariables());
        }
        return ExecutionStepInfo.newExecutionStepInfo().type(fieldType).fieldDefinition(fieldDefinition).fieldContainer(fieldContainer).field(field).path(parameters.getPath()).parentInfo(parentStepInfo).arguments(argumentValues).build();
    }

    @Internal
    public static String mkNameForPath(Field currentField) {
        return ExecutionStrategy.mkNameForPath(Collections.singletonList(currentField));
    }

    @Internal
    public static String mkNameForPath(MergedField mergedField) {
        return ExecutionStrategy.mkNameForPath(mergedField.getFields());
    }

    @Internal
    public static String mkNameForPath(List<Field> currentField) {
        Field field = currentField.get(0);
        return field.getResultKey();
    }
}

