/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.ExecutionInput;
import graphql.ParseAndValidateResult;
import graphql.PublicApi;
import graphql.language.Document;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.parser.ParserOptions;
import graphql.schema.GraphQLSchema;
import graphql.validation.ValidationError;
import graphql.validation.Validator;
import java.util.List;
import java.util.Optional;

@PublicApi
public class ParseAndValidate {
    public static ParseAndValidateResult parseAndValidate(GraphQLSchema graphQLSchema, ExecutionInput executionInput) {
        ParseAndValidateResult result = ParseAndValidate.parse(executionInput);
        if (!result.isFailure()) {
            List<ValidationError> errors = ParseAndValidate.validate(graphQLSchema, result.getDocument());
            return result.transform(builder -> builder.validationErrors(errors));
        }
        return result;
    }

    public static ParseAndValidateResult parse(ExecutionInput executionInput) {
        try {
            ParserOptions parserOptions = (ParserOptions)executionInput.getGraphQLContext().get(ParserOptions.class);
            parserOptions = Optional.ofNullable(parserOptions).orElse(ParserOptions.getDefaultOperationParserOptions());
            Parser parser = new Parser();
            Document document = parser.parseDocument(executionInput.getQuery(), parserOptions);
            return ParseAndValidateResult.newResult().document(document).variables(executionInput.getVariables()).build();
        }
        catch (InvalidSyntaxException e) {
            return ParseAndValidateResult.newResult().syntaxException(e).variables(executionInput.getVariables()).build();
        }
    }

    public static List<ValidationError> validate(GraphQLSchema graphQLSchema, Document parsedDocument) {
        Validator validator = new Validator();
        return validator.validateDocument(graphQLSchema, parsedDocument);
    }
}

