/*
 * Decompiled with CFR 0.152.
 */
package manifold.tuple;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import manifold.api.util.fingerprint.Fingerprint;
import manifold.internal.javac.ITupleTypeProvider;

public class TupleTypeProvider
implements ITupleTypeProvider {
    static String BASE_NAME = "manifold_tuple_";
    private final Map<String, Map<String, String>> _nameToFields = new LinkedHashMap<String, Map<String, String>>();
    private final Map<String, String> _fingerprints = new ConcurrentHashMap<String, String>();

    @Override
    public String makeType(String pkg, Map<String, String> fieldNameToTypeName) {
        LinkedHashMap<String, String> alphaOrder = new LinkedHashMap<String, String>();
        fieldNameToTypeName.keySet().stream().sorted(Comparator.naturalOrder()).forEach(e -> {
            String cfr_ignored_0 = (String)alphaOrder.put((String)e, (String)fieldNameToTypeName.get(e));
        });
        String fqn = this.makeName(pkg, alphaOrder);
        this._nameToFields.putIfAbsent(fqn, alphaOrder);
        return fqn;
    }

    @Override
    public Set<String> getTypes() {
        return this._nameToFields.keySet();
    }

    @Override
    public Map<String, String> getFields(String fqn) {
        return this._nameToFields.get(fqn);
    }

    private String makeName(String pkg, Map<String, String> alphaOrder) {
        StringBuilder sb = new StringBuilder();
        alphaOrder.forEach((a, b) -> sb.append((String)a).append((String)b));
        String fingerprint = this._fingerprints.computeIfAbsent(sb.toString(), str -> {
            long rawFingerprint = new Fingerprint((String)str).getRawFingerprint();
            String fp = String.valueOf(rawFingerprint);
            return fp.charAt(0) == '-' ? '_' + fp.substring(1) : fp;
        });
        return pkg + '.' + BASE_NAME + fingerprint;
    }
}

