/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.dataloader.stats;

import manifold.shade.org.dataloader.stats.SimpleStatisticsCollector;
import manifold.shade.org.dataloader.stats.Statistics;
import manifold.shade.org.dataloader.stats.StatisticsCollector;

public class ThreadLocalStatisticsCollector
implements StatisticsCollector {
    private static final ThreadLocal<SimpleStatisticsCollector> collector = ThreadLocal.withInitial(SimpleStatisticsCollector::new);
    private final SimpleStatisticsCollector overallCollector = new SimpleStatisticsCollector();

    public ThreadLocalStatisticsCollector resetThread() {
        collector.remove();
        return this;
    }

    @Override
    public long incrementLoadCount() {
        this.overallCollector.incrementLoadCount();
        return collector.get().incrementLoadCount();
    }

    @Override
    public long incrementBatchLoadCountBy(long delta) {
        this.overallCollector.incrementBatchLoadCountBy(delta);
        return collector.get().incrementBatchLoadCountBy(delta);
    }

    @Override
    public long incrementCacheHitCount() {
        this.overallCollector.incrementCacheHitCount();
        return collector.get().incrementCacheHitCount();
    }

    @Override
    public long incrementLoadErrorCount() {
        this.overallCollector.incrementLoadErrorCount();
        return collector.get().incrementLoadErrorCount();
    }

    @Override
    public long incrementBatchLoadExceptionCount() {
        this.overallCollector.incrementBatchLoadExceptionCount();
        return collector.get().incrementBatchLoadExceptionCount();
    }

    @Override
    public Statistics getStatistics() {
        return collector.get().getStatistics();
    }

    public Statistics getOverallStatistics() {
        return this.overallCollector.getStatistics();
    }

    public String toString() {
        return "ThreadLocalStatisticsCollector{thread=" + this.getStatistics().toString() + "overallCollector=" + this.overallCollector.getStatistics().toString() + '}';
    }
}

