/*
 * Decompiled with CFR 0.152.
 */
package manifold.shade.org.dataloader.stats;

import java.util.LinkedHashMap;
import java.util.Map;
import manifold.shade.org.dataloader.annotations.PublicApi;

@PublicApi
public class Statistics {
    private final long loadCount;
    private final long loadErrorCount;
    private final long batchInvokeCount;
    private final long batchLoadCount;
    private final long batchLoadExceptionCount;
    private final long cacheHitCount;

    public Statistics() {
        this(0L, 0L, 0L, 0L, 0L, 0L);
    }

    public Statistics(long loadCount, long loadErrorCount, long batchInvokeCount, long batchLoadCount, long batchLoadExceptionCount, long cacheHitCount) {
        this.loadCount = loadCount;
        this.batchInvokeCount = batchInvokeCount;
        this.batchLoadCount = batchLoadCount;
        this.cacheHitCount = cacheHitCount;
        this.batchLoadExceptionCount = batchLoadExceptionCount;
        this.loadErrorCount = loadErrorCount;
    }

    public double ratio(long numerator, long denominator) {
        return denominator == 0L ? 0.0 : (double)numerator / (double)denominator;
    }

    public long getLoadCount() {
        return this.loadCount;
    }

    public long getLoadErrorCount() {
        return this.loadErrorCount;
    }

    public double getLoadErrorRatio() {
        return this.ratio(this.loadErrorCount, this.loadCount);
    }

    public long getBatchInvokeCount() {
        return this.batchInvokeCount;
    }

    public long getBatchLoadCount() {
        return this.batchLoadCount;
    }

    public double getBatchLoadRatio() {
        return this.ratio(this.batchLoadCount, this.loadCount);
    }

    public long getBatchLoadExceptionCount() {
        return this.batchLoadExceptionCount;
    }

    public double getBatchLoadExceptionRatio() {
        return this.ratio(this.batchLoadExceptionCount, this.loadCount);
    }

    public long getCacheHitCount() {
        return this.cacheHitCount;
    }

    public long getCacheMissCount() {
        return this.loadCount - this.cacheHitCount;
    }

    public double getCacheHitRatio() {
        return this.ratio(this.cacheHitCount, this.loadCount);
    }

    public Statistics combine(Statistics other) {
        return new Statistics(this.loadCount + other.getLoadCount(), this.loadErrorCount + other.getLoadErrorCount(), this.batchInvokeCount + other.getBatchInvokeCount(), this.batchLoadCount + other.getBatchLoadCount(), this.batchLoadExceptionCount + other.getBatchLoadExceptionCount(), this.cacheHitCount + other.getCacheHitCount());
    }

    public Map<String, Number> toMap() {
        LinkedHashMap<String, Number> stats = new LinkedHashMap<String, Number>();
        stats.put("loadCount", this.getLoadCount());
        stats.put("loadErrorCount", this.getLoadErrorCount());
        stats.put("loadErrorRatio", this.getLoadErrorRatio());
        stats.put("batchInvokeCount", this.getBatchInvokeCount());
        stats.put("batchLoadCount", this.getBatchLoadCount());
        stats.put("batchLoadRatio", this.getBatchLoadRatio());
        stats.put("batchLoadExceptionCount", this.getBatchLoadExceptionCount());
        stats.put("batchLoadExceptionRatio", this.getBatchLoadExceptionRatio());
        stats.put("cacheHitCount", this.getCacheHitCount());
        stats.put("cacheHitRatio", this.getCacheHitRatio());
        return stats;
    }

    public String toString() {
        return "Statistics{loadCount=" + this.loadCount + ", loadErrorCount=" + this.loadErrorCount + ", batchLoadCount=" + this.batchLoadCount + ", batchLoadExceptionCount=" + this.batchLoadExceptionCount + ", cacheHitCount=" + this.cacheHitCount + '}';
    }
}

