/*
 * Decompiled with CFR 0.152.
 */
package manifold.science.measures;

import manifold.science.api.AbstractMeasure;
import manifold.science.measures.AngleUnit;
import manifold.science.measures.Frequency;
import manifold.science.measures.FrequencyUnit;
import manifold.science.measures.Length;
import manifold.science.measures.Time;
import manifold.science.measures.TimeUnit;
import manifold.science.measures.Velocity;
import manifold.science.util.Rational;
import manifold.science.vector.LengthVector;
import manifold.science.vector.TimeVector;
import manifold.science.vector.VelocityVector;

public final class Angle
extends AbstractMeasure<AngleUnit, Angle> {
    public Angle(Rational value, AngleUnit unit, AngleUnit displayUnit) {
        super(value, unit, displayUnit);
    }

    public Angle(Rational value, AngleUnit unit) {
        this(value, unit, unit);
    }

    @Override
    public AngleUnit getBaseUnit() {
        return AngleUnit.BASE;
    }

    @Override
    public Angle make(Rational value, AngleUnit unit, AngleUnit displayUnit) {
        return new Angle(value, unit, displayUnit);
    }

    @Override
    public Angle make(Rational value, AngleUnit unit) {
        return new Angle(value, unit);
    }

    public LengthVector postfixBind(Length len) {
        return new LengthVector(len, this);
    }

    public TimeVector postfixBind(Time t) {
        return new TimeVector(t, this);
    }

    public VelocityVector postfixBind(Velocity v) {
        return new VelocityVector(v, this);
    }

    public Frequency div(Time time) {
        return new Frequency(this.toBaseNumber().div(time.toBaseNumber()), FrequencyUnit.BASE, FrequencyUnit.get((AngleUnit)this.getDisplayUnit(), (TimeUnit)time.getDisplayUnit()));
    }

    public Time div(Frequency freq) {
        return new Time(this.toBaseNumber().div(freq.toBaseNumber()), TimeUnit.BASE, ((FrequencyUnit)freq.getDisplayUnit()).getTimeUnit());
    }
}

