/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.stream.Stream;
import manifold.rt.api.util.StreamUtil;
import manifold.util.ReflectUtil;

public class ManModuleReader {
    private final Object _delegate;
    private final Object _ucp;

    public ManModuleReader(Object delegate, Object ucp) {
        this._delegate = delegate;
        this._ucp = ucp;
    }

    public Optional<URI> find(String name) throws IOException {
        URL resource;
        Optional<URI> uri = (Optional<URI>)ReflectUtil.method(this._delegate, "find", String.class).invoke(name);
        if (!uri.isPresent() && (resource = (URL)ReflectUtil.method(this._ucp, "findResource", String.class, Boolean.TYPE).invoke(name, false)) != null) {
            try {
                uri = Optional.of(resource.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return uri;
    }

    public Optional<InputStream> open(String name) {
        Object resource;
        Optional<InputStream> input = (Optional<InputStream>)ReflectUtil.method(this._delegate, "open", String.class).invoke(name);
        if (!input.isPresent() && (resource = ReflectUtil.method(this._ucp, "getResource", String.class, Boolean.TYPE).invoke(name, false)) != null) {
            input = Optional.of((InputStream)ReflectUtil.method(resource, "getInputStream", new Class[0]).invoke(new Object[0]));
        }
        return input;
    }

    public Optional<ByteBuffer> read(String name) throws IOException {
        Object resource;
        Optional<ByteBuffer> buffer = (Optional<ByteBuffer>)ReflectUtil.method(this._delegate, "read", String.class).invoke(name);
        if (!buffer.isPresent() && (resource = ReflectUtil.method(this._ucp, "getResource", String.class, Boolean.TYPE).invoke(name, false)) != null) {
            ByteBuffer bytes = ByteBuffer.wrap(StreamUtil.getContent((InputStream)ReflectUtil.method(resource, "getInputStream", new Class[0]).invoke(new Object[0])));
            buffer = Optional.of(bytes);
        }
        return buffer;
    }

    public void release(ByteBuffer bb) {
        try {
            ReflectUtil.method(this._delegate, "release", ByteBuffer.class).invoke(bb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Stream<String> list() {
        return (Stream)ReflectUtil.method(this._delegate, "list", new Class[0]).invoke(new Object[0]);
    }

    public void close() {
        ReflectUtil.method(this._delegate, "close", new Class[0]).invoke(new Object[0]);
    }
}

