/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.ArgumentAttr;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Flow;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TypeEnter;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.Gen;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.tools.Diagnostic;
import manifold.api.type.ICompilerComponent;
import manifold.internal.javac.GeneratedJavaStubFileObject;
import manifold.internal.javac.JavacPlugin;
import manifold.rt.api.util.Stack;
import manifold.util.ReflectUtil;
import manifold.util.concurrent.LocklessLazyVar;

public class ManLog_11
extends Log {
    private Map<Log.DiagnosticHandler, LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>>> _suspendedIssues;
    private LocklessLazyVar<Class<?>> _extensionTransformerClass;

    public static Log instance(Context ctx) {
        Log log = (Log)ctx.get(logKey);
        if (!(log instanceof ManLog_11)) {
            ctx.put(logKey, (Log)null);
            log = new ManLog_11(ctx, (Log.DiagnosticHandler)ReflectUtil.field(log, "diagnosticHandler").get(), log.currentSource(), (Map)ReflectUtil.field(log, "writers").get());
        }
        return log;
    }

    private ManLog_11(Context ctx, Log.DiagnosticHandler diagnosticHandler, DiagnosticSource source, Map<Log.WriterKind, PrintWriter> writers) {
        super(ctx);
        ReflectUtil.field(this, "diagnosticHandler").set(diagnosticHandler);
        this.ensureDiagnosticHandlersEnclosingClassIsThis(diagnosticHandler);
        ReflectUtil.field(this, "source").set(source);
        ReflectUtil.field(this, "writers").set(writers);
        this._suspendedIssues = new HashMap<Log.DiagnosticHandler, LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>>>();
        this._extensionTransformerClass = LocklessLazyVar.make(() -> ReflectUtil.type("manifold.ext.ExtensionTransformer"));
        this.reassignLog(ctx);
    }

    private void ensureDiagnosticHandlersEnclosingClassIsThis(Log.DiagnosticHandler diagnosticHandler) {
        try {
            ReflectUtil.field(diagnosticHandler, "this$0").set(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void reassignLog(Context ctx) {
        Object[] earlyAttrHolders;
        for (Object instance : earlyAttrHolders = new Object[]{Annotate.instance(ctx), ArgumentAttr.instance(ctx), Arguments.instance(ctx), Check.instance(ctx), ClassReader.instance(ctx), ClassWriter.instance(ctx), DeferredAttr.instance(ctx), Enter.instance(ctx), Flow.instance(ctx), Gen.instance(ctx), Infer.instance(ctx), JavaCompiler.instance(ctx), JavacProcessingEnvironment.instance(ctx), JavacProcessingEnvironment.instance(ctx).getMessager(), JavacTrees.instance(ctx), MemberEnter.instance(ctx), Modules.instance(ctx), Resolve.instance(ctx), TypeEnter.instance(ctx), Operators.instance(ctx)}) {
            ReflectUtil.LiveFieldRef l = ReflectUtil.WithNull.field(instance, "log");
            if (l == null) continue;
            l.set(this);
        }
        for (Field f : Check.class.getDeclaredFields()) {
            if (!MandatoryWarningHandler.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            try {
                Object mwh = f.get(Check.instance(ctx));
                ReflectUtil.field(mwh, "log").set(this);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void popDiagnosticHandler(Log.DiagnosticHandler handler) {
        super.popDiagnosticHandler(handler);
        this._suspendedIssues.remove(handler);
        Log.DiagnosticHandler diagnosticHandler = (Log.DiagnosticHandler)ReflectUtil.field(this, "diagnosticHandler").get();
        this.ensureDiagnosticHandlersEnclosingClassIsThis(diagnosticHandler);
    }

    @Override
    public void error(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Error errorKey) {
        if (!(pos instanceof JCTree.JCFieldAccess && ("compiler.err.cant.assign.val.to.final.var".equals(errorKey.key()) || "compiler.err.var.might.already.be.assigned".equals(errorKey.key())) && this.isJailbreakSelect((JCTree.JCFieldAccess)pos) || this.isSuppressedError(errorKey.key()))) {
            super.error(pos, errorKey);
        }
    }

    private boolean isSuppressedError(String key) {
        for (ICompilerComponent cc : JavacPlugin.instance().getTypeProcessor().getCompilerComponents()) {
            if (!cc.isSuppressed(key)) continue;
            return true;
        }
        return false;
    }

    private Log.DiagnosticHandler getDiagnosticHandler() {
        return (Log.DiagnosticHandler)ReflectUtil.field(this, "diagnosticHandler").get();
    }

    @Override
    public void report(JCDiagnostic issue) {
        if (issue.getKind().ordinal() > Diagnostic.Kind.ERROR.ordinal() && issue.getDiagnosticSource().getFile() instanceof GeneratedJavaStubFileObject) {
            return;
        }
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        if (suspendedIssues == null || suspendedIssues.isEmpty()) {
            super.report(issue);
        } else {
            JCTree last = null;
            Iterator<JCTree> iterator = suspendedIssues.keySet().iterator();
            while (iterator.hasNext()) {
                JCTree key;
                last = key = iterator.next();
            }
            suspendedIssues.get(last).peek().push(issue);
        }
    }

    boolean isJailbreakSelect(JCTree.JCFieldAccess pos) {
        if (this._extensionTransformerClass.get() == null) {
            return false;
        }
        return (Boolean)ReflectUtil.method(this._extensionTransformerClass.get(), "isJailbreakReceiver", JCTree.JCFieldAccess.class).invokeStatic(pos);
    }

    void pushSuspendIssues(JCTree tree) {
        LinkedHashMap suspendedIssues = this._suspendedIssues.computeIfAbsent(this.getDiagnosticHandler(), k -> new LinkedHashMap());
        Stack issues = (Stack)suspendedIssues.get(tree);
        if (issues == null) {
            issues = new Stack();
            suspendedIssues.put(tree, issues);
        }
        issues.push(new Stack());
    }

    void popSuspendIssues(JCTree tree) {
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        if (suspendedIssues.isEmpty()) {
            return;
        }
        Stack<Stack<JCDiagnostic>> issueFrames = suspendedIssues.get(tree);
        if (issueFrames.size() == 1) {
            if (this.isRootFrame(tree)) {
                this.recordRecentSuspendedIssuesAndRemoveOthers(tree);
            }
        } else {
            issueFrames.pop();
        }
    }

    void recordRecentSuspendedIssuesAndRemoveOthers(JCTree tree) {
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        Stack<Stack<JCDiagnostic>> issues = suspendedIssues.get(tree);
        Stack<JCDiagnostic> currentIssues = issues.pop();
        issues.clear();
        issues.push(currentIssues);
        if (this.isRootFrame(tree)) {
            this.recordSuspendedIssues();
            suspendedIssues.clear();
        }
    }

    private void recordSuspendedIssues() {
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        for (Map.Entry<JCTree, Stack<Stack<JCDiagnostic>>> entry : suspendedIssues.entrySet()) {
            Stack<Stack<JCDiagnostic>> issueFrames = entry.getValue();
            Stack<JCDiagnostic> issueFrame = issueFrames.pop();
            if (!issueFrames.isEmpty()) {
                throw new IllegalStateException("Invalid issue frames, should be only one frame");
            }
            for (JCDiagnostic d : issueFrame) {
                super.report(d);
            }
        }
    }

    private boolean isRootFrame(JCTree tree) {
        LinkedHashMap<JCTree, Stack<Stack<JCDiagnostic>>> suspendedIssues = this._suspendedIssues.get(this.getDiagnosticHandler());
        return suspendedIssues.keySet().iterator().next() == tree;
    }
}

