/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import manifold.api.util.IssueMsg;
import manifold.internal.javac.AbstractBinder;
import manifold.internal.javac.IDynamicJdk;
import manifold.internal.javac.JavacBinder;
import manifold.internal.javac.JavacPlugin;
import manifold.internal.javac.ManTypeCast;
import manifold.internal.javac.OverloadOperatorSymbol;
import manifold.util.JreUtil;
import manifold.util.ReflectUtil;

public interface ManAttr {
    public static final String AUTO_TYPE = "manifold.ext.rt.api.auto";
    public static final boolean JAILBREAK_PRIVATE_FROM_SUPERS = true;
    public static final String COMPARE_TO = "compareTo";
    public static final String COMPARE_TO_USING = "compareToUsing";
    public static final String UNARY_MINUS = "unaryMinus";
    public static final String INC = "inc";
    public static final String DEC = "dec";
    public static final Map<JCTree.Tag, String> BINARY_OP_TO_NAME = new HashMap<JCTree.Tag, String>(){
        {
            this.put(JCTree.Tag.PLUS, "plus");
            this.put(JCTree.Tag.MINUS, "minus");
            this.put(JCTree.Tag.MUL, "times");
            this.put(JCTree.Tag.DIV, "div");
            this.put(JCTree.Tag.MOD, "rem");
        }
    };

    public JCTree.JCMethodDecl peekMethodDef();

    public JCTree.JCFieldAccess peekSelect();

    public JCTree.JCAnnotatedType peekAnnotatedType();

    default public Env getEnv() {
        return (Env)ReflectUtil.field(this, "env").get();
    }

    default public Log getLogger() {
        return (Log)ReflectUtil.field(this, "log").get();
    }

    default public Check chk() {
        return (Check)ReflectUtil.field(this, "chk").get();
    }

    default public Resolve rs() {
        return (Resolve)ReflectUtil.field(this, "rs").get();
    }

    default public Names names() {
        return (Names)ReflectUtil.field(this, "names").get();
    }

    default public Types types() {
        return (Types)ReflectUtil.field(this, "types").get();
    }

    default public Object cfolder() {
        return ReflectUtil.field(this, "cfolder").get();
    }

    default public Symtab syms() {
        return (Symtab)ReflectUtil.field(this, "syms").get();
    }

    default public Object _pkind() {
        return ReflectUtil.method(this, "pkind", new Class[0]).invoke(new Object[0]);
    }

    default public void patchMethodType(JCTree.JCMethodInvocation tree, Set<JCTree.JCMethodInvocation> visited) {
        this.patchOperatorMethodType(tree);
        if (visited.contains(tree)) {
            return;
        }
        visited.add(tree);
        try {
            this.patchAutoReturnType(tree);
        }
        finally {
            visited.remove(tree);
        }
    }

    default public void patchOperatorMethodType(JCTree.JCMethodInvocation tree) {
        if (tree.meth.type == null) {
            Symbol sym;
            if (tree.meth instanceof JCTree.JCIdent) {
                Symbol sym2 = ((JCTree.JCIdent)tree.meth).sym;
                if (sym2 != null) {
                    tree.meth.type = sym2.type;
                }
            } else if (tree.meth instanceof JCTree.JCFieldAccess && (sym = ((JCTree.JCFieldAccess)tree.meth).sym) != null) {
                tree.meth.type = sym.type;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void patchAutoFieldType(JCTree.JCExpression tree) {
        Type type = tree.type;
        if (!this.isAutoType(type)) {
            return;
        }
        Symbol.VarSymbol vsym = null;
        if (tree instanceof JCTree.JCIdent && ((JCTree.JCIdent)tree).sym instanceof Symbol.VarSymbol) {
            vsym = (Symbol.VarSymbol)((JCTree.JCIdent)tree).sym;
        } else if (tree instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree).sym instanceof Symbol.VarSymbol) {
            vsym = (Symbol.VarSymbol)((JCTree.JCFieldAccess)tree).sym;
        }
        if (vsym != null) {
            Symbol.ClassSymbol declaringClassSym = (Symbol.ClassSymbol)vsym.owner;
            JCTree.JCClassDecl enclosingClass = this.getEnclosingClass(tree);
            MyDiagnosticHandler diagHandler = new MyDiagnosticHandler(this.getLogger());
            try {
                if (enclosingClass != null && enclosingClass.sym == declaringClassSym) {
                    JCTree.JCVariableDecl varDecl = this.findJCVariableDecl(enclosingClass, vsym);
                    ((Attr)((Object)this)).attribStat(varDecl, this.getEnv());
                } else {
                    ((Attr)((Object)this)).attribClass(tree.pos(), declaringClassSym);
                }
            }
            finally {
                this.getLogger().popDiagnosticHandler(diagHandler);
            }
            type = vsym.type;
            if (this.isAutoType(type) && enclosingClass != null && enclosingClass.sym != declaringClassSym) {
                diagHandler = new MyDiagnosticHandler(this.getLogger());
                try {
                    Env declClassEnv = (Env)ReflectUtil.method(ReflectUtil.field(this, "typeEnvs").get(), "get", Symbol.TypeSymbol.class).invoke(declaringClassSym);
                    JCTree.JCClassDecl declaringClass = (JCTree.JCClassDecl)declClassEnv.tree;
                    JCTree.JCVariableDecl varDecl = this.findJCVariableDecl(declaringClass, vsym);
                    type = ((Attr)((Object)this)).attribStat(varDecl, declClassEnv);
                }
                finally {
                    this.getLogger().popDiagnosticHandler(diagHandler);
                }
            }
            if (this.isAutoType(type)) {
                IDynamicJdk.instance().logError(Log.instance(JavacPlugin.instance().getContext()), tree.pos(), "proc.messager", IssueMsg.MSG_AUTO_UNABLE_TO_RESOLVE_TYPE.get(new Object[0]));
            } else {
                tree.type = type;
                ReflectUtil.field(this, "result").set(type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void patchAutoReturnType(JCTree.JCMethodInvocation tree) {
        Type type = tree.type;
        if (!this.isAutoType(type)) {
            return;
        }
        Symbol.MethodSymbol msym = null;
        if (tree.meth instanceof JCTree.JCIdent && ((JCTree.JCIdent)tree.meth).sym instanceof Symbol.MethodSymbol) {
            msym = (Symbol.MethodSymbol)((JCTree.JCIdent)tree.meth).sym;
        } else if (tree.meth instanceof JCTree.JCFieldAccess && ((JCTree.JCFieldAccess)tree.meth).sym instanceof Symbol.MethodSymbol) {
            msym = (Symbol.MethodSymbol)((JCTree.JCFieldAccess)tree.meth).sym;
        }
        if (msym != null) {
            Symbol.ClassSymbol declaringClassSym = (Symbol.ClassSymbol)msym.owner;
            JCTree.JCClassDecl enclosingClass = this.getEnclosingClass(tree);
            MyDiagnosticHandler diagHandler = new MyDiagnosticHandler(this.getLogger());
            try {
                if (enclosingClass != null && enclosingClass.sym == declaringClassSym) {
                    JCTree.JCMethodDecl methodDef = this.findJCMethodDef(enclosingClass, msym);
                    ((Attr)((Object)this)).attribStat(methodDef, this.getEnv());
                } else {
                    ((Attr)((Object)this)).attribClass(tree.pos(), declaringClassSym);
                }
            }
            finally {
                this.getLogger().popDiagnosticHandler(diagHandler);
            }
            type = msym.getReturnType();
            if (this.isAutoType(type) && enclosingClass != null && enclosingClass.sym != declaringClassSym) {
                diagHandler = new MyDiagnosticHandler(this.getLogger());
                try {
                    Env declClassEnv = (Env)ReflectUtil.method(ReflectUtil.field(this, "typeEnvs").get(), "get", Symbol.TypeSymbol.class).invoke(declaringClassSym);
                    JCTree.JCClassDecl declaringClass = (JCTree.JCClassDecl)declClassEnv.tree;
                    JCTree.JCMethodDecl methodDef = this.findJCMethodDef(declaringClass, msym);
                    if (methodDef != this.getEnv().enclMethod) {
                        ((Attr)((Object)this)).attribStat(methodDef, declClassEnv);
                        type = msym.getReturnType();
                    }
                }
                finally {
                    this.getLogger().popDiagnosticHandler(diagHandler);
                }
            }
            if (this.isAutoType(type)) {
                IDynamicJdk.instance().logError(Log.instance(JavacPlugin.instance().getContext()), tree.meth.pos(), "proc.messager", IssueMsg.MSG_AUTO_UNABLE_TO_RESOLVE_TYPE.get(new Object[0]));
            } else {
                tree.type = type;
                ReflectUtil.field(this, "result").set(type);
                ReflectUtil.method(ReflectUtil.field(this, "resultInfo").get(), "check", JCDiagnostic.DiagnosticPosition.class, Type.class).invoke(tree.pos(), type);
            }
        }
    }

    default public JCTree.JCMethodDecl findJCMethodDef(JCTree.JCClassDecl tree, Symbol.MethodSymbol msym) {
        for (JCTree def : tree.defs) {
            if (!(def instanceof JCTree.JCMethodDecl) || ((JCTree.JCMethodDecl)def).sym != msym) continue;
            return (JCTree.JCMethodDecl)def;
        }
        return null;
    }

    default public JCTree.JCVariableDecl findJCVariableDecl(JCTree.JCClassDecl tree, Symbol.VarSymbol vsym) {
        for (JCTree def : tree.defs) {
            if (!(def instanceof JCTree.JCVariableDecl) || ((JCTree.JCVariableDecl)def).sym != vsym) continue;
            return (JCTree.JCVariableDecl)def;
        }
        return null;
    }

    default public JCTree.JCClassDecl getEnclosingClass(Tree tree) {
        if (tree == null) {
            return null;
        }
        if (tree instanceof JCTree.JCClassDecl) {
            return (JCTree.JCClassDecl)tree;
        }
        return this.getEnclosingClass(JavacPlugin.instance().getTypeProcessor().getParent(tree, this.getEnv().toplevel));
    }

    default public boolean isAutoType(Type type) {
        return type != null && type.tsym != null && type.tsym.getQualifiedName().toString().equals(AUTO_TYPE);
    }

    default public void handleNonStaticInterfaceProperty(Env<AttrContext> env) {
        if ((((Scope)ReflectUtil.field(env.info, (String)"scope").get()).owner.flags() & 0x200L) != 0L && env.tree instanceof JCTree.JCVariableDecl) {
            JCTree.JCModifiers mods = ((JCTree.JCVariableDecl)env.tree).mods;
            if ((mods.flags & 8L) == 0L) {
                for (JCTree.JCAnnotation anno : mods.annotations) {
                    if (!this.isPropertyAnno(anno.annotationType)) continue;
                    ReflectUtil.LiveFieldRef staticLevel = ReflectUtil.field(env.info, "staticLevel");
                    staticLevel.set((Integer)staticLevel.get() - 1);
                }
            }
        }
    }

    default public boolean isPropertyAnno(JCTree annotationType) {
        String annoName = annotationType.toString();
        for (String anno : new String[]{"var", "val", "get", "set"}) {
            if (!annoName.equals(anno) && !annoName.endsWith("." + anno)) continue;
            return true;
        }
        return false;
    }

    default public boolean handleOperatorOverloading(JCTree.JCExpression tree, Type left, Type right) {
        boolean swapped = false;
        Symbol.MethodSymbol overloadOperator = ManAttr.resolveOperatorMethod(this.types(), tree.getTag(), left, right);
        if (overloadOperator == null && ManAttr.isCommutative(tree.getTag())) {
            overloadOperator = ManAttr.resolveOperatorMethod(this.types(), tree.getTag(), right, left);
            swapped = true;
        }
        if (overloadOperator != null) {
            if (overloadOperator.name.toString().equals(COMPARE_TO)) {
                Type.MethodType typePoseWithBooleanReturn = new Type.MethodType(overloadOperator.type.getParameterTypes(), this.syms().booleanType, overloadOperator.type.getThrownTypes(), this.syms().methodClass);
                overloadOperator = new OverloadOperatorSymbol(overloadOperator, typePoseWithBooleanReturn, swapped);
            } else {
                overloadOperator = new OverloadOperatorSymbol(overloadOperator, swapped);
            }
            IDynamicJdk.instance().setOperator(tree, (Symbol.OperatorSymbol)overloadOperator);
            Type owntype = overloadOperator.type.isErroneous() ? overloadOperator.type : (swapped ? this.types().memberType(right, overloadOperator).getReturnType() : this.types().memberType(left, overloadOperator).getReturnType());
            this.setResult(tree, owntype);
            return true;
        }
        return false;
    }

    default public boolean handleUnaryOverloading(JCTree.JCUnary tree) {
        ReflectUtil.LiveMethodRef checkNonVoid = ReflectUtil.method(this.chk(), "checkNonVoid", JCDiagnostic.DiagnosticPosition.class, Type.class);
        ReflectUtil.LiveMethodRef attribExpr = ReflectUtil.method(this, "attribExpr", JCTree.class, Env.class);
        Type exprType = tree.getTag().isIncOrDecUnaryOp() ? (Type)attribExpr.invoke(tree.arg, this.getEnv()) : (Type)checkNonVoid.invoke(tree.arg.pos(), attribExpr.invoke(tree.arg, this.getEnv()));
        Symbol.MethodSymbol overloadOperator = ManAttr.resolveUnaryMethod(this.types(), tree.getTag(), exprType);
        if (overloadOperator != null) {
            Type owntype;
            overloadOperator = new OverloadOperatorSymbol(overloadOperator, false);
            if (overloadOperator.type.isErroneous()) {
                owntype = overloadOperator.type;
            } else {
                Type returnType = this.types().memberType(exprType, overloadOperator).getReturnType();
                if (this.types().isAssignable(exprType, returnType)) {
                    owntype = returnType;
                } else {
                    return false;
                }
            }
            IDynamicJdk.instance().setOperator(tree, (Symbol.OperatorSymbol)overloadOperator);
            this.setResult(tree, owntype);
            return true;
        }
        return false;
    }

    default public boolean handleIndexedOverloading(JCTree.JCArrayAccess tree) {
        boolean handled = true;
        Type owntype = this.types().createErrorType(tree.type);
        ReflectUtil.LiveMethodRef attribExpr = ReflectUtil.method(this, "attribExpr", JCTree.class, Env.class);
        Type indexedType = (Type)attribExpr.invoke(tree.indexed, this.getEnv());
        Type indexType = (Type)attribExpr.invoke(tree.index, this.getEnv());
        if (this.types().isArray(indexedType)) {
            owntype = this.types().elemtype(indexedType);
            if (!this.types().isAssignable(indexType, this.syms().intType)) {
                IDynamicJdk.instance().logError(this.getLogger(), tree.pos(), "incomparable.types", indexType, this.syms().intType);
            }
            handled = false;
        } else if (!indexedType.hasTag(TypeTag.ERROR)) {
            Symbol.MethodSymbol indexGetMethod = ManAttr.resolveIndexGetMethod(this.types(), indexedType, indexType);
            if (indexGetMethod != null) {
                owntype = indexGetMethod.type.isErroneous() ? indexGetMethod.type : this.types().memberType(indexedType, indexGetMethod).getReturnType();
            } else {
                IDynamicJdk.instance().logError(this.getLogger(), tree.pos(), "array.req.but.found", indexedType);
                handled = false;
            }
        }
        this.setResult(tree, owntype, "VAR");
        return handled;
    }

    default public void ensureIndexedAssignmentIsWritable(JCTree.JCExpression lhs) {
        if (lhs instanceof JCTree.JCArrayAccess) {
            Symbol.MethodSymbol indexSetMethod;
            JCTree.JCArrayAccess arrayAccess = (JCTree.JCArrayAccess)lhs;
            if (!this.types().isArray(arrayAccess.indexed.type) && (indexSetMethod = ManAttr.resolveIndexSetMethod(this.types(), arrayAccess.indexed.type, arrayAccess.index.type)) == null) {
                IDynamicJdk.instance().logError(this.getLogger(), arrayAccess, "array.req.but.found", arrayAccess.indexed.type);
            }
        }
    }

    default public void visitBindingExpression(JCTree.JCBinary tree) {
        Type owntype;
        if (IDynamicJdk.instance().getOperator(tree) == null) {
            JCTree.JCBinary newTree = (JCTree.JCBinary)new JavacBinder(this.types()).bind(this.getBindingOperands(tree, new ArrayList<AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag>>()));
            if (newTree == null) {
                this.getLogger().error(tree.lhs.pos, "proc.messager", "No reaction defined for types '" + tree.lhs.type + "' and '" + tree.rhs.type + "'");
                return;
            }
            ReflectUtil.field(tree, "opcode").set(ReflectUtil.field(newTree, "opcode").get());
            tree.lhs = newTree.lhs;
            tree.rhs = newTree.rhs;
            tree.type = newTree.type;
            IDynamicJdk.instance().setOperator(tree, (Symbol.OperatorSymbol)IDynamicJdk.instance().getOperator(newTree));
            owntype = newTree.type;
        } else {
            Symbol operator = IDynamicJdk.instance().getOperator(tree);
            owntype = operator.type.isErroneous() ? operator.type : operator.type.getReturnType();
        }
        this.setResult(tree, owntype);
    }

    default public void setResult(JCTree.JCExpression tree, Type owntype) {
        this.setResult(tree, owntype, "VAL");
    }

    default public void setResult(JCTree.JCExpression tree, Type owntype, String valVar) {
        if (JreUtil.isJava8()) {
            int VALorVAR = (Integer)ReflectUtil.field("com.sun.tools.javac.code.Kinds", valVar).getStatic();
            if (valVar.equals("VAR") && ((Integer)this._pkind() & VALorVAR) == 0) {
                owntype = this.types().capture(owntype);
            }
            ReflectUtil.field(this, "result").set(ReflectUtil.method(this, "check", JCTree.class, Type.class, Integer.TYPE, ReflectUtil.type(Attr.class.getTypeName() + "$ResultInfo")).invoke(tree, owntype, VALorVAR, ReflectUtil.field(this, "resultInfo").get()));
        } else {
            Class<?> kindSelectorClass = ReflectUtil.type("com.sun.tools.javac.code.Kinds$KindSelector");
            Object VAL = ReflectUtil.field(kindSelectorClass, "VAL").getStatic();
            Object VALorVAR = ReflectUtil.field(kindSelectorClass, valVar).getStatic();
            if (valVar.equals("VAR") && !((Boolean)ReflectUtil.method(this._pkind(), "contains", kindSelectorClass).invoke(VAL)).booleanValue()) {
                owntype = this.types().capture(owntype);
            }
            ReflectUtil.field(this, "result").set(ReflectUtil.method(this, "check", JCTree.class, Type.class, kindSelectorClass, ReflectUtil.type(Attr.class.getTypeName() + "$ResultInfo")).invoke(tree, owntype, VALorVAR, ReflectUtil.field(this, "resultInfo").get()));
        }
    }

    default public ArrayList<AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag>> getBindingOperands(JCTree.JCExpression tree, ArrayList<AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag>> operands) {
        if (tree instanceof JCTree.JCBinary && tree.getTag() == JCTree.Tag.APPLY) {
            this.getBindingOperands(((JCTree.JCBinary)tree).lhs, operands);
            this.getBindingOperands(((JCTree.JCBinary)tree).rhs, operands);
        } else if (tree instanceof JCTree.JCBinary) {
            JCTree.JCBinary binExpr = (JCTree.JCBinary)tree;
            JCTree.Tag opcode = (JCTree.Tag)((Object)ReflectUtil.field(tree, "opcode").get());
            this.getBindingOperands(binExpr.lhs, operands);
            int index = operands.size();
            this.getBindingOperands(binExpr.rhs, operands);
            AbstractBinder.Node<JCTree.JCExpression, JCTree.Tag> rhsNode = operands.get(index);
            rhsNode._operatorLeft = opcode;
        } else {
            ReflectUtil.LiveMethodRef checkNonVoid = ReflectUtil.method(this.chk(), "checkNonVoid", JCDiagnostic.DiagnosticPosition.class, Type.class);
            ReflectUtil.LiveMethodRef attribExpr = ReflectUtil.method(this, "attribExpr", JCTree.class, Env.class);
            checkNonVoid.invoke(tree.pos(), attribExpr.invoke(tree, this.getEnv()));
            operands.add(new AbstractBinder.Node(tree));
        }
        return operands;
    }

    default public JCTree.JCTypeCast makeCast(JCTree.JCExpression expression, Type type) {
        TreeMaker make = JavacPlugin.instance().getTreeMaker();
        JCTree.JCTypeCast castCall = make.TypeCast(type, expression);
        ManTypeCast manTypeCast = new ManTypeCast(castCall.clazz, castCall.expr);
        manTypeCast.type = type;
        manTypeCast.pos = expression.pos;
        return manTypeCast;
    }

    public static Symbol.MethodSymbol resolveUnaryMethod(Types types, JCTree.Tag tag, Type expr) {
        String op;
        if (expr instanceof Type.TypeVar) {
            expr = types.erasure(expr);
        }
        if (!(expr.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        switch (tag) {
            case NEG: {
                op = UNARY_MINUS;
                break;
            }
            case POSTINC: 
            case PREINC: {
                op = INC;
                break;
            }
            case POSTDEC: 
            case PREDEC: {
                op = DEC;
                break;
            }
            default: {
                return null;
            }
        }
        return ManAttr.getMethodSymbol(types, expr, null, op, (Symbol.ClassSymbol)expr.tsym, 0);
    }

    public static Symbol.MethodSymbol resolveIndexGetMethod(Types types, Type indexedType, Type indexType) {
        if (indexedType instanceof Type.TypeVar) {
            indexedType = types.erasure(indexedType);
        }
        if (!(indexedType.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        if (!(indexType.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        return ManAttr.getMethodSymbol(types, indexedType, indexType, "get", (Symbol.ClassSymbol)indexedType.tsym, 1);
    }

    public static Symbol.MethodSymbol resolveIndexSetMethod(Types types, Type indexedType, Type indexType) {
        if (indexedType instanceof Type.TypeVar) {
            indexedType = types.erasure(indexedType);
        }
        if (!(indexedType.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        if (!(indexType.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        Symbol.MethodSymbol getMethod = ManAttr.getMethodSymbol(types, indexedType, indexType, "get", (Symbol.ClassSymbol)indexedType.tsym, 1);
        if (getMethod != null) {
            Type param2;
            Type elemType = getMethod.type.isErroneous() ? getMethod.type : types.memberType(indexedType, getMethod).getReturnType();
            Symbol.MethodSymbol setMethod = ManAttr.getMethodSymbol(types, indexedType, indexType, "set", (Symbol.ClassSymbol)indexedType.tsym, 2);
            if (setMethod != null && (types.isAssignable(elemType, param2 = types.memberType(indexedType, setMethod).getParameterTypes().get(1)) || ManAttr.isAssignableWithGenerics(types, elemType, param2))) {
                return setMethod;
            }
        }
        return null;
    }

    public static Symbol.MethodSymbol resolveOperatorMethod(Types types, JCTree.Tag tag, Type left, Type right) {
        String opName = BINARY_OP_TO_NAME.get((Object)tag);
        if (opName == null) {
            if (ManAttr.isComparableOperator(tag)) {
                opName = COMPARE_TO_USING;
            } else {
                return null;
            }
        }
        if (left instanceof Type.TypeVar) {
            left = types.erasure(left);
        }
        if (!(left.tsym instanceof Symbol.ClassSymbol)) {
            return null;
        }
        int paramCount = opName.equals(COMPARE_TO_USING) ? 2 : 1;
        Symbol.MethodSymbol methodSymbol = ManAttr.getMethodSymbol(types, left, right, opName, (Symbol.ClassSymbol)left.tsym, paramCount);
        if (methodSymbol == null && paramCount == 2 && !left.isPrimitive() && ManAttr.isRelationalOperator(tag)) {
            methodSymbol = ManAttr.getMethodSymbol(types, left, right, COMPARE_TO, (Symbol.ClassSymbol)left.tsym, 1);
        }
        return methodSymbol;
    }

    public static Symbol.MethodSymbol getMethodSymbol(Types types, Type left, Type right, String opName, Symbol.ClassSymbol sym, int paramCount) {
        Symbol.MethodSymbol methodSymbol = ManAttr.getMethodSymbol(types, left, right, opName, sym, paramCount, (t1, t2) -> types.isSameType((Type)t1, (Type)t2));
        if (methodSymbol != null) {
            return methodSymbol;
        }
        return ManAttr.getMethodSymbol(types, left, right, opName, sym, paramCount, (t1, t2) -> types.isAssignable((Type)t1, (Type)t2) || ManAttr.isAssignableWithGenerics(types, t1, t2));
    }

    public static boolean isAssignableWithGenerics(Types types, Type t1, Type t2) {
        if (t2 instanceof Type.TypeVar) {
            Type parameterizedParamType = types.asSuper(t1, t2.getUpperBound().tsym);
            return parameterizedParamType != null;
        }
        return false;
    }

    public static Symbol.MethodSymbol getMethodSymbol(Types types, Type left, Type right, String opName, Symbol.ClassSymbol sym, int paramCount, BiPredicate<Type, Type> matcher) {
        Symbol.MethodSymbol m;
        if (sym == null) {
            return null;
        }
        for (Symbol member : IDynamicJdk.instance().getMembers(sym, e -> e instanceof Symbol.MethodSymbol)) {
            Symbol.MethodSymbol m2 = (Symbol.MethodSymbol)member;
            if (ManAttr.isSynthetic(m2) || m2.params().size() != paramCount || !opName.equals(((Name)m2.getSimpleName()).toString())) continue;
            if (paramCount == 0) {
                return m2;
            }
            Type parameterizedMethod = types.memberType(left, m2);
            while (parameterizedMethod instanceof Type.ForAll) {
                parameterizedMethod = parameterizedMethod.asMethodType();
            }
            if (!matcher.test(right, parameterizedMethod.getParameterTypes().get(0))) continue;
            return m2;
        }
        Type superclass = sym.getSuperclass();
        if (superclass != null && (m = ManAttr.getMethodSymbol(types, left, right, opName, (Symbol.ClassSymbol)superclass.tsym, paramCount, matcher)) != null) {
            return m;
        }
        for (Type iface : sym.getInterfaces()) {
            Symbol.MethodSymbol m3 = ManAttr.getMethodSymbol(types, left, right, opName, (Symbol.ClassSymbol)iface.tsym, paramCount, matcher);
            if (m3 == null) continue;
            return m3;
        }
        return null;
    }

    public static boolean isSynthetic(Symbol.MethodSymbol m) {
        return (m.flags() & 0x1000L) != 0L || (m.flags() & 0x80000000L) != 0L;
    }

    public static boolean isComparableOperator(JCTree.Tag tag) {
        return tag == JCTree.Tag.EQ || tag == JCTree.Tag.NE || tag == JCTree.Tag.LT || tag == JCTree.Tag.LE || tag == JCTree.Tag.GT || tag == JCTree.Tag.GE;
    }

    public static boolean isRelationalOperator(JCTree.Tag tag) {
        return tag == JCTree.Tag.LT || tag == JCTree.Tag.LE || tag == JCTree.Tag.GT || tag == JCTree.Tag.GE;
    }

    public static boolean isCommutative(JCTree.Tag tag) {
        return tag == JCTree.Tag.PLUS || tag == JCTree.Tag.MUL || tag == JCTree.Tag.BITOR || tag == JCTree.Tag.BITXOR || tag == JCTree.Tag.BITAND || tag == JCTree.Tag.EQ || tag == JCTree.Tag.NE;
    }

    public static class MyRuntimeException
    extends RuntimeException {
        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class MyDiagnosticHandler
    extends Log.DiagnosticHandler {
        MyDiagnosticHandler(Log log) {
            this.install(log);
        }

        @Override
        public void report(JCDiagnostic jcDiagnostic) {
            this.prev.report(jcDiagnostic);
        }
    }
}

