/*
 * Decompiled with CFR 0.152.
 */
package manifold.internal.javac;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class InMemoryClassJavaFileObject
extends SimpleJavaFileObject {
    private final ByteArrayOutputStream _outputStream;
    private final String _className;

    public InMemoryClassJavaFileObject(String className, JavaFileObject.Kind kind) {
        super(URI.create("mem:///" + className.replace('.', '/') + kind.extension), kind);
        this._className = className;
        this._outputStream = new ByteArrayOutputStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return this._outputStream;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this._outputStream.size() > 0) {
            return new ByteArrayInputStream(this.getBytes());
        }
        return null;
    }

    public byte[] getBytes() {
        return this._outputStream.toByteArray();
    }

    public String getClassName() {
        return this._className;
    }
}

